#define NUEVO
using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;
using System.Runtime.InteropServices;

namespace Grafico
{
	/// <summary>
	/// Descripcin breve de FormBuscar.
	/// </summary>
	unsafe public class FormBuscarElementos : ControlesAt.FormTools
	{
		private System.Windows.Forms.Label Label1;
		private ControlesAt.Labeltf  Lbltftipo;
		private ControlesAt.LabelTexto TxtNombre;
		private ControlesAt.BotAceptar Buscar;
		private ListBox ListadeNombres;

		public string Tbuscar;
		private System.IntPtr nombres;
		private String current_text;

		PanelGrafico PanelPadre;
		public FormBuscarElementos(PanelGrafico Form1)
		{
			PanelPadre=Form1;
			InitializeComponent();
			this.AcceptButton=Buscar;

			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			this.Buscar.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			set_idioma(PanelPadre.Idioma);
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			Label1= new Label();			Lbltftipo= new Labeltf(6);
			TxtNombre= new LabelTexto();
			Buscar= new BotAceptar();
			ListadeNombres=new ListBox();
			//
			// Label1
			//
			Label1.FlatStyle= FlatStyle.System;
			Label1.Location= new Point(4, 12);
			Label1.Size= new Size(88, 16);
			Label1.TabIndex= 0;
			Label1.TextAlign= ContentAlignment.TopRight;
			//
			// Lbltftipo
			//
			Lbltftipo.Location= new Point(94, 12);
			Lbltftipo.Width= 230;
			Lbltftipo.TabIndex= 1;
			Lbltftipo.IndexChanged+= new EventVoid(Tipo_Changed);
			//
			// TxtNombre
			//
			TxtNombre.TextLocation= new Point(94, 44);
			TxtNombre.TextWidth= 110; //, 20);
			TxtNombre.TabIndex= 2;
			TxtNombre.T.KeyUp+=new KeyEventHandler(TxtNombre_KeyUp);
			//
			// Buscar
			//
			Buscar.Location= new Point(252, 44);
			Buscar.Size= new Size(72, 20);
			Buscar.TabIndex= 4;
			Buscar.Click+= new EventHandler(Buscar_Click);
			//
			// ListadeNombres
			//
			ListadeNombres.Location=new Point(8,76);
			ListadeNombres.Width=304;
			ListadeNombres.MultiColumn=true;
			ListadeNombres.BorderStyle= BorderStyle.Fixed3D;
			ListadeNombres.ColumnWidth=60;
			ListadeNombres.SelectedValueChanged+=new EventHandler(ListadeNombres_SelectedValueChanged);
			//
			// FormBuscar
			//
			this.MinimumSize= new Size(338,140);
			this.ClientSize= new Size(378, 200);
			this.Controls.Add(ListadeNombres);
			this.Controls.Add(Buscar);
			this.Controls.Add(TxtNombre);
			this.Controls.Add(Lbltftipo);
			this.Controls.Add(Label1);
			this.BorderMode= BorderMode.PanelSizableAll;
		}
	#endregion

		protected override void /*OnLoad*/OnVisibleChanged(EventArgs e){
			base.OnVisibleChanged(e);
			if(this.Visible==false) return;
			set_idioma(PanelPadre.Idioma);
			nombres=System.IntPtr.Zero;
			Tipo_Changed();
		}
		protected override void OnClosing(System.ComponentModel.CancelEventArgs e){
			e.Cancel=true;
			if(nombres!=System.IntPtr.Zero){
				InterComGrafico.graficos_free(nombres);
				nombres=System.IntPtr.Zero;
			}
			this.Hide();
		}

		protected override void OnSizeChanged(EventArgs e){
			base.OnSizeChanged (e);
			if(ListadeNombres==null) return;
			ListadeNombres.Size= this.ClientSize-new Size(ListadeNombres.Left+4,ListadeNombres.Top+4);
		}

		private void Buscar_Click(object sender,System.EventArgs e){
		#if !NUEVO
			int i;
			byte tipom, tipoM, subtipom, subtipoM;
			byte busqueda;	//Vedi infra.

			if(nombres==System.IntPtr.Zero) return;
			if(ListadeNombres.SelectedIndex<0) return;

			tipom=tipoM=0;	//Gilipollas
			busqueda=0;
			subtipom=0;		subtipoM=255;
			switch(Lbltftipo.tipof){
			  case 0: tipom=8;	tipoM=8;		break;
			  case 1: tipom=0;	tipoM=0;		break;
			  case 2: case 3:
				tipom=1;	tipoM=1;
				busqueda=2;
				if(Lbltftipo.tipof==2) subtipom=007;
				else subtipom=/*070*/56;
				break;
			  case 4: case 5:
				tipom=2;	tipoM=4;
				busqueda=1;
				if(Lbltftipo.tipof==4){subtipom=0; subtipoM=0;}
				else{subtipom=1; subtipoM=2;}
				break;
			}
			//i=InterComGrafico.busca_portipo_e_indice(PanelPadre.otherdata,tipom,tipoM,busqueda,subtipom,subtipoM,(uint)ListadeNombres.SelectedIndex);
			i=-1;
			if(i==-1){
				PanelPadre.MessageBoxAT.Show(PanelPadre.textos(31));
				return;
			}
			PanelPadre.encuentra((uint)i);
		#endif
		}

		internal void Tipo_Changed(){
		#if !NUEVO
			uint** pnombre;
			byte tipom, tipoM, subtipom, subtipoM;
			byte busqueda;	//0: todos los subtipos; 1: entre m y M;
								//2: que tenga algn bit de los de subtipom a 1; 3: que tenga todos los bits de subtipom a 1.
								//4: que est alguno de subtipom y alguno de subtipoM
								//5: que est alguno de subtipom y todos de subtipoM
		#endif

			if(nombres!=System.IntPtr.Zero) InterComGrafico.graficos_free(nombres);

		#if !NUEVO
			if(PanelPadre.tamanno==0)
		#else
			if(PanelPadre.titulo==null)
		#endif
			{nombres=System.IntPtr.Zero; return;}

		#if !NUEVO
			tipom=tipoM=0;	//Gilipollas
			busqueda=0;
			subtipom=0;		subtipoM=255;
			switch(Lbltftipo.tipof){
			  case 0: tipom=8;	tipoM=8;		break;
			  case 1: tipom=0;	tipoM=0;		break;
			  case 2: case 3:
				tipom=1;	tipoM=1;
				busqueda=2;
				if(Lbltftipo.tipof==2) subtipom=007;
				else subtipom=/*070*/56;
				break;
			  case 4: case 5:
				tipom=2;	tipoM=4;
				busqueda=1;
				if(Lbltftipo.tipof==4){subtipom=0; subtipoM=0;}
				else{subtipom=1; subtipoM=2;}
				break;
			}
			nombres=InterComGrafico.busca_portipo(PanelPadre.otherdata,tipom,tipoM,busqueda,subtipom,subtipoM);
			ListadeNombres.BeginUpdate();
			ListadeNombres.Items.Clear();
			System.IntPtr paux=PanelPadre.pfdibujo;
			int ppp=paux.ToInt32();
			for(pnombre=(uint**)nombres.ToPointer(); *pnombre!=(uint*)System.IntPtr.Zero.ToPointer(); pnombre++){
				ListadeNombres.Items.Add(Marshal.PtrToStringAnsi( new IntPtr(ppp+4*(*pnombre+1)) ));
			}
		#else
			nombres=IntPtr.Zero;
			ListadeNombres.BeginUpdate();
			ListadeNombres.Items.Clear();
		#endif
			ListadeNombres.EndUpdate();
			TxtNombre_KeyUp(this, new KeyEventArgs(Keys.End));
		}

		private void ListadeNombres_SelectedValueChanged(object sender,EventArgs e){
			TxtNombre.Text=ListadeNombres.SelectedItem.ToString();
		}
		void TxtNombre_KeyUp(object sender,KeyEventArgs e){
			if(TxtNombre.Text=="") return;
			int i,j;
			j=ListadeNombres.FindString(TxtNombre.Text);
			if(j==-1) return;
			current_text=TxtNombre.Text;
			if(ListadeNombres.Items.Count==j+1){	//bug del .NET
				if(ListadeNombres.Items[j].ToString()==TxtNombre.Text) i=j;
				else i=-1;
			}else{
				i=ListadeNombres.FindStringExact(TxtNombre.Text,j);
			}
			if(i==-1) i=j;
			ListadeNombres.SelectedIndex=i;
			TxtNombre.T.Select(current_text.Length,TxtNombre.Text.Length-current_text.Length);
		}

		internal void borra(){
			if(nombres!=System.IntPtr.Zero){
				InterComGrafico.graficos_free(nombres);
				nombres=System.IntPtr.Zero;
			}
			ListadeNombres.Items.Clear();
		}

		protected override void update_idioma(){
			switch(idioma){
				case Globales.Idioma.Eng:
					this.Text="Find elements";
					Label1.Text="Element type:";
					TxtNombre.L.Text="Name:";
					Lbltftipo.set_textos(new string[]{"Photograph", "Point", "Control point", "Check point", "Precision components of c.p.", "Precision components of point"});
					Buscar.Text="Find";
					break;
				case Globales.Idioma.It:
					this.Text="Trova elementi";
					Label1.Text="Tipo di elemento:";
					TxtNombre.L.Text="Nome:";
					Lbltftipo.set_textos(new string[]{"Fotogramma", "Punto", "Punto di appoggio", "Punto di controllo", "Componenti di precisione di c.p.", "Componenti di precisioni di punto"});
					Buscar.Text="Trova";
					break;
				default:
					this.Text="Buscar elementos";
					Label1.Text="Tipo de elemento:";
					TxtNombre.L.Text="Nombre:";
					Lbltftipo.set_textos(new string[]{"Fotograma", "Punto", "Punto de apoyo", "Punto de control", "Componente de precisin de c.p.", "Componente de precisin de punto"});
					Buscar.Text="Buscar";
					break;
			}
			Lbltftipo.actualiza();
		}
	}
}
