﻿#include "ClaseSistema.h"
#include <math.h>
#include "Geodesica.h"
#include <stdbool.h>

/*Los nombres de función de tipo aaa___bbb se leen como la función aaa(bbb). Por ejemplo, geo___proy se lee
geo(proy), es decir, es la función que obtiene las coordenadas geográficas a partir de las coordenadas en la
proyección.

	Un elemento de tipo Sistema define dos sistemas de coordenadas: la proyección cartográfica y
un sistema local. Si a estos se añaden las coordenadas geográficas hacen tres sistemas. Para muchas
aplicaciones el sistema local no es necesario.
	Si simplemente se quiere pasar un punto de geográficas a la proyección o viceversa se emplearán
las funciones proy___geo1 y geo___proy1.
	LOS VALORES DE λ SE INTERPRETAN SIEMPRE RESPECTO AL MERIDIANO CENTRAL. El valor
λ0 de la estructura sistema se ignora. Las funciones de esta librería nunca lo emplean.

	Los ejes del sistema local siguen la dirección de los de la proyección en el punto $local.proy$.
Para sistema=SIS_Geograficas, las funciones geo___proy y proy___geo multiplican o dividen por 180/PI
y si es necesario cambian el orden de las coordenadas (internamente la longitud se almacena en X, lat. en Y).

	Para llamar a cualquier función, la estructura Sistema ha de tener los valores precalculados ya calculados.
Para ello se llama a setup_Sistema(&sis). Sólo hace falta llamar a esta función una vez.
	Si se van a pasar coordenadsa al sistema local, el centro de este ha de elegirlo el programador y tiene que
asignarlo en coordenadas de la proyección, en $local.proy$. Esto ha de hacerse TRAS haber llamado a
setup_Sistema. Con ese punto asignado las funciones funcionarán correctamente, y en cuanto sea necesario
transformarán ese punto a gegráficas y a geocéntricas, asignando las respectivas coordenadas en $local.geog$
y $local.geoc$. También calcularán $local.conv1$, que es el ángulo que forma la dirección del eje Y de la
proyección en el puto $local$ respecto al Norte geográfico, positivo hacia el E. Para Geográficas y Mercator
$local.conv1$ será siempre cero.

Para el sistema de coordenadas SIS_Conforme (conforme local) no se emplean los pasos proy___geo y
XYZlocal___proy, sino que las funciones XYZlocal___proy y proy___XYZlocal transforman directamente. En
ese caso la función proy___XYZlocal copia los valores de $local.proy$ en $local.geog$ y $local.geoc$ y el valor
de $param1.conv0$, multiplicado por PI/180, en $conv1$.

Las funciones XYZlocal___geo y geo___XYZlocal trabajan con alturas elipsoidales. El paso desde/a alturas
geoidales se efectua en las funciones XYZlocal___proy y proy___XYZlocal.*/

/*Si un parámetro para una función que transforma es Puntoxy_double*, quiere decir que se espera
un array (que puede constar de un único elemento) de elementos cuyos dos primeros campos sean
dos double's, que alamcenan las coordenadas (x,y) o bien (λ,φ). El elemento puede tener más campos
a continuación. Puede por ejemplo ser un PuntoXYZ_double. Por ello el segundo parámetro que recibe
la función es un 'size', el tamaño de cada elemento del array de los que se han pasado a la función.
Si n=0 o n=1 size no se llega a emplear.
	Análogamente, las funciones que reciben un PuntoXYZ_double*, esperan un elemento cuyos
tres primeros campos sean tres double's: (X,Y,Z), pero puede tener más.
*/

#ifdef __cplusplus
extern "C"{
#endif
//double kUTM___xy(double a,double e, double x,double y,double k0);
//double kLambert___φ(double a, double e, double sinφ0, double φ);

/*
setup_Sistema: 
	Recibe un sistema con la estrucutura sis->sis completa; es decir, con la información que
	define el sistema ya completa. Calcula los valores que llama "precalculados" y pone nulo (NaN)
	el punto local.

cmp_Sistema:
	Compara dos sistemas de coordenadas. Devuelve false si son iguales y true si son distintos.

setup_sistema_<sistema>:
	Recibe un sistema sin nada. Asigna valores de manera que sea la proyección indicada
	en el nombre de la función, para el elipsode GRS80/WGS84, excepto las estereográficas
	polares que asignan una esfera. φ0 y Λ0 se reciben en grados.
*/
void setup_Sistema(Sistema *sis);
bint cmp_Sistema(const Sistema* sis1,const Sistema *sis2);
void setup_Sistema_UTM_Norte(Sistema *sis, double Λ0);
void setup_Sistema_UTM_Sur(Sistema *sis, double Λ0);
void setup_Sistema_Estereo_Norte(Sistema *sis, double Λ0);
void setup_Sistema_Estereo_Sur(Sistema *sis, double Λ0);
void setup_Sistema_Estereográfica(Sistema *sis, double φ0, double Λ0);
void setup_Sistema_Sinusoidal(Sistema *sis, double Λ0);
void setup_Sistema_Sinusoidal_ex(Sistema *sis, double Λ0, double ky, double α);

//Funciones para un punto
Puntoxy_double geo___proy1(const Sistema* sis, Puntoxy_double p);
Puntoxy_double proy___geo1(const Sistema *sis, Puntoxy_double g);

//Funciones para un array de puntos
int geo___proy(Puntoxy_double*,uint size,uint n,const Sistema* sis);
//Establece local.geog si aún no está y si local.proy está asignado
int geo___proyL(Puntoxy_double*,uint size,uint n,Sistema* sis);
void XYZlocal___geo(PuntoXYZ_double*,uint size,uint n, Sistema* sis);
int geo___XYZlocal(PuntoXYZ_double*,uint size,uint n, const Sistema* sis);
int proy___geo(Puntoxy_double*,uint size,uint n,const Sistema* sis);
//tranforma la rotaciones de la proyección al sistema local (si sentido=0) o viceveresa (si sentido=1).
//Los puntos tienen que venir en coordenadas geográficas. conv1 tiene que estar calculado
void transforma_rotaciones(PuntoXYZM_double*,uint size,uint n, const Sistema* sis, bint sentido);
void XYZlocal___proy(bint soncentros, PuntoXYZM_double* centros,uint size,uint n, Sistema* sis);
int proy___XYZlocal(bint soncentros, PuntoXYZM_double* centros,uint size,uint n, const Sistema* sis);

sinline void XYZlocal___proy_P(PuntoXYZ_double* puntos,uint size,uint n, Sistema* sis){
	XYZlocal___proy(false,(PuntoXYZM_double*)puntos,size,n,sis);
}
sinline void XYZlocal___proy_PM(PuntoXYZM_double* centros,uint size,uint n, Sistema* sis){
	XYZlocal___proy(true,centros,size,n,sis);
}
sinline int proy___XYZlocal_P(PuntoXYZ_double* puntos,uint size,uint n, const Sistema* sis){
	return proy___XYZlocal(false,(PuntoXYZM_double*)puntos,size,n,sis);
}
sinline int proy___XYZlocal_PM(PuntoXYZM_double* centros,uint size,uint n, const Sistema* sis){
	return proy___XYZlocal(true,centros,size,n,sis);
}

//Funciones para arrays de punteros
int geo___proy_p(Puntoxy_double**,uint n,const Sistema* sis);
int geo___proyL_p(Puntoxy_double**,uint n,Sistema* sis);
void XYZlocal___geo_p(PuntoXYZ_double**,uint n, Sistema* sis);
int geo___XYZlocal_p(PuntoXYZ_double**,uint n, const Sistema* sis);
int proy___geo_p(Puntoxy_double**,uint n,const Sistema* sis);
void transforma_rotaciones_p(PuntoXYZM_double**,uint n, const Sistema* sis, bint sentido);
void XYZlocal___proy_p(bint soncentros, PuntoXYZM_double** centros,uint n, Sistema* sis);
int proy___XYZlocal_p(bint soncentros, PuntoXYZM_double** centros,uint n, const Sistema* sis);

sinline void XYZlocal___proy_pP(PuntoXYZ_double** puntos,uint n, Sistema* sis){
	XYZlocal___proy_p(false,(PuntoXYZM_double**)puntos,n,sis);
}
sinline void XYZlocal___proy_pPM(PuntoXYZM_double** centros,uint n, Sistema* sis){
	XYZlocal___proy_p(true,centros,n,sis);
}
sinline int proy___XYZlocal_pP(PuntoXYZ_double** puntos,uint n, const Sistema* sis){
	return proy___XYZlocal_p(false,(PuntoXYZM_double**)puntos,n,sis);
}
sinline int proy___XYZlocal_pPM(PuntoXYZM_double** centros,uint n, const Sistema* sis){
	return proy___XYZlocal_p(true,centros,n,sis);
}

//Transformación de rectángulos Extremos2D
Extremos2D_dbl rect_proy___rect_geog(Extremos2D_dbl geog, const Sistema *sis);

#ifdef __cplusplus
}
#endif
