﻿#include <float.h>

/******---------        FLOATING POINT TYPES        ---------******/

/*A type for logically float variables which may actually be double if that is more efficient. The
type in the standard for that is float_t. However, this may even be long double and that may not
be wanted. Therefore AT_fastFloat is used instead.
    As happens with fast integer types, different compilers may assign the macro FLT_EVAL_METHOD
different values for the same architecture. Unlike for fast integer types there is no good default
solution, so if you want to preserve compatibility between compiled binaries and header files
don't expose this type in header files. */
#ifndef NO_fastFloat
	#if FLT_EVAL_METHOD==0
	typedef float AT_fastFloat;
	#else
	typedef double AT_fastFloat;
	#endif
#endif

/*A type for representing half precision numbers.*/
#ifndef FloatHalf_defined
	typedef int_least16_t FloatHalf;
#endif


/******---------        OTHER DEFINITIONS        ---------******/

/*Define to non-zero if
a)	float, double and FloatHalf respec. are internally represented according to the IEEE specifications.
	But denormalized numbers need not be respected nor do infinity and NANs as long as any number
	that according to the IEEE interpretation of the bits is infinity or NAN tests to false in
	isfinite(x).
b)	* For ATCRT_FLOAT, sizeof(uint)==sizeof(float), and if there are padding or parity bits the
	position of regular bits, bit per bit (that is, the 1st, the 2nd, up to the 32th), is the same in
	both types as well as corresponding parity bits if any.
	* For ATCRT_DOUBLE, a sizeof(uint)-byte aligned pointer may be interpreted as pointer to
	double (and its contents set or retrived) and the analogous condition as to the position
	of regular and parity bits as that for ATCRT_FLOAT bits holds.
	* For ATCRT_HALF, the type FloatHalf is a typedef for an actual floating point type, not a
	16 bit integer or other. */
#ifndef ATCRT_FLOAT
	#define ATCRT_FLOAT 1
#endif
#if COMPILER_ID==0			//No default here. The possibility of aligning a double to a 4-byte
	#define ATCRT_DOUBLE 1	//boundary does not seem to me universal enough to make it a default.
#endif
#ifndef ATCRT_HALF
	#define ATCRT_HALF 0
#endif

//Conversion from FloatHalf to float. x must be a finite, normalized number
#if ATCRT_HALF
#define float___FLoatHalf(x) ((float)(x))
#elif ATCRT_FLOAT
#define float___FLoatHalf(x) ((union{ssint s; float f;}){((x&0x8000)<<16) | (((x&0x7FFF)+(112<<10))<<13)}).f
#endif
