﻿/*Endianness

GNU defines LITTLE_ENDIAN as 1234 and BIG_ENDIAN as 4321, which is as arbitray as the
opposite definition would, and therefore as difficult to remember as left/right, port/starboard, etc.
We avoid that, but check for the presence of the GNU macros in order to automatically define ours.
    The default definition is to little endian.
*/
#define ATBYTES_LITTLE_ENDIAN 1
#define ATBYTES_BIG_ENDIAN 2

#ifndef ATBYTES_MACHINE
#if !defined(BYTE_ORDER) && defined(__BYTE_ORDER__)
	#define BYTE_ORDER __BYTE_ORDER__
#endif
#ifdef BYTE_ORDER
	#if defined(LITTLE_ENDIAN) && BYTE_ORDER==LITTLE_ENDIAN
		#define ATBYTES_MACHINE ATBYTES_LITTLE_ENDIAN
	#elif defined(BIG_ENDIAN) && BYTE_ORDER==BIG_ENDIAN
		#define ATBYTES_MACHINE ATBYTES_BIG_ENDIAN
	#endif
#endif
#endif
/*define to BIG_ENDIAN if big endian*/
#ifndef  ATBYTES_MACHINE
	#define ATBYTES_MACHINE ATBYTES_LITTLE_ENDIAN
#endif

//A macro for describing a file endianness, meaning "the same endianness as the implementation's"
#define ATFILE_ENDIAN_UNSET 0
