#pragma once

#ifndef mergestring
	#define _makestring(s) #s
	#define _merge(a,b) a##b
	#define _mergestring(a,b) _makestring(a##b)
	#define merge(a,b) _merge(a,b)
	#define mergestring(a,b) _mergestring(a,b)
#endif

#define MSC_ID 1
#define CLANG_ID 2
#define PORTLAND_ID 3
#define GCC_ID 4
#ifdef __clang__
	#define COMPILER CLANG
	#define COMPILER_ID CLANG_ID
#elif defined __GNUC__
	#define COMPILER GCC
	#define COMPILER_ID GCC_ID
#elif defined(_MSC_VER)
	#define COMPILER MSC
	#define COMPILER_ID MSC_ID
#else
	#define COMPILER C
	#define COMPILER_ID 0  //No compiler defined
#endif

#define SYSWin_ID 1
#define SYSUnix_ID 2
#ifdef __unix__
	#define SYSTEM Unix
	#define SYSTEM_ID SYSUnix_ID
#elif defined( _WIN32)
	#define SYSTEM Win
	#define SYSTEM_ID SYSWin_ID
#else
	#undef SYSTEM  //No System
	#define SYSTEM_ID 0
#endif
