#pragma once
#include "ATsystem.h"
#include "ATfunctions.h"

#ifdef __cplusplus
extern "C"{
#endif
//Copia en s1 la concatenación de las cadenas t0, t1, ... Un NULL marca el final
char8_t* strbuild8(char8_t* s1, const char8_t* t0, ...);
char16_t* strbuild16(char16_t* s1, const char16_t* t0, ...);
//'w' para char16_t*, 'c' para char* o char8_t*, '\0' para terminar
char16_t* strbuild_mixed(char16_t* s1, int tipo0, ...);

//Transforms a utf-8 16-bit number into the said number. Returns s8 advanced (1,2 or 3 places)
char8_t* c16___u8(char16_t *s1, iconst char8_t* s8);
//Transforms a 16-bit number into its utf-8 16-bit codification. Returns s8 advanced (1,2 or 3 places)
char8_t* u8___c16(char8_t* s8, char16_t c16);

//These two transform a string of utf-8 encoded 16-bits into an array of 16-bit chars
void str16___stru8(char16_t* s1, const char8_t* s2);
void str16___stru8n(char16_t* s1, const char8_t* s2, u16int n); //At most n characters are copied

//The following functions transform an array of 16-bit chars into an utf-8 array.

/*If s2 is NULL it returns the number of chars needed to store the string, including the terminating
'\0' character. Otherwise it assumes s2 has space enough and returns the number of chars written to s2.*/
int stru8___str8(char8_t* s2, const char8_t* s1);
/*If s2 is NULL it returns the number of chars needed to store the string, including the terminating
'\0' character. Otherwise it assumes s2 has space enough and returns the number of chars written to s2.*/
int stru8___str16(char8_t* s2, const char16_t* s1);
/*At most n char8_t's are written. Returns the number of characters written. Let k be the return value.
If s2[k-1]!='\0' after the call, there were more characters to be copied for which there was not room in s2.*/
int stru8___str16n(char8_t* s2, const char16_t* s1, u16int n);
/*If the transformed string consists of <=n char8_t's, copies the transformed string in s2 and returns s2.
Otherwise it attemps to reserve memory for the transformed string. If the allocation fails it returns NULL.
If it succeeds it returns the pointer to the allocated memory, where the string has been copied, which the
user is responsible for freeing. If the value passed for n is 0 the pointer s2 need not be a valid pointer and
the function will always try to allocate memory, since at least the terminating null char will have to be
stored in the transformed string.*/
char8_t* stru8___str16n_alloc(char8_t* s2, const char16_t* s1, u16int n);

/*En las siguientes funciones el puntero *ps se deja apuntando al caracter que detuvo la lectura*/

//Estas funciones son rápidas. No permiten signo '+' ni comprueban overflow
static inline uint uint___str8(iconst char8_t** ps);
static inline uint hex___str8(iconst char8_t **ps);
static inline uint oct___str8(iconst char8_t **ps);
static inline uint bin___str8(iconst char8_t **ps);
static inline uint uint___str16(iconst char16_t **ps);
static inline uint hex___str16(iconst char16_t **ps);
static inline uint oct___str16(iconst char16_t **ps);
static inline uint bin___str16(iconst char16_t **ps);

#ifndef FUNCTION_uint___str8
static inline uint uint___str8(iconst char8_t** ps){
	const char8_t *s1=*ps;
	unsigned int c, x=0;
	while((c=*s1-'0')<10){s1++; x*=10; x+=c;}
	*ps=s1;
	return (uint)x;
}
#endif

#ifndef FUNCTION_hex___str8
static inline uint hex___str8(iconst char8_t **ps){
	const char8_t *s1=*ps;
	unsigned int c, x=0;
#if 'A' > '0'
	while((c=*s1-'0')<='F'-'0'){
	#if '9'+1 != 'A'
		if(c>='A'-'0') c-='A'-('9'+1);
		else if(c>'9') break; //ifunlike
	#endif
#else
	while((c=*s1-('A'-10U))<='9'-'A'+10){
		if(c>='0'-'A'+10) c-='0'-10U;
		else if(c>'F') break; //ifunlike
#endif
		s1++;
		x<<=4; x|=c;
	}
	*ps=s1;
	return (uint)x;
}
#endif

#ifndef FUNCTION_oct___str8
static inline uint oct___str8(iconst char8_t **ps){
	const char8_t *s1=*ps;
	unsigned int c, x=0;
	while((c=*s1-'0')<8){s1++; x<<=3; x|=c;}
	*ps=s1;
	return (uint)x;
}
#endif

#ifndef FUNCTION_bin___str8
uint bin___str8(iconst char8_t **ps){
	const char8_t *s1=*ps;
	unsigned int c, x=0;
	while((c=*s1-'0')<2){s1++; x<<=1; x|=c;}
	*ps=s1;
	return (uint)x;
}
#endif

#ifndef FUNCTION_uint___str16
static inline uint uint___str16(iconst char16_t **ps){
	const char16_t *s1=*ps;
	unsigned int c, x=0;
	while((c=*s1-u'0')<10){s1++; x*=10; x+=c;}
	*ps=s1;
	return (uint)x;
}
#endif

#ifndef FUNCTION_hex___str16
static inline uint hex___str16(iconst char16_t **ps){
	const char16_t *s1=*ps;
	unsigned int c, x=0;
#if u'A' > u'0'
	while((c=*s1-u'0')<=u'F'-u'0'){
	#if u'9'+1 != u'A'
		if(c>=u'A'-u'0') c-=u'A'-(u'9'+1);
		else if(c>u'9') break; //ifunlike
	#endif
#else
	while((c=*s1-(u'A'-10U))<=u'9'-u'A'+10){
		if(c>=u'0'-u'A'+10) c-=u'0'-10U;
		else if(c>u'F') break; //ifunlike
#endif
		s1++;
		x<<=4; x|=c;
	}
	*ps=s1;
	return (uint)x;
}
#endif

#ifndef FUNCTION_oct___str16
static inline uint oct___str16(iconst char16_t **ps){
	const char16_t *s1=*ps;
	unsigned int c, x=0;
	while((c=*s1-u'0')<8){s1++; x<<=3; x|=c;}
	*ps=s1;
	return (uint)x;
}
#endif

#ifndef FUNCTION_bin___str16
static inline uint bin___str16(iconst char16_t **ps){
	const char16_t *s1=*ps;
	unsigned int c, x=0;
	while((c=*s1-'0')<2){s1++; x<<=1; x|=c;}
	*ps=s1;
	return (uint)x;
}
#endif

double double___str8(iconst char8_t** ps);	//Permite exponentes. E.g. 1.0E3
double vfdouble___str8(iconst char8_t** ps); //No permite exponentes
uint uint_check___str8(iconst char8_t** ps); //Si el número es demasiado grande devuelve (uint)-1 y ps queda apuntando a una cifra
ssint ssint___str8(iconst char8_t **ps);
ssint ssint_check___str8(iconst char8_t** ps); //Si el número es demasiado grande devuelve (ssint)-0x8000000 y ps queda apuntando a una cifra

uint basedinteger___str8(iconst char8_t **ps);

double double___str16(iconst char16_t **ps);
double vfdouble___str16(iconst char16_t **ps);
uint uint_check___str16(iconst char16_t** ps); //Si el número es demasiado grande devuelve (uint)-1 y ps queda apuntando a una cifra
ssint ssint___str16(iconst char16_t **ps);
ssint ssint_check___str16(iconst char16_t** ps); //Si el número es demasiado grande devuelve (ssint)-0x8000000 y ps queda apuntando a una cifra
uint basedinteger___str16(iconst char16_t **ps);

char8_t* str8___uint(char8_t* ptr, uint x);
char16_t* str16___uint(char16_t* ptr, uint x);

//Escriben un tiempo en minutos. E.g.:
//2 h 35 m
//bl: indica cómo se abrevian los minutos:
//	0: m.  1: min.  2: minutos.
char8_t* str8___t_min(char8_t* ptr, uint t_min, umint bl);
char16_t* str16___t_min(char16_t* ptr, uint t_min, umint bl);
#ifdef __cplusplus
}
#endif

/*En las siguientes fuciones, si endptr no es NULL, en él se escribe la & del caracter que detuvo la lectura*/

static inline double double___str8_p(iconst char8_t* s1, iconst char8_t **endptr){
	double x=double___str8(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline double vfdouble___str8_p(iconst char8_t* s1, iconst char8_t **endptr){
	double x=vfdouble___str8(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline uint uint___str8_p(iconst char8_t* s1, iconst char8_t **endptr){
	uint x=uint___str8(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline ssint ssint___str8_p(iconst char8_t* s1, iconst char8_t **endptr){
	ssint x=ssint___str8(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline uint hex___str8_p(iconst char8_t* s1, iconst char8_t **endptr){
	uint x=hex___str8(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline uint oct___str8_p(iconst char8_t* s1, iconst char8_t **endptr){
	uint x=oct___str8(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline uint basedinteger___str8_p(iconst char8_t* s1, iconst char8_t **endptr){
	uint x=basedinteger___str8(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}

static inline double double___str16_p(iconst char16_t* s1, iconst char16_t **endptr){
	double x=double___str16(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline double vfdouble___str16_p(iconst char16_t* s1, iconst char16_t **endptr){
	double x=vfdouble___str16(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline uint uint___str16_p(iconst char16_t* s1, iconst char16_t **endptr){
	uint x=uint___str16(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline ssint ssint___str16_p(iconst char16_t* s1, iconst char16_t **endptr){
	ssint x=ssint___str16(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline uint hex___str16_p(iconst char16_t* s1, iconst char16_t **endptr){
	uint x=hex___str16(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline uint oct___str16_p(iconst char16_t* s1, iconst char16_t **endptr){
	uint x=oct___str16(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}
static inline uint basedinteger___str16_p(iconst char16_t* s1, iconst char16_t **endptr){
	uint x=basedinteger___str16(&s1);
	if(endptr!=NULL) *endptr=s1;
	return x;
}

#define chars___chars16(char_string,char16_string) \
	 {char *_ptr; const char16_t *_ptrw; _ptr=char_string; _ptrw=char16_string; whilenz(*_ptr++=(char)*_ptrw++);}

#define chars8___chars16(char_string,char16_string) \
	 {char8_t *_ptr; const char16_t *_ptrw; _ptr=char_string; _ptrw=char16_string; whilenz(*_ptr++=(char8_t)*_ptrw++);}

#define float___str8 (float)double___str8
#define vffloat___str8 (float)vfdouble___str8
#define float___str16 (float)double___str16
#define vffloat___str16 (float)vfdouble___str16
#define float___str8_p (float)double___str8_p
#define vffloat___str8_p (float)vfdouble___str8_p
#define float___str16_p (float)double___str16_p
#define vffloat___str16_p (float)vfdouble___str16_p
