#pragma once
#include "ATsystem.h"
#include <uchar.h>
//See Path_definitions_No.h for explanations
#ifndef SYSTEM
	#include "path_definitions_No.h"
#else
	#include mergestring(path_definitions_,SYSTEM.h)
#endif

#ifdef __cplusplus
extern "C"{
#endif
/*if *s=='\0' || Path_isthis(s) this function must return Path_back(s), and therefore in this case
s must have space enough for holding Path_back. Otherwise remove la última componente,
que se asume que es un directiorio. Si tras ello el resultado es una cadena vacía se devoverá
cadena vacía si es un path válido, en caso contrario se devolverá path_this*/
void path_go_back16(char16_t *s);
/*Remove embedded relative specifications (e.g., \.\ and \..\)*/
void path_clean8(char8_t *path);
void path_clean16(char16_t *path);

/*The result is stored in Path. If ruta is absolute it must return ruta (or a cleaned version of it).
If ruta is relative, it is to be understod relative to curr_path, and the path resulting thereof
must be retuned in Path. Si tras llamar a la función Path[buf_size-1]!='\0' es que la ruta
no ha cabido entera. Se asume que el espacio en Path es al menos tan grande como curr_path*/
void makepath8(char8_t* Path, u16int buf_size, const char8_t* curr_path, const char8_t* ruta);
void makepath16(char16_t* Path, u16int buf_size, const char16_t* curr_path, const char16_t* ruta);
/*Like the previous one, but takes care that Path is a valid directory path, provided curr_path
and ruta are. That is, it takes care of too long paths and removes as many components at the end
as necessary so that the result fits in buf_size length. The path returned in Path must be ended
by the directory separator.
The length of Path is returned in pth_length*/
void make_from_currentpath16(char16_t* Path, u16int buf_size, const char16_t* curr_path, const char16_t* ruta, uint* pth_length);

/*Avanza en path1 y path2 la parte común a ambos, devolviendo en ptr1 y ptr la dirección del primer
carácter correspondiente a la primera componente distinta en path1 y path2 respectivamente. Puede
ser el final de la cadena.*/
void pathskip_common16(const char16_t* path1, const char16_t* path2, const char16_t* *ptr1, const char16_t* *ptr2);
/*Obtiene la expresión como ruta relativa de filename respecto a pathref. El resultado se devuelve
en relpath. Si filename no es una ruta absoluta, en relpath se devuelve el propio filename (or a
cleaned version of it). Si relpath[0]=='\0' es que el resultado ocuparía más de buf_size chars.
Si pathref tiene componentes path_back más allá de la parte común con filename el resultado
es indeterminado.*/
void relative_path16(char16_t* relpath, u16int buf_size, const char16_t* pathref, const char16_t* filename);
/*Copia filename en directory y elimina el nombre del fichero. Si el resultado es menor que buf_size
devuelve 0. En caso contrario elimina tantos tramos de la ruta, empezando por el final y hacia atrás,
como sea necesario para que el resultado quepa en buf_size caracteres, y devuelve 1.
Si el resultado es una cadena vacía, copia en directory STR16_thisdir.
Si ptrfin no es NULL, *ptrfin queda apuntando al '\0' de final de cadena en directory*/
int remove_filename16(char16_t *directory, u16int buf_size, const char16_t* filename, char16_t **ptrfin);

#ifdef __cplusplus
}
#endif
