﻿#pragma once
#include "ATiflike.h"

/* Generic macros for various purposes. The names of the macros do not start with AT_ or ATmacro_
or the like, for those names would discourage their use and make the code less readeable. These are
just a bunch of useful utils, so just don't include this file if the names happen to collide with yours or
other library's.*/

/*There are not operators in C for testing the definition or declaration of symbols*/

//#ifndef cint
//_IF_not_defined(cint) typedef unsigned int cint;
//#endif

#define AddsufijoI(name,suf) name##_##suf
#define Addsufijo(name,suf) AddsufijoI(name,suf)


/*`If' STATEMENTS WITH ASSIGNMENTS IN THEM */

/* The intent of these macros is to prevent the compiler from issuing the "Assignment within
conditional" warning*/

#ifndef ifz
#define ifz(a) if((a)==0)
#define ifnz(a) if((a)!=0)
#endif
#ifndef whilez
#define whilez(a) while((a)==0)
#define whilenz(a) while((a)!=0)
#endif

#ifndef ifzlike
#define ifzlike(a) iflike((a)==0)
#define ifzunlike(a) ifunlike((a)==0)
#define ifnzlike(a) iflike((a)!=0)
#define ifnzunlike(a) ifunlike((a)!=0)
#endif

#ifndef ifonce		//This is not intended for ifonce(...) break;, for in those cases it is already
#define ifonce ifunlike	//known from the code that the conditional can only be true once.
#endif


/* FUNCIONES SOBRE MALLOC Y FREE Y USO DE PLIST DE ATMEM.H */

/* Funciones que no necesitan un objeto de tipo PLIST de ATmem.h ni la etiqueta <NOMEM_EXIT_LABEL>
o el código de return <NOMEM_RETURN_CODE> */

#define decl_malloc(type,var) type *var=(type*)malloc(sizeof(type))
#define n_malloc(type,n) (type*)malloc((n)*(unsigned int)sizeof(type))
#define checked_malloc(var,ptype,size,error_code) var=(ptype)malloc(size); ifunlike(var==NULL){error_code;}
#define checked_malloc_n(var,type,n,error_code) var=n_malloc(type,n); ifunlike(var==NULL){error_code;}
#define freeif(x) if((x)!=NULL) free(x)
#define free_null(x) free(x), x=NULL
#define free_null_if(x) if((x)!=NULL) free(x), x=NULL
#define functionfree_if(x,function) if((x)!=NULL) function(x)
#define functionfreenull_if(x,function) if((x)!=NULL){function(x); x=NULL;}

/* Funciones que necesitan el código de return <NOMEM_RETURN_CODE> o la etiqueta <NOMEM_EXIT_LABEL> */

#define aj_malloc_n(var,type,n) checked_malloc_n(var,type,n,goto NOMEM_EXIT_LABEL)
#define aj_decl_alloc_n(type,var,n) type* aj_malloc_n(var,type,n)
#define aj_malloc_return(var,type,n) checked_malloc_n(var,type,n,return NOMEM_RETURN_CODE)
#define aj_decl_alloc_return(type,var,n) type* aj_malloc_return(var,type,n)
#define aj_malloc_retNULL(var,type,n) checked_malloc_n(var,type,n,return NULL)
#define aj_decl_alloc_retNULL(type,var,n) type* aj_malloc_retNULL(var,type,n)

/* Funciones que necesitan un objeto de tipo PLIST, de ATmem.h */

#define return_ATplist free_plist(ATMEM_PLIST_NAME); return
#define Addto_delete_ind(a) addto_delete_ind(ATMEM_PLIST_NAME,(void**)(&a))
#define Addto_delete(a) addto_delete(ATMEM_PLIST_NAME,a)
#define Addto_delete_ind_if(a) if(a!=NULL) addto_delete_ind(ATMEM_PLIST_NAME,(void**)(&a))
#define Remove_from_delete(a) remove_from_delete(ATMEM_PLIST_NAME,(void**)(&(a)))
#define Free_down_to(a) free_down_to(ATMEM_PLIST_NAME,(void**)(&a))
#define Free_remove(a) free(a), Remove_from_delete(a)

/* Funciones que necesitan ambas cosas */

#define aj_malloc_add(var,type,n) aj_malloc_n(var,type,n); Addto_delete(var)
#define aj_malloc_add_ind(var,type,n) aj_malloc_n(var,type,n); Addto_delete_ind(var)
#define aj_decl_alloc_add(type,var,n) type* aj_malloc_add(var,type,n)

/* Funciones que inicializan Vectores, Growing's y Hashes, añadiendo a un PLIST.
Necesitan ATarrays.h */

#define VStdSetup(type,x,NN) Vsetup(type,x,NN,goto NOMEM_EXIT_LABEL); Addto_delete_ind((x).ppio)
#define GStdSetup(type,x,NN) Growing_setup(type,x,NN,goto NOMEM_EXIT_LABEL); Addto_delete_ind((x).ppio)
#define HStdSetupЯ(htype,x,n) HsetupЯ(htype,x,n,goto NOMEM_EXIT_LABEL); Addto_delete_ind((x).ppio)
#define HStdSetupPointer(x,n) HsetupPointer(x,n,goto NOMEM_EXIT_LABEL); Addto_delete_ind((x).ppio)
#define HStdSetupString8(x,n) HsetupString8(x,n,goto NOMEM_EXIT_LABEL); Addto_delete_ind((x).ppio)
#define HStdSetupPtrUint(x,n) HsetupPtrUint(x,n,goto NOMEM_EXIT_LABEL); Addto_delete_ind((x).ppio)
#define HStdSetupStr8Uint(x,n) HsetupStr8Uint(x,n,goto NOMEM_EXIT_LABEL); Addto_delete_ind((x).ppio)
#define VSetupZero(x) (x).ppio=NULL; (x).n=(x).N=0; Addto_delete_ind((x).ppio)


/* `for' LOOPS GOING THROUGH AN ARRAY */

//Lower case ones: durch... and fallthru, increment the counter at each iteration.
//Uppercase ones: Durch... and Fallthru, do not.

/* Generic for loops */

/* fordown is used when the counter variable is going to be used inside the loop. dontimes when
//it is not. The unique identifier as the controlling var of the for loop is not needed, just so that
//the user does not get a warning of a definition hiding a previous visible definition. ex- stands
//for explicit, because the name of the counter variable is provided explicitely to the macro.*/
#define exfordown(n,third,lineid)			exfordownex(n,third,lineid)
#define exfordownex(n,third,lineid)		for(cint fordown_id##lineid=n;fordown_id##lineid-->=1;third)
#define dontimes(n,third)					exfordown(n,third,__LINE__)
#define fordown(it,n,third)					for(cint it=n;it-->=1;third)
#define fallvar(it,n,third)					cint it=n; for(;it-->=1;third)
#define FALLED(it) (it==(cint)-1)
#define fordown_nexecs(it,n)				(n-(it+1)) //Para emplear tras un fordown o fallvar. Indica cuántas veces
																//se entró en el cuerpo del bucle.

#define durchlaufe(ptr,type,array,n)		type *ptr=array; dontimes(n,ptr++)
#define durchlaufe_fwd(it,type,array,n)	type *ptr##it=array; for(uint it=0;it<n;it++,ptr##it++)
#define durchlaufep(type,array,n)			durchlaufe(p,type,array,n)
#define durchlaufei(type,array,n)			durchlaufe(ptri,type,array,n)
#define durchlaufej(type,array,n)			durchlaufe(ptrj,type,array,n)
#define durchlaufek(type,array,n)			durchlaufe(ptrk,type,array,n)
#define durchlaufe2(type,array,n,type_b,array_b) type *ptr=array; type_b *ptr_b=array_b; dontimes(n,(ptr++,ptr_b++))
#define durchlaufei_fwd(type,array,n)		durchlaufe_fwd(i,type,array,n)

#define Durchlaufe(ptr,type,array,n)		type *ptr=array; dontimes(n,)
#define Durchlaufe_fwd(it,type,array,n)	type *ptr##it=array; for(uint it=0;it<n;it++)
#define Durchlaufep(type,array,n)			Durchlaufe(p,type,array,n)
#define Durchlaufei(type,array,n)			Durchlaufe(ptri,type,array,n)
#define Durchlaufej(type,array,n)			Durchlaufe(ptrj,type,array,n)
#define Durchlaufek(type,array,n)			Durchlaufe(ptrk,type,array,n)
#define Durchlaufei_fwd(type,array,n)	Durchlaufe_fwd(i,type,array,n)
#define Durchlaufe2(type,array,n,type_b,array_b) type *ptr=array; type_b *ptr_b=array_b; dontimes(n,)
#define fallthru(it,type,array,n)				type *ptr##it=array; fallvar(it,n,ptr##it++)
#define Fallthru(it,type,array,n)			type *ptr##it=array; cint it=n; while(it-->=1)

/* Loops for Vectors and Hashes */

#define durchVector(ptr,type,vector) durchlaufe(ptr,type,(vector).ppio,(vector).n)
#define durchVector_fwd(it,type,vector) durchlaufe_fwd(it,type,(vector).ppio,(vector).n)
#define durchVectorp(type,vector)	durchVector(p,type,vector)
#define durchVectori(type,vector)	durchVector(ptri,type,vector)
#define durchVectorj(type,vector)	durchVector(ptrj,type,vector)
#define durchVectork(type,vector)	durchVector(ptrk,type,vector)
#define DurchVector(ptr,type,vector) Durchlaufe(ptr,type,(vector).ppio,(vector).n)
#define DurchVectorp(type,vector) DurchVector(p,type,vector)
#define DurchVectori(type,vector)	DurchVector(ptri,type,vector)
#define DurchVectorj(type,vector)	DurchVector(ptrj,type,vector)
#define DurchVectork(type,vector) DurchVector(ptrk,type,vector)
#define durchVectori_fwd(type,vector) durchVector_fwd(i,type,vector)
#define durchHash(ptr,htype,hash) durchlaufe(ptr,htype,(hash).ppio,(hash).N)
#define durchHashp(htype,hash) durchlaufep(htype,(hash).ppio,(hash).N)
#define durchHashi(htype,hash) durchlaufei(htype,(hash).ppio,(hash).N)
#define durchHashj(htype,hash) durchlaufej(htype,(hash).ppio,(hash).N)
#define durchHashk(htype,hash) durchlaufek(htype,(hash).ppio,(hash).N)
#define DurchHash(ptr,htype,hash) Durchlaufe(ptr,htype,(hash).ppio,(hash).N)
#define DurchHashp(htype,hash) Durchlaufep(htype,(hash).ppio,(hash).N)
#define DurchHashi(htype,hash) Durchlaufei(htype,(hash).ppio,(hash).N)
#define DurchHashj(htype,hash) Durchlaufej(htype,(hash).ppio,(hash).N)


//NOMEM_RETURN_CODE must be defined by the user.
//#define NOMEM_RETURN_CODE AT_NOMEM

#ifndef NOMEM_EXIT_LABEL
#define NOMEM_EXIT_LABEL salida_outofmem
#endif

#ifndef ATMEM_PLIST_NAME
#define ATMEM_PLIST_NAME plist
#endif
