#if !defined(AT_FILEINPUT_ALL) && !(defined(ATCRT_TYPES_ONLY) && defined(AT_FILEINPUT_TYPES))
//AT_FILEINPUT_TYPES defined at the end of the file
//AT_FILEINPUT_ALL will be defined if !defined(ATCRT_TYPES_ONLY)

#include "ATsystem.h"
#include <uchar.h>

//Valores de error devueltos por las funciones tiopen<> o biopen<>.
#define AT_NOMEM -2
#define ATFILEI_UNKNOWN -1		//none of the following
#define ATFILEI_BADPATH -3			//invalid path
#define ATFILEI_NOFILE -4				//El fichero no existe
#define ATFILEI_NOMORE -5			//cannot open more files
#define ATFILEI_NOTALLOWED -6	//no permission for reading that file
#define ATFILEI_LARGEFILE -7		//> ATFILEI_MAXSIZE (binary) o ATFILEI_MAXSIZE-1 (text) files are not allowed
#define ATFILE_MINERRROR -7
#define ATFILEI_MAXSIZE INT_MAX

/*Input of text files
pc is the pointer to the character to be read
*pc='\0' means the end of the data (file contents) has been reached*/
/*This macro provides a kind of inheritance facility*/

#ifndef AT_FILEINPUT_TYPES

#define Bufferti_BASE(Type) \
	void* vbase;\
	/*const*/ Type* pc;\
	Type* next;\
	Type savedchar;

typedef struct{
	Bufferti_BASE(char8_t)
} Bufferti8;
typedef struct{
	Bufferti_BASE(char16_t)
} Bufferti16;

#endif

#ifndef ATCRT_TYPES_ONLY

#include "AT_filenames.h"

#ifdef __cplusplus
extern "C"{
#endif
/*Funciones que abren un fichero y lo cargan en memoria para su lectura. El resultado es una estructura
Bufferti8 o Bufferti16 según el contenido del fichero se vaya a interpretar como codificado en char8_t o
en char16_t. Según lo que se quiera se ha de llamar a una función o a otra. A su vez, el nombre del fichero
puede pasarse a las funciones en una u otra codificación.
Return:
	> ATFILEI_MAXSIZE. Se produjo algún error. Los valores están definidos arriba.
	<= ATFILEI_MAXSIZE. El número de caracteres copiados al buffer.

Sea k el valor, <= ATFILEI_MAXSIZE, devuelto por la función. buf->pc[k] es el '\0' de cierre. Si el fichero
no termina en un '\n' la función lo añadirá, de modo que siempre se tendrá
		buf->pc[k-1]='\n'   y   buf->pc[k]='\0'

Para liberar la memoria reservada ha de hacerse free(buf->vbase) o bien llamar a ticlose(buf).

If you don't expect your file to be large you can use isneg(k) to test for error in place of k>ATFILEI_MAXSIZE.
*/

//'fichero' y el contenido del fichero están en char8_t. 'fichero' en la codific. propia del sistema operativo.
int tiopen8(Bufferti8 *buf, const char8_t* fichero);
//'fichero' está en char8_t en la codific. propia del sistema operativo. El contenido del fichero está en char16_t.
int tiopen_mixed(Bufferti8 *buf, const char16_t* fichero);
//'fichero' y el contenido del fichero están en char16_t.
int tiopen16(Bufferti16 *buf, const char16_t* fichero);
//'fichero' y el contenido del fichero están en char8_t. 'fichero' en en utf-8. Si utf-8 es la codificación de
//8-bit propia del s. o. esta función es idéntica que tiopen8.
int tiopen_utf8(Bufferti8 *buf, const char8_t* fichero);
#if FILE8BITS_ARE_UTF8
#define tiopen_utf8(buf,fichero) tiopen8(buf,fichero)
#endif
/*Estas dos funciones no reciben un nombre de fichero sino directamente un puntero a una región de memoria
que se quiere ir procesando como si fuera el contenido de un fichero. Las funciones crean un Bufferti8 o
Bufferti16 copiando ese contenido igual que si lo hubieran leído de un fichero.

size: Sin incluir el '\0' del final, si es que existe. Puede no existir.
Return: 0 o AT_NOMEM
*/
int tiopen_mem8(Bufferti8 *buf, const char8_t* contents, uint size);
int tiopen_mem16(Bufferti16 *buf, const char16_t* contents, uint size);
//
#define ticlose(buf) free((buf).vbase)

/*Si devuelven > ATFILEI_MAXSIZE es que se produjo algún error. Los valores están definidos arriba.
Si devuelven <= ATFILEI_MAXSIZE, el valor devuelto es el número de uints copiados al buffer.
En este último caso el que llama es responsable de liberar buf.
If you don't expect your file to be large you can use isneg(k) to test for error in place of k>ATFILEI_MAXSIZE.*/

//'fichero' está en char8_t, en la codificación propia del sistema operativo.
int biopen8(uint* *buf,const char8_t* fichero);
//'fichero' está en char16_t.
int biopen16(uint* *buf,const char16_t* fichero);
//fichero está en char8_t, codificado en utf-8. Si esta es la codificación de 8-bit propia del s. o. esta
//función es idéntica a biopen8.
int biopen_utf8(uint* *buf,const char8_t* fichero);
#if FILE8BITS_ARE_UTF8
#define biopen_utf8(buf,fichero) biopen8(buf,fichero)
#endif

#ifdef __cplusplus
}
#endif

#include "fileinput_macros.h"

#endif //ATCRT_TYPES_ONLY


/*************--------      EXTENSIONES      --------*************/

/*Aquí está definida la estructura, funciones y macros para un Bufferti que además va contando
el número de líneas. Se implementa como una extensión a Bufferti para que sirva de ejemplo para
otras extensiones*/

#ifndef AT_FILEINPUT_TYPES

#define Bufferti_lc_BASE(Type) \
	Bufferti_BASE(Type) uint lc;

typedef struct{
	Bufferti_lc_BASE(char8_t)
} Bufferti8_lc;

typedef struct{
	Bufferti_lc_BASE(char16_t)
} Bufferti16_lc;

#endif

#ifndef ATCRT_TYPES_ONLY
//To call after opening the buffer
#define Bufferti_lc_setup(buffer) (buffer).lc=1;  /*count starts at one*/

#define advance_LC(buffer) advanceinline(buffer); while(*(buffer).pc=='\n'){(buffer).pc++; (buffer).lc++; advanceinline(buffer);}
#define finishline_LC(buffer) if(*(buffer).pc!='\0'){while(*(buffer).pc!='\n') (buffer).pc++; (buffer).pc++; (buffer).lc++;}
#endif
//Input fileinput_linecount.h to use a Bufferti_lc buffer.


#define AT_FILEINPUT_TYPES
#if !defined(ATCRT_TYPES_ONLY)
	#define AT_FILEINPUT_ALL
#endif

#endif
