#pragma once

#ifndef RESTRICT
	#ifndef __cplusplus
	#define RESTRICT restrict
	#else
	#define RESTRICT
	#endif
#endif

#include <uchar.h>
/*IO4char8___str8: copying with conversion from compiler dependent char8_t to a series of 8-bit bytes stored
in an array of uints, and vice-versa. Each char8_t must be copied to one byte. If the char8_t has more than
8 bits it is assumed that the value will be less than 2^8 or that the higher bits store some different information.
The function may, but need not, fill the bytes of the last uint past the last copied character with zeros.
Analogously for IO2char16___str16.

For the functions char8/16___uint, the pointer char8/16_t* s1 must be alligned to uint size.*/

/*How many uints are necessary to hold n 8bit-chars or n 16bit-chars*/
#define NUINTS___NCHARS8(n) (((n)+3)>>2)
#define NUINTS___NCHARS16(n) (((n)+1)>>1)

typedef struct{
	IO4char8 *s;
	u8int b;	//b=0,1,2,3
} Pchar8;

typedef struct{
	IO2char16 *s;
	u8int b;	//b=0,1
} Pchar16;

//The standard imposes char16_t to be the same as uint_least16_t, i.e., as uint16m
#define IO4char8___uint8m(s1,const_s2,n) IO4char8___str8(s1,const_s2,n)

#if CHAR_BIT==8 && SIZEOF_UINT==4
#define IO4char8___str8(s1,s2,n) memcpy_char8((char8_t*)(s1),s2,n)
#define str8___IO4char8(s1,s2,n) memcpy_uint((uint*)(s1),s2,n)
#define str16___IO2char16(s1,s2,n) memcpy_uint((uint*)(s1),s2,n)

#else
static void IO4char8___str8(IO4char8* RESTRICT  s1, const char8_t* RESTRICT s2, uint n){
	uint n4;

	n4=n>>2;
	n-=n4<<2;
	while(n4--){
		IO4char8 c4=*s2++;
		c4|=(*s2++)<<8;
		c4|=(*s2++)<<16;
		c4|=(*s2++)<<24;
		*s1++=c4;
	};
	if(n){ n--;
		IO4char8 c4=*s2++;
		if(n--){
			c4|=(*s2++)<<8;
			if(n) c4|=*s2<<16;
		}
		*s1=c4;
	}
}

static inline void str8___IO4char8(char8_t* RESTRICT s1, const IO4char8* RESTRICT s2, uint n){
	while(n--){
		IO4char8 c4=*s2++;
		*s1++=c4&0xFFU; c4>>=8;
		*s1++=c4&0xFFU; c4>>=8;
		*s1++=c4&0xFFU; c4>>=8;
		*s1++=c4&0xFFU;
	}
}
static inline void str16___IO2char16(char16_t* RESTRICT s1, const IO2char16* RESTRICT s2, uint n){
	while(n--){
		IO2char16 c4=*s2++;
		*s1++=c4&0xFFFF; c4>>=16;
		*s1++=c4&0xFFFF;
	}
}
#endif

//The standard imposes char16_t to be the same as uint_least16_t, i.e., as uint16m
#define IO2char16___uint16m(s1,const_s2,n) IO2char16___str16(s1,const_s2,n)
static inline void IO2char16___str16(IO2char16* RESTRICT s1, const char16_t* RESTRICT s2, uint n){
	uint n4;

	n4=n>>1;
	while(n4--){
		IO2char16 c4=*s2++;
		c4|=(*s2++)<<16;
		*s1++=c4;
	};
	if(n&1) *s1=*s2;
}

//Siempre devuelven el puntero *tras* el '\0' del final
static inline uint* IO4char8_strpcpy_char8(IO4char8* RESTRICT  s1, const char8_t* RESTRICT s2){
	IO4char8 c4;
	u8int i32;

	c4=i32=0;
	do{
		c4|=(*s2 & 0xFF)<<i32;
		i32+=8;
		if(i32==32){*s1++=c4; c4=0, i32=0;}
	}while(*s2++);
	if(i32!=0) *s1++=c4;
	return s1;
}
static inline uint* IO2char16_strpcpy_char16(IO2char16* RESTRICT  s1, const char16_t* RESTRICT s2){
	do{
		IO2char16 c4=*s2 & 0xFFFF;
		if(*s2==u'\0'){*s1++=0; break;}
		s2++;
		c4|=(*s2 & 0xFFFF)<<16;
		*s1++=c4;
	}while(*s2++);
	return s1;
}
static inline uint* IO2char16_strnpcpy_char16(IO2char16* RESTRICT  s1, const char16_t* RESTRICT s2, u16int nmax){
	if(nmax==0) return s1;
	do{ nmax--;
		IO2char16 c4=*s2 & 0xFFFF;
		if(*s2==u'\0'){*s1++=0; break;}
		s2++;
		c4|=(*s2 & 0xFFFF)<<16;
		*s1++=c4;
	}while(nmax && *s2++);
	return s1;
}
/*La posición del primer caracter a copiar es (char8*)s1+b1
It is assumed that b= 0,1,2,3
(char8*)s1+b1 se deja apuntando al '\0' si copy_null es falso, a la posición
siguiente si es verdadero.*/
static void char8_strpcpy_char(Pchar8 *s1, const char8_t* RESTRICT s2, bint copy_null){
	IO4char8 c4;
	u8int i32;
	const IO4char8 bits[4]={0,0xFF,0xFFFF,0xFFFFFF};

	s1->b&=3;
	c4=*s1->s & bits[s1->b];
	i32=s1->b<<3;
	do{
		c4|=(*s2 & 0xFF)<<i32;
		i32+=8;
		if(i32==32){*s1->s++=c4; c4=0, i32=0;}
	}while(*s2++);
	if(i32!=0) *s1->s=c4;

	if(!copy_null){
		if(i32==0){s1->s--; i32=24;}
		else i32-=8;
	}
	s1->b=i32>>3;
}

/*Conversion from/to float/double to/from IEEE32  (IO_SINGLE)/IEEE64 (IO_DOUBLE)
stored in one/two uints, for input/output */
#if ATCRT_FLOAT
#define IO_SINGLE___float(pIO,x) *(float*)(pIO)=(x)
#define float___IO_SINGLE(pf,x) *(IO_SINGLE*)(pf)=(x)
#define IO_SINGLE_memcpy_float(pIO,pfl,n) memcpy_uint(pIO,pfl,n)
#define float_memcpy_IO_SINGLE(pfl,pIO,n) memcpy_uint(pfl,pIO,n)
#endif
#if ATCRT_DOUBLE
/*#define IO_DOUBLE___double(pF,x) *(pF)=*(IO_DOUBLE*)&(x)		//int a[2], b[2]; a=b; *(&a)=*(&b); //These are not allowed
#define double___IO_DOUBLE(pf,x) *(IO_DOUBLE*)(pf)=(x)*/
#define IO_DOUBLE___double(pIO,x) *(double*)(pIO)=(x)
#define double___IO_DOUBLE(pdbl,x) *(pdbl)=*(double*)&(x)
#define IO_DOUBLE_memcpy_double(pIO,pdbl,n) memcpy_uint(pIO,pdbl,2*(n))
#define double_memcpy_IO_DOUBLE(pdbl,pIO,n) memcpy_uint(pdbl,pIO,2*(n))
#endif
#if !ATCRT_FLOAT || !ATCRT_DOUBLE
#input mergestring(type_conv_,SYSTEM)
#endif
