﻿#pragma once
#include <ATcrt/ATuint.h>

#ifndef Addsufijo
	#define AddsufijoI(name,suf) name##_##suf
	#define Addsufijo(name,suf) AddsufijoI(name,suf)
#endif

//Bsic types that will be included here
#define Puntoxy(TypeR) Addsufijo(Puntoxy,TypeR)
#define Puntoxyn(TypeR) Addsufijo(Puntοxyn,TypeR)
#define PuntoXYZ(TypeR) Addsufijo(PuntoXYZ,TypeR)
#define PuntoXYZn(TypeR) Addsufijo(PuntoXYZn,TypeR)
#define Giro3D(TypeR) Addsufijo(Giro3D,TypeR)
#define Giro3DTrig(TypeR) Addsufijo(Giro3DTrig,TypeR)
#define Extremos2D(TypeR) Addsufijo(Extremos2D,TypeR)
#define Extremos3D(TypeR) Addsufijo(Extremos3D,TypeR)
#define PuntoXYZM(TypeR) Addsufijo(PuntoXYZM,TypeR)
#define PuntoXYZMn(TypeR) Addsufijo(PuntoXYZMn,TypeR)

//Coordinate transformation structures
#define Hel2Dg(suf) Addsufijo(Hel2Dg,suf)
#define Hel2D(suf) Addsufijo(Hel2D,suf)
#define Lineal2D(suf) Addsufijo(Lineal2D,suf)
#define Hel3Dg(suf) Addsufijo(Hel3Dg,suf)
#define Hel3D(suf) Addsufijo(Hel3D,suf)

#define AT2D3D_Index union{uint index; char8_t *nom;}
/*  2D (x,y) */
typedef struct{
	union{float x, λ;};
	union{float y, φ;};
} Puntoxy_float;

typedef struct{
	union{double x, λ;};
	union{double y, φ;};
} Puntoxy_double;

typedef struct{
	AT2D3D_Index;
	Puntoxy_float p;
}Puntoxyn_float;

typedef struct{
	AT2D3D_Index;
	Puntoxy_double p;
}Puntoxyn_double;

//Definiciones para facilitar extensiones
#define Puntoxy_BODY(TypeR) TypeR x,y;
#define Puntoλφ_BODY(TypeR) TypeR λ,φ;
#define Puntoxyλφ_BODY(TypeR) union{TypeR x, λ;}; union{TypeR y, φ;};
#define Puntoxyn_BODY(TypeR) AT2D3D_Index; Puntoxy(TypeR) p;
#define Puntoλφn_BODY(TypeR) Puntoxyn_BODY(TypeR)
#define Puntoxyλφn_BODY(TypeR) Puntoxyn_BODY(TypeR)

typedef struct{
	float mx,MX,my,MY;
} Extremos2D_fl;

typedef struct{
	double mx,MX,my,MY;
} Extremos2D_dbl;

#define setup_extremos2D(mM) \
	(mM).my=(mM).mx=FLT_MAX,\
	(mM).MY=(mM).MX=-FLT_MAX

#define extremos2D_setonpoint(ext,p) \
	(ext).MX=(ext).mx=(p).x, (ext).MY=(ext).my=(p).y

#define extremos2D_updateonpoint(ext,P) \
do{\
	if((p).x<(ext).mx) (ext).mx=(p).X; else if((p).x>(ext).MX) (ext).MX=(p).x;\
	if((p).y<(ext).my) (ext).my=(p).Y; else if((p).y>(ext).MY) (ext).MY=(p).y;\
}while(0)
#define extremos2D_updateonext(ext,ext2) \
do{\
	if((ext2).mx<(ext).mx) (ext).mx=(ext2).mx;  if((ext2).MX>(ext).MX) (ext).MX=(ext2).MX;\
	if((ext2).my<(ext).my) (ext).my=(ext2).my;  if((ext2).MY>(ext).MY) (ext).MY=(ext2).MY;\
}while(0)

#define extremos2D_Disjoint(ex1,ex2) \
	((ex1).MX<(ex2).mx && (ex1).mx>(ex2).MX && (ex1).MY<(ex2).my && (ex1).my>(ex2).MY)
#define extremos2D_disjoint(ex1,ex2) \
	((ex1).MX<=(ex2).mx && (ex1).mx>=(ex2).MX && (ex1).MY<=(ex2).my && (ex1).my>=(ex2).MY)

//Llamar como extremos2D_eq(ex1,<,ex2)
#define extremos2D_eq(ex1,EQ,ex2) \
	((ex1).mx>=(ex2).mx && (ex1).MX<=(ex2).MX> && (ex1).my>=(ex2).my && (ex1).MY<=(ex2).MY)

/*  3D (X,Y,Z) */
typedef struct strPuntoXYZ_float{
	float X, Y, Z;
} PuntoXYZ_float;

typedef struct strGiro3D_float{
	float ω,φ,κ;
} Giro3D_float;

typedef struct strPuntoXYZ_double{
	double X, Y, Z;
} PuntoXYZ_double;

typedef struct strGiro3D_fdouble{
	double ω,φ,κ;
} Giro3D_double;

#define P_iseq(P,EQ,Q) (((P).X EQ (Q).X) && ((P).Y EQ (Q).Y) && ((P).Z EQ (Q).Z))
#define P_mul(P,f) (P).X*=f, (P).Y*=f, (P).Z*=f
#define P_op(P, EQ, Q,OP,R) (P).X EQ ((Q).X OP (R).X),   (P).Y EQ ((Q).Y OP (R).Y),   (P).Z EQ ((Q).Z OP (R).Z)
#define P_eq(P,EQ,Q) (P).X EQ ((Q).X), (P).Y EQ ((Q).Y), (P).Z EQ ((Q).Z)
static inline double P_mod_dbl(PuntoXYZ_double P){return P.X*P.X+P.Y*P.Y+P.Z*P.Z;}
static inline double P_mod_fl(PuntoXYZ_float P){return P.X*P.X+P.Y*P.Y+P.Z*P.Z;}
#define P_mod(P) ((P).X*(P).X+(P).Y*(P).Y+(P).Z*(P).Z)
#define G_eq(P,EQ,Q) (P).ω EQ ((Q).ω), (P).φ EQ ((Q).φ), (P).κ EQ ((Q).κ)
#define G_mul(P,f) (P).ω*=f, (P).φ*=f, (P).κ*=f

typedef struct{
	AT2D3D_Index;
	PuntoXYZ_float P;
} PuntoXYZn_float;

typedef struct{
	AT2D3D_Index;
	PuntoXYZ_double P;
} PuntoXYZn_double;

//Definiciones para facilitar extensiones
#define PuntoXYZ_BODY(TypeR) TypeR X,Y,Z;
#define Giro3D_BODY(TypeR) TypeR ω,φ,κ;
#define PuntoXYZGiro3D_BODY(TypeR) union{double X, ω;}; union{double Y, φ;}; union{double Z, κ;};
#define PuntoXYZn_BODY(TypeR) AT2D3D_Index; PuntoXYZ(TypeR) P;
#define Giro3Dn_BODY(TypeR) AT2D3D_Index; Giro3D(TypeR) G;

typedef struct{
   float mx, MX,
		my, MY,
		mz, mZ;
} Extremos3D_fl;

typedef struct{
	double mx, MX,
			my, MY,
			mz, MZ;
} Extremos3D_dbl;

#define setup_extremos3D(mM) \
	(mM).mz=(mM).my=(mM).mx=FLT_MAX,\
	(mM).MZ=(mM).MY=(mM).MX=-FLT_MAX

#define extremos3D_setonpoint(ext,P) \
	(ext).MX=(ext).mx=(P).X, (ext).MY=(ext).my=(P).Y, (ext).MZ=(ext).mz=(P).Z

#define extremos3D_updateonpoint(ext,P) \
do{\
	if((P).X<(ext).mx) (ext).mx=(P).X; else if((P).X>(ext).MX) (ext).MX=(P).X;\
	if((P).Y<(ext).my) (ext).my=(P).Y; else if((P).Y>(ext).MY) (ext).MY=(P).Y;\
	if((P).Z<(ext).mz) (ext).mz=(P).Z; else if((P).Z>(ext).MZ) (ext).MZ=(P).Z;\
}while(0)
#define extremos3D_updateonext(ext,ext2) \
do{\
	if((ext2).mx<(ext).mx) (ext).mx=(ext2).mx;  if((ext2).MX>(ext).MX) (ext).MX=(ext2).MX;\
	if((ext2).my<(ext).my) (ext).my=(ext2).my;  if((ext2).MY>(ext).MY) (ext).MY=(ext2).MY;\
	if((ext2).mz<(ext).mz) (ext).mz=(ext2).mz;  if((ext2).MZ>(ext).MZ) (ext).MZ=(ext2).MZ;\
}while(0)

#define extremos3D_Disjoint(ex1,ex2) \
	((ex1).MX<(ex2).mx && (ex1).mx>(ex2).MY && (ex1).MY<(ex2).my && (ex1).my>(ex2).MY) && (ex1).MZ<(ex2).mz && (ex1).mz>(ex2).MZ)
#define extremos3D_disjoint(ex1,ex2) \
	((ex1).MX<=(ex2).mx && (ex1).mx>=(ex2).MY && (ex1).MY<=(ex2).my && (ex1).my>=(ex2).MY) && (ex1).MZ<=(ex2).mz && (ex1).mz>=(ex2).MZ)

typedef struct{
	double sinw,cosw,sinfi,cosfi,sink,cosk;
} Giro3DTrig_dbl;

typedef struct{
	float sinw,cosw,sinfi,cosfi,sink,cosk;
} Giro3DTrig_fl;

#define PuntoXYZM_BODY(TypeR) \
	PuntoXYZ(TypeR) P;\
	TypeR M[3][3];

typedef struct{
	PuntoXYZM_BODY(float)
} PuntoXYZM_float;

typedef struct{
	PuntoXYZM_BODY(double)
} PuntoXYZM_double;

#define PuntoXYZMn_BODY(TypeR) \
	union{uint index; char8_t *nom;};\
	PuntoXYZ(TypeR) P;\
	TypeR M[3][3];

typedef struct{
	PuntoXYZMn_BODY(float)
} PuntoXYZMn_float;

typedef struct{
	PuntoXYZMn_BODY(double)
} PuntoXYZMn_double;


typedef Puntoxy_float* pPuntoxy_fl;
typedef PuntoXYZ_float* pPuntoXYZ_fl;
typedef Puntoxy_double* pPuntoxy_dbl;
typedef PuntoXYZ_double* pPuntoXYZ_dbl;

#ifdef AT_CLASESARRAYS
	defineVector(pPuntoxy_fl)
	defineVector(pPuntoxy_dbl)
	defineVector(pPuntoXYZ_fl)
	defineVector(pPuntoXYZ_dbl)
#endif


/******     Transformaciones de coordenadas     ******/

/* Transformación de semejanza bidimensional. La escala y la el giro son los que pasan
del sisetma 1 al sistema 2:

	(x',y')1=(x,y)1-cg1,   (x',y')2=(x,y)2-cg2

	x'2=esc*(cosg*x'1-sing*y'1)
	y'2=esc*(sing*x'1+cosg*y'1)
*/
typedef struct{
	Puntoxy_float cg1, cg2;
	float esc,cosg,sing;
} Hel2Dg_fl;
typedef struct{
	Puntoxy_double cg1, cg2;
	double esc,cosg,sing;
} Hel2Dg_dbl;

/*		(x',y')1=(x,y)1-(Tx,Ty)

	x2=esc*(cosg*x'1-sing*y'1)
	y2=esc*(sing*x'1+cosg*y'1)
*/
typedef struct{
	float Tx,Ty,esc,cosg,sing;
} Hel2D_fl;
typedef struct{
	double Tx,Ty,esc,cosg,sing;
} Hel2D_dbl;

/*
(x',y')1=(x,y)1-(Tx,Ty)

x2=a*x'1+b*y'1
y2=c*x'1+d*y'1
*/
typedef struct{
	float Tx,Ty;
	float a,b,c,d;
} Lineal2D_fl;
typedef struct{
	double Tx,Ty;
	double a,b,c,d;
} Lineal2D_dbl;

/* Transformación de semejanza tridimensional. La escala y la matriz de rotación son las
que pasan del sisetma 1 al sistema 2:*/

//(X2-cg2)=esc*M*(X1-cg1)
typedef struct{
	PuntoXYZ_float cg1, cg2;
	float esc;
	float M[3][3];
} Hel3Dg_fl;
typedef struct{
	PuntoXYZ_double cg1, cg2;
	double esc;
	double M[3][3];
} Hel3Dg_dbl;

//X2=esc*M*(X1-T)
typedef struct{
	PuntoXYZ_float T;
	float esc;
	float M[3][3];
} Hel3D_fl;
typedef struct{
	PuntoXYZ_double T;
	double esc;
	double M[3][3];
} Hel3D_dbl;
