﻿//Las coordenadas estereográficas se tratan como del Hemisferio Sur.
Puntoxy_double geo___proy1(const Sistema* sis, Puntoxy_double p){
	double e=sis->sis.e;

	if(Sistema_has_xOyS(sis->sis.proy)){
		p.x-=sis->sis.xO;
		p.y-=sis->sis.yS;
	}

	switch(sis->sis.proy){
	case SIS_Geograficas:{
		p.x*=PI_180;
		p.y*=PI_180;
		if(sis->sis.param1.orden_λφ==SIS_Geograficas_φλ){
			double aux=p.λ;
			p.λ=p.φ;
			p.φ=aux;
		}
	}
	break;
	case SIS_Lambert:{
		double _R0,_sinφ0,d0, E,N,c,sinφ;

		_R0=1/sis->precalc.Lambert.R0;
		_sinφ0=1/sis->precalc.Lambert.sinφ0;
		d0=(1+sis->precalc.Lambert.sinφ0)/(1-sis->precalc.Lambert.sinφ0);

		E=p.x*_R0;
		N=1-p.y*_R0;
		p.λ=atan2(E,N)*_sinφ0;
		c=E*E+N*N; //R^2
		c=pow(c,-_sinφ0);
		sinφ=(c*d0-1)/(c*d0+1);
		c*=sis->precalc.Lambert.d;
		p.φ=φ___rST2_sinφapprox(e,c,sinφ);
	}
	break;
	case SIS_Mercator:{
		double _ak0=1/sis->precalc.Comun.ak0;
		double ΦM=p.y*_ak0;
		p.φ=φ___ΦM(sis->sis.e,ΦM);
		p.x*=_ak0;
	}
	break;
	case SIS_Estereográfica_Polar:{
		double _K=1/sis->precalc.Estereografica.K;

		double c,sinφ, E,N;
		E=p.x*_K;
		N=p.y*_K;
		c=E*E+N*N; //r^2
		sinφ=(c-1)/(c+1);
		p.φ=φ___rST2_sinφapprox(sis->sis.e,c,sinφ);
		if(sis->sis.param1.φ0!=90) p.λ=atan2(E,N);
		else{p.λ=atan2(E,-N); p.φ=-p.φ;}
	}
	break;
	case SIS_Estereográfica:{
		double _K=1/sis->precalc.EstereoOblicua.K;
		double x,y,z,sΦ,cλcΦ;
		x=p.x*_K;
		y=p.y*_K;
		z=x*x+y*y;
		z=2/(1+z);
		x*=z; y*=z;
		z=z-1;

		sΦ=y*sis->precalc.EstereoOblicua.cosΦ0+z*sis->precalc.EstereoOblicua.sinΦ0;
		cλcΦ=-y*sis->precalc.EstereoOblicua.sinΦ0+z*sis->precalc.EstereoOblicua.cosΦ0;
		p.λ=atan2(x,cλcΦ); //x=sλ*cφ
		p.φ=φ___sinΦ(sis->sis.e,sΦ);
	}
	break;
	case SIS_Mercator_Transversa:
		p=UTM_λφ___xy(sis->precalc.Comun.ak0,e,p);
	break;
	case SIS_Sinusoidal:{
		double _ak0=1/sis->precalc.Comun.ak0;
		if(sis->sis.param1.eqsim.ky!=1.0) p.y/=sis->sis.param1.eqsim.ky;
		p.x*=_ak0;
		p.y*=_ak0;
		double c=cos(p.φ);
		if(sis->sis.param1.eqsim.α!=1.0) c=1-sis->sis.param1.eqsim.α*(1-c);
		c+=(c==0);
		p.λ/=c;
	} break;
	}

	p.λ+=sis->sis.Λ0;
	return p;
}

Puntoxy_double proy___geo1(const Sistema *sis, Puntoxy_double p){
	double e=sis->sis.e;

	p.λ-=sis->sis.Λ0;

	switch(sis->sis.proy){
	case SIS_Geograficas:
		p.x*=PI_180_PI;
		p.y*=PI_180_PI;
		if(sis->sis.param1.orden_λφ==SIS_Geograficas_φλ){
			double aux=p.λ;
			p.λ=p.φ;
			p.φ=aux;
		}
	return p;
	case SIS_Lambert:{
		double λ,sinφ,b,R;
		λ=p.λ*sis->precalc.Lambert.sinφ0;
		sinφ=sin(p.φ);
		b=rST2_sinφ(sis->sis.e,sinφ);
		b=pow(b,-0.5*sis->precalc.Lambert.sinφ0);

		R=sis->precalc.Lambert.c*b;
		p.x=R*sin(λ);
		p.y=sis->precalc.Lambert.R0-R*cos(λ);
	}
	break;
	case SIS_Mercator:{
		p.x*=sis->precalc.Comun.ak0;
		p.y=ΦM___φ(sis->sis.e,p.φ);
		p.y*=sis->precalc.Comun.ak0;
	}
	break;
	case SIS_Estereográfica_Polar:{
		if(sis->sis.param1.φ0==90){p.φ=-p.φ; p.λ=PI-p.λ;}
		double R=sis->precalc.Estereografica.K*rST_φ(sis->sis.e,p.φ);
		p.y=R*cos(p.λ);
		p.x=R*sin(p.λ);
	}
	break;
	case SIS_Estereográfica:{
		double C,z;
		Puntoxy_double Δ=sinΦcosΦ___φ(sis->sis.e,p.φ);

		C=Δ.y*cos(p.λ);
		p.x=Δ.y*sin(p.λ);
		z=   Δ.x*sis->precalc.EstereoOblicua.sinΦ0 + C*sis->precalc.EstereoOblicua.cosΦ0;
		p.y=Δ.x*sis->precalc.EstereoOblicua.cosΦ0 - C*sis->precalc.EstereoOblicua.sinΦ0;
		C=sis->precalc.EstereoOblicua.K/(1+z);
		p.x*=C;
		p.y*=C;
	}
	break;
	case SIS_Mercator_Transversa:
		p=UTM_xy___λφ(sis->precalc.Comun.ak0,e,p);
	break;
	case SIS_Sinusoidal:{
		double x=cos(p.φ);
		if(sis->sis.param1.eqsim.α==1.0) p.x*=x;
		else p.x*=1-sis->sis.param1.eqsim.α*(1-x);
		p.x*=sis->precalc.Comun.ak0;
		p.y*=sis->precalc.Comun.ak0;
		p.y*=sis->sis.param1.eqsim.ky;
	}
	break;
	default:
		return p;
	}

	p.x+=sis->sis.xO;
	p.y+=sis->sis.yS;
	return p;
}
