﻿double lam(double a, double e, double φ){
	double A,B,C,D;
	double e4,e6;
	double lam;
	e4=e*e;
	e6=e4*e;

	A=1+3/4.0*e+45/64.0*e4+175/256.0*e6;
	B=3/4.0*e+15/16.0*e4+525/512.0*e6;
	C=15/64.0*e4+105/256.0*e6;
	D=35/512.0*e6;

	B/=2;	C/=4;	D/=6;

	lam=A*φ-B*sin(2*φ)+C*sin(4*φ)-D*sin(6*φ);
	lam*=a*(1-e);
	return lam;
}

double φ___lam(double a, double e, double lam){
	double A,B,C,D;
	double e4,e6;
	double φ;
	e4=e*e;
	e6=e4*e;

	A=1+3/4.0*e+45/64.0*e4+175/256.0*e6;
	B=3/4.0*e+15/16.0*e4+525/512.0*e6;
	C=15/64.0*e4+105/256.0*e6;
	D=35/512.0*e6;

	A=1/A;
	B*=A/2;	C*=A/4;	D*=A/6;

	lam*=A/(a*(1-e));
	φ=lam;
	for(;;){
		double φp=φ;
		φ=lam+B*sin(2*φp)-C*sin(4*φp)+D*sin(6*φp);
		if(fabs(φp-φ)<1e-8) break;
	}
	return φ;
}

//ee*log{(1-ee*sinφ)/(1+ee*sinφ)} Calculado con un error absoluto < 2*10^-4
sinline double ΦM_ajuste_e2(double e, double sinφ){
	double d, aux, f;
	aux=e*sinφ; f=aux*sinφ;
	d=f*0.2857142857142857143;
	d+=0.4; d*=f;
	d+=0.6666666666666666; d*=f;
	d+=2; d*=-aux;
	return d;
}
//0.5*ee*log{(1-ee*sinφ)/(1+ee*sinφ)} Calculado con un error absoluto < 10^-14
//Es lo que hay que sumar a la Φ Mercator por ser e!=0.
//Negativo en el h. Norte, positivo en el h. Sur.
sinline double ΦM_ajuste_e(double e, double sinφ){
	double d, aux, f;
	aux=e*sinφ; f=aux*sinφ;
	d=f*0.14285714285714286;
	d+=0.2; d*=f;
	d+=0.3333333333333333; d*=f;
	d+=1; d*=-aux;
	return d;
}

//0.5*ee*log{(1-ee*sinφ)/(1+ee*sinφ)} + 0.5*log(1-e*sinφ). Calculado con un error absoluto < 10^-11
//Aparece en el cálculo de k Stereográfica
sinline double ajuste_kST(double e, double sinφ){
	double d, aux, f;
	aux=e*sinφ; f=aux*sinφ;
	d=0.142857142857+0.125*sinφ; d*=f;
	d+=0.2+0.16666666666666666*sinφ; d*=f;
	d+=0.3333333333333333+0.25*sinφ; d*=f;
	d+=1+0.5*sinφ; d*=-aux;
	return d;
}

//φ: [-90, 90] -> rST: [0, ∞]
double rST2_sinφ(double e, double sinφ){
	double d=ΦM_ajuste_e2(e,sinφ);
	d=exp(d);
	d*=(1+sinφ)/(1-sinφ);
	return d;
}
//φ: [-90, 90] -> rST: [0, ∞]
double rST_φ(double e, double φ){
	double sinφ=sin(φ);
	double d=ΦM_ajuste_e(e,sinφ);
	d=exp(d);
	d*=cos(φ)/(1-sinφ);
	return d;
}
double ΦM___sinφ(double e, double sinφ){
	double d=ΦM_ajuste_e2(e,sinφ);
	d+=log((1+sinφ)/(1-sinφ));
	return 0.5*d;
}

//rST2=0 --> φ=-90; rST2=infty --> φ=90
double sinφ___rST2_sinφapprox(double e, double rST2,double sinφapprox){
#define φ sinφapprox
	for(;;){	//φ guarda sin(φ)
		double b,φφ;
		b=ΦM_ajuste_e2(e,φ);
		b=rST2*exp(-b);
		φφ=φ;
		φ=(b-1)/(b+1);	//sin(φ)
		if(fabs(φ-φφ)<1e-8) break;
	}
	return φ;
#undef φ
}

double sinφ___sinΦ(double e, double sinΦ){
	if(sinΦ<0){
		double rST2=(1+sinΦ)/(1-sinΦ);
		return sinφ___rST2_sinφapprox(e,rST2,sinΦ);
	}else{
		double rST2=(1-sinΦ)/(1+sinΦ);
		return -sinφ___rST2_sinφapprox(e,rST2,-sinΦ);
	}
}
double sinΦ___sinφ(double e, double sinφ){
	if(sinφ<0){
		double rST2=rST2_sinφ(e,sinφ);
		return (rST2-1)/(rST2+1);
	}else{
		double rST2=rST2_sinφ(e,-sinφ);
		return (1-rST2)/(rST2+1);
	}
}
//.x es sinΦ; .y es cosΦ
Puntoxy_double sinΦcosΦ___φ(double e, double φ){
	Puntoxy_double p;
	double sinφ,rST2;

	sinφ=sin(-fabs(φ));
	rST2=rST2_sinφ(e,sinφ);
	if(φ<0) p.x=rST2-1;
	else p.x=1-rST2;

	double den=1.0/(rST2+1);
	p.y=2*rST_φ(e,-fabs(φ));
	p.x*=den;
	p.y*=den;
	return p;
}


double k_UTM_GRS80(double X, double Y, double a){
	double factor;
	double ka,kb;
	double a0,a2,a4,a6,a8;
	double b0,b2;
	double x2, y2, y4;

	//Constantes para los valores a y e del elipsoide GRS80
	a0=0.01237370;
	a2=-4.1275e-6;
	a4=3.531e-8;
	a6=-1.35e-10;
	a8=3.75e-13;
	b0=2.62e-5;
	b2=-3.53e-8;

	factor=GRS80_a/a;	//ajustamos a la 'a' del elip. GRS80.
	factor/=1000000;
	X*=factor;	Y*=factor;

	x2=X*X;
	y2=Y*Y;	y4=y2*y2;

	ka=a0+a2*y2+a4*y4+a6*y4*y2+a8*y4*y4;	ka*=x2;
	kb=b0+b2*y2;									kb*=x2*x2;

	return (1 + ka+kb);
}
double ajuste_kUTM(double a, double e, double x, double y){
	double φ,Nρmio,NρGRS80;

	{double factor=GRS80_a/a;
	x*=factor;		y*=factor;}

	φ=φ___lam(GRS80_a, e, y);
	Nρmio=Nρ(GRS80_a,e,φ);
	φ=φ___lam(GRS80_a, GRS80_e, fabs(y));
	if(φ>PI_2) φ=PI_2;
	NρGRS80=Nρ(GRS80_a, GRS80_e,φ);

	return 1+0.5*x*x*(1/Nρmio-1/NρGRS80);
}
double kLambert___φ(const Sistema *sis, double φ){
	double sinφ,b,R,N,k;

	sinφ=sin(φ);
	N=radN(sis->sis.a,sis->sis.e,sinφ);
	b=rST2_sinφ(sis->sis.e,sinφ);
	b=pow(b,-0.5*sis->precalc.Lambert.sinφ0);
	R=b*sis->precalc.Lambert.c;

	k=R*sis->precalc.Lambert.sinφ0/(N*cos(φ));
	return k;
}
double kMercator___φ(const Sistema *sis, double φ){
	double cosfi,k;

	cosfi=cos(φ);
	k=sqrt(1-sis->sis.e*(1-cosfi*cosfi));
	k*=sis->sis.k0/cosfi;
	return k;
}
double kEstereoPolar___φ(const Sistema *sis, double φ){
	double sinφ,k;

	if(sis->sis.param1.φ0==90) φ=-φ;
	sinφ=sin(φ);
	k=ajuste_kST(sis->sis.e,sinφ);
	k=exp(k);
	k*=sis->precalc.Estereografica.K;
	k/=(sis->sis.a*(1-sinφ));
	return k;
}
//k de aΦ <-- ρφ.
double kΦ___φ(double e, double φ){
	double sinφ,k,k2;

	sinφ=sin(φ);
	k=ajuste_kST(e,sinφ);
	k=exp(k);
	k2=ΦM_ajuste_e2(e,sinφ);
	k2=exp(k2);
	k2=1-sinφ+k2*(1+sinφ); //0.5*(1-sinφ)/(1-sinΦ)
	return 2*k/k2;
}
double kEstereográfica___φλ(const Sistema *sis, double φ, double λ){
	double k,z;
	Puntoxy_double Δ;

	Δ=sinΦcosΦ___φ(sis->sis.e,φ);
	k=kΦ___φ(sis->sis.e,φ);
	z=Δ.x*sis->precalc.EstereoOblicua.sinΦ0 + Δ.y*cos(λ)*sis->precalc.EstereoOblicua.cosΦ0;
	k*=sis->precalc.EstereoOblicua.K;
	k/=(sis->sis.a*(1+z));
	return k;
}

//Funciones para coordenadas sin xO ni yS
Puntoxy_double UTM_λφ___xy(double a,double e,Puntoxy_double p){
	double φpri,N,η,ηt,t;
	double c, sinp;
	double xN,xNl,xNf,t4,s;
	Puntoxy_double pl;

	φpri=φ___lam(a,e,p.y);
	if(φpri>=PI_2 || φpri<=-PI_2){
		NOTFINITE_d(pl.x); NOTFINITE_d(pl.y);
		return pl;
	}
	sinp=sin(φpri);
	c=cos(φpri);
	pl.y=ΦM___sinφ(e,sinp);
	N=radN(a,e,sinp);
	xN=p.x/N;
	xNl=xN/c;
	c*=c;
	xN*=xN;
	xNf=xN*sinp/(2*c);
	sinp*=sinp;

	{double aux=e/(1-e);
	η=c*aux;
	ηt=sinp*aux;}
	t=sinp/c;
	t4=t*t;

	pl.x=xNl;
	xNl*=xN/6;
	s=1+2*t+η;
	pl.x-=xNl*s;
	xNl*=xN/20;
	s=5+28*t+24*t4 +8*ηt+3*η*(2-ηt);
	pl.x+=xNl*s;

	pl.y-=xNf;
	xNf*=xN/12;
	s=5+6*t+η*(1-4*η);
	pl.y+=xNf*s;
	xNf*=xN/30;
	s=61+180*t+120*t4+48*ηt+η*(46-3*ηt);
	pl.y-=xNf*s;

	pl.y=φ___ΦM(e,pl.y);
	return pl;
}

Puntoxy_double UTM_xy___λφ(double a,double e,Puntoxy_double p){
	double N,c,t,η,ηt,t4;
	double lc,lcx,lcy;
	double s,siny;
	Puntoxy_double px;

	c=cos(p.y);
	siny=sin(p.y);
	N=radN(a,e,siny);
	lc=p.x*c;
	lcx=N*lc;
	lc*=lc;
	lcy=lc*N*siny/(2*c);
	c*=c;
	siny*=siny;

	{double aux=e/(1-e);
	η=c*aux;
	ηt=siny*aux;}
	t=siny/c;
	t4=t*t;

	px.x=lcx;
	lcx*=lc/6;
	s=1-t+η;
	px.x+=lcx*s;
	lcx*=lc/20;
	s=5-18*t+t4-58*ηt+η*(14+13*η-64*ηt);
	px.x+=lcx*s;

	px.y=lam(a,e,p.y);
	px.y+=lcy;
	lcy*=lc/12;
	s=5-t+η*(9+4*η);
	px.y+=lcy*s;
	lcy*=lc/30;
	s=61-58*t+t4-330*ηt+η*(270+445*η-680*ηt);
	px.y+=lcy*s;

	return px;
}

double UTM_conv___λφ(double e,double λ,double φ){
	double c,η,x,y;
	double xx,λs;

	c=cos(φ); c*=c;
	η=c*e/(1-e);
	xx=λ*λ;
	λs=λ*sin(φ);

	x=1+xx*(c*(2+η)-1)/2;
	y=1+xx*(c*(6+9*η+4*η*η)-1)/6;
	y*=λs;

	return atan(y/x);
}

//Muchas de las proyecciones no emplean φ
double conv_meridianos(const Sistema *sis,double λ,double φ){
	λ-=sis->sis.Λ0;
	switch(sis->sis.proy){
		case SIS_Estereográfica_Polar: return -λ; //Hemi. Sur
		case SIS_Lambert: return λ*sis->precalc.Lambert.sinφ0;
		case SIS_Mercator_Transversa: return UTM_conv___λφ(sis->sis.e,λ,φ);
		case SIS_Conforme: return sis->sis.param1.conv0;
	}
	//cases SIS_Geograficas, SIS_Mercator, SIS_Rectangular
	return 0;
}

#define λmin geog.mx
#define λmax geog.MX
#define φmin geog.my
#define φmax geog.MY

Extremos2D_dbl rect_UTM___rect_geog(Extremos2D_dbl geog, const Sistema *sis){
	Extremos2D_dbl UTM;
	Puntoxy_double p, q;

	λmin-=sis->sis.Λ0;
	λmax-=sis->sis.Λ0;

	//Ymáx
	if(φmax>=0){
		if(-λmin>λmax) p.λ=-λmin;		else p.λ=λmax; //El que esté más alejado del meridiano central; el signo da igual
	}else{
		if(signbit(λmin)!=signbit(λmax)) p.λ=0; //El punto más próximo al meridiano central.
		else if(λmin>=0) p.λ=λmin;
		else p.λ=λmax;
	}
	p.φ=φmax;
	q=UTM_xy___λφ(sis->precalc.Comun.ak0,sis->sis.e,p);
	UTM.MY=q.y+sis->sis.yS;

	//Ymín
	if(φmin<0){
		if(-λmin>λmax) p.λ=-λmin;		else p.λ=λmax; //El que esté más alejado del meridiano central; el signo da igual
	}else{
		if(signbit(λmin)!=signbit(λmax)) p.λ=0; //El punto más próximo al meridiano central.
		else if(λmin>=0) p.λ=λmin;
		else p.λ=λmax;
	}
	p.φ=φmin;
	q=UTM_xy___λφ(sis->precalc.Comun.ak0,sis->sis.e,p);
	UTM.my=q.y+sis->sis.yS;

	//Xmin
	if(λmin<0){
		if(signbit(φmin)!=signbit(φmax)) p.φ=0; //El punto más próximo al Εcuador.
		else if(φmin>=0) p.φ=φmin;
		else p.φ=φmax;
	}else{
		if(-φmin>φmax) p.φ=-φmin;		else p.φ=φmax; //El que esté más alejado del Ecuador; el signo da igual
	}
	p.λ=λmin;
	q=UTM_xy___λφ(sis->precalc.Comun.ak0,sis->sis.e,p);
	UTM.mx=q.x+sis->sis.xO;

	//Xmax
	if(λmax>=0){
		if(signbit(φmin)!=signbit(φmax)) p.φ=0; //El punto más próximo al Εcuador.
		else if(φmin>=0) p.φ=φmin;
		else p.φ=φmax;
	}else{
		if(-φmin>φmax) p.φ=-φmin;		else p.φ=φmax; //El que esté más alejado del Ecuador; el signo da igual
	}
	p.λ=λmax;
	q=UTM_xy___λφ(sis->precalc.Comun.ak0,sis->sis.e,p);
	UTM.MX=q.x+sis->sis.xO;

	return UTM;
}
Extremos2D_dbl rect_proy___rect_geog(Extremos2D_dbl geog, const Sistema *sis){
	Extremos2D_dbl proy;
	Puntoxy_double p, q;

	if(sis->sis.proy==SIS_Rectangular || sis->sis.proy==SIS_Conforme) return geog;
	if(sis->sis.proy==SIS_Geograficas){
		λmin-=sis->sis.Λ0;
		λmax-=sis->sis.Λ0;
		proy.mx=λmin*PI_180_PI;		proy.MX=λmax*PI_180_PI;
		proy.my=φmin*PI_180_PI;		proy.MY=φmax*PI_180_PI;
		if(sis->sis.param1.orden_λφ==SIS_Geograficas_φλ){
			double aux;
			aux=proy.mx; proy.mx=proy.my; proy.mx=aux;
			aux=proy.MX; proy.MX=proy.MY; proy.MX=aux;
		}
		return proy;
	}
	if(Sistema_paralelo(sis->sis.proy)){
		p.y=φmin; p.x=0; p=proy___geo1(sis,p); proy.my=p.y;
		p.y=φmax; p.x=0; p=proy___geo1(sis,p); proy.MY=p.y;
		if(signbit(φmin)!=signbit(φmax)) p.y=0;
		else if(φmin>=0) p.y=φmin;
		else p.y=φmax;
		p.x=λmin; q=proy___geo1(sis,p); proy.mx=q.x;
		p.x=λmax; q=proy___geo1(sis,p); proy.MX=q.x;
		return proy;
	}
	if(sis->sis.proy==SIS_Mercator_Transversa){
		return rect_UTM___rect_geog(geog, sis);
	}

	//Lambert, Estereográfica_Polar y Estereográfica
	bint bλ, bλ2, bλ3;
	double λ;

	bλ=signbit(λmin-sis->sis.Λ0)!=signbit(λmax-sis->sis.Λ0);
	bλ2=(λmin-sis->sis.Λ0)<-PI*(1+3.0E-7) && λmax-sis->sis.Λ0>-PI*(1-3.0E-7);
	bλ3=λmin-sis->sis.Λ0<PI*(1-3.0E-7) && λmax-sis->sis.Λ0>PI*(1+3.0E-7);
#define uppoints(q) mineq(proy.mx,q.x); maxeq(proy.MX,q.x); mineq(proy.my,q.y); maxeq(proy.MY,q.y);

	//φmin
	p.φ=φmin;
	p.λ=λmin; q=proy___geo1(sis,p);		proy.MX=proy.mx=q.x; proy.MY=proy.my=q.y;
	p.λ=λmax; q=proy___geo1(sis,p);		uppoints(q);
	if(bλ){p.λ=sis->sis.Λ0;		q=proy___geo1(sis,p);	uppoints(q);}
	if(bλ2){p.λ=sis->sis.Λ0-PI; q=proy___geo1(sis,p);	uppoints(q);}
	if(bλ3){p.λ=sis->sis.Λ0+PI; q=proy___geo1(sis,p);	uppoints(q);}

	//φmax
	p.φ=φmax;
	p.λ=λmin; q=proy___geo1(sis,p);		uppoints(q);
	p.λ=λmax; q=proy___geo1(sis,p);		uppoints(q);
	if(bλ){p.λ=sis->sis.Λ0;		q=proy___geo1(sis,p);	uppoints(q);}
	if(bλ2){p.λ=sis->sis.Λ0-PI; q=proy___geo1(sis,p);	uppoints(q);}
	if(bλ3){p.λ=sis->sis.Λ0+PI; q=proy___geo1(sis,p);	uppoints(q);}

	//Calcularlo bien para la Estereográfica
	if(sis->sis.proy==SIS_Lambert) λ=PI_2/sis->precalc.Lambert.sinφ0;
	else λ=PI_2;
	bλ2=λmin-sis->sis.Λ0<-λ && λmax-sis->sis.Λ0>-λ;
	bλ3=λmin-sis->sis.Λ0<+λ && λmax-sis->sis.Λ0>λ;

	if(bλ2){
		p.λ=sis->sis.Λ0-λ;
		p.φ=φmin; q=proy___geo1(sis,p);	mineq(proy.mx,q.x); maxeq(proy.MX,q.x);
		p.φ=φmax; q=proy___geo1(sis,p);	mineq(proy.mx,q.x); maxeq(proy.MX,q.x);
	}
	if(bλ3){
		p.λ=sis->sis.Λ0+λ;
		p.φ=φmin; q=proy___geo1(sis,p);	mineq(proy.mx,q.x); maxeq(proy.MX,q.x);
		p.φ=φmax; q=proy___geo1(sis,p);	mineq(proy.mx,q.x); maxeq(proy.MX,q.x);
	}

	return proy;
}
#undef λmin
#undef λmax
#undef φmin
#undef φmax
