﻿#pragma once
#include <AT2D3D/Estructuras2d3d.h>
#include <ATcrt/sys_inttypes.h>

#define SIS_Rectangular 0
#define SIS_Conforme 1
#define SIS_Lambert 2
#define SIS_Mercator 3
#define SIS_Estereográfica_Polar 4
#define SIS_Mercator_Transversa 5
#define SIS_Estereográfica 6
#define SIS_Geograficas 10
#define SIS_Sinusoidal 11
#define SIS_Mollweide 12

//Proyecciones a las que se aplica xO e yS (v. infra)
#define Sistema_has_xOyS(proy) (proy>=SIS_Lambert && proy!=SIS_Geograficas)
//Proyecctiones con los paralelos paralelos, en horizontal, y valores en metros (u otra). Se excluye por tanto Geográficas
#define Sistema_paralelo(proy) (proy==SIS_Mercator || proy>=SIS_Sinusoidal)

typedef struct{
	const char8_t *nombre;
	double ae[2];	//a,e
} Elipsoide;
#define GRS80_a 6378137.0
#define GRS80_e 0.00669438
//Un radio para cuando la Tierra se trata como esfera. El valor exacto no importa,
//pero sí que se emplee siempre el mismo valor
#define Tierra_R 6376000
//Radio polar, para tratar la Tierra como una esfera para proyecciones polares.
//El valor exacto no importa, pero sí que se emplee siempre el mismo valor
#define Tierra_RPolar 6399600

#ifdef __clang__
#pragma clang diagnostic push "-Wmissing-braces"
#pragma clang diagnostic ignored "-Wmissing-braces"
#endif
#define N_ElipsoideValores 5
static const Elipsoide ElipsoidesValores[]={
	{u8"Hayford",				6378388,0.00672267},	//A extinguir
	{u8"GRS80 / WGS84",		GRS80_a,GRS80_e},
	{u8"Bessel 1841",			6377397, 0.006674372}, //A extinguir
	{u8"Krassovsky",			6378245, 0.006693422}, //A extinguir
	{u8"Sudamérica 1969",	6378160, 0.006694542}, //A extinguir
	//"CGCS2000"	Usa el GRS80
};
#ifdef __clang__
#pragma clang diagnostic pop
#endif

#define SIS_Geograficas_φλ 0
#define SIS_Geograficas_λφ 1
typedef struct{
 double a;
 double e; //Guarda e^2
 double ond; //Ondulación del geoide. Se toma constante para la zona.
 umint proy;	//Uno de los valores SIS_...
 union{
	 bool8 orden_λφ;	//Para geográficas. =0 si el orden es φ,λ; =1 si es λ,φ.
	 double φ0;	//En grados sexagesimales
	 double conv0;	//Convergencia de meridianos para Conforme genérico (SIS_Conforme), en grados sexagesimales
	 struct{
		 double ky; //Factor de escala por el que se multiplica sólo la y
		 double α; //Para pointed. Va de α=0: PlanoCuadra a α=1: Pointed
	 } eqsim; //ky se aplica a todas las proyecciones simétricas respecto al ecuador más o menos equivalentes
 } param1;
 double Λ0; //En radianes
 double k0;
 double xO;
 double yS;
} SistemaDefinicion;

typedef struct{
	const char8_t* datum_and_projection_name;
	const char8_t* elip;
	double λ0;
	double linear_units;	//En relación al metro
	const char8_t* linear_units_abr;
} SistemaInformacion;

typedef struct _Sistema{
 SistemaInformacion infor; //Las funciones de esta librería no lo emplean para nada
 SistemaDefinicion sis;
 struct{
	 struct{
		 double ak0;	//a*k0
	 } Comun;
	 union{
		 struct{
			 double φ0;	//en radianes
			 double sinφ0;
			 double R0;
			 double d;
			 double c;
		 } Lambert;
		 struct{
			 double K; //2 * [(1-e)/(1+e)]^(e/2) * ak0/sqrt(1-e^2)
		 } Estereografica;
		 struct{
			 double sinΦ0, cosΦ0; //Φ0: Latitud "conforme"
			 double K; //k de aΦ <-- ρφ en el punto φ0.
		 } EstereoOblicua;
		 struct{
			 double e_div_1minus_e;
		 } UTM;
	 };
 } precalc;
 //Definición del sistema local. Este sistema consta de tres ejes X,Y,Z, con el plano XY tangente al elipsoide
 //y el eje Y siguiendo la misma dirección que el eje 'y' de la proyección.
 struct{	//Coordenadas del punto que se toma como origen de coordenadas del sistema local.
	 Puntoxy_double proy;	//En la proyección: (x,y)
	 Puntoxy_double geog;	//En geográficas: (λ,φ)
	 PuntoXYZ_double geoc; //En geocéntricas (X,Y,Z)
	 double conv1;	//Convergencia de meridianos. Ángulo entre el eje 'y' de la proyección y el Norte, y por tanto
						//también entre el eje Y del sistema local y el Norte. Positivo si el eje y de la proyección
						//está girado hacia el Este respecto al Norte geográfico.
 } local;
} Sistema;
