#pragma once
#define ATCRT_TYPES_ONLY
#include <ATcrt/ATuint.h>
#undef ATCRT_TYPES_ONLY
/*Inversión de matrices simétricas y solución de sistemas con ellas.
Se emplea solamente la mitad superior de la matriz. Es decir, que la parte de la matriz por debajo de
la diagonal puede venir con valores cualesquiera, no se emplean. La matriz invertida se escribe entera.

Las funciones ATinvsim devuelven siempre 0. En las otras, si durante el proceso de inversión algún
elemento de la diagonal principal resulta negativo se detiene la inversión y se devuelve
ATINVSIM_NEG. Si esto no sucede devuelven 0.

La función resuelve_sistema_sim_t resuelve el sistema de matriz N, términos independientes L y
número de parámetros n. La solución queda almacenada en el propio vector L. Al contrario que
las funciones de inversión de matrices, la matriz N solamente almacena la mitad, de ahí el
sufijo _t en el nombre de la función, que significa 'triangular'. Los valores están almacenados
siguiendo un orden que lo hace independiente del número de parámetros:
n11, n12,n22, n13,n23,n33,...

La función resuelve_sistema_sim_t_2 es igual pero recibe dos vectores de términos independientes
y resuelve por tanto dos sistemas a la vez.
Las funciones devuelven ATINVSIM_NEG si en el proceso de solución en algún momento un término
de la diagonal principal resulta negativo, sin por ello dejar de resolver el sistema. Devuelven 0 en caso
contrario.
*/
#define ATINVSIM_NEG 1
int ATinvsim_fl(float* N, uint n);
int ATinvsim_dbl(double* N, uint n);
int ATinvsim_pos_fl(float* N, uint n);
int ATinvsim_pos_dbl(double* N, uint n);
int ATinvsim_cho_fl(float* N, uint n);
int ATinvsim_cho_dbl(double* N, uint n);
int resuelve_sistema_sim_t_fl(float* N, float* L, uint n);
int resuelve_sistema_sim_t_dbl(double* N, double* L, uint n);
int resuelve_sistema_sim_t_2_fl(float* N, float* L1, float* L2, uint n);
int resuelve_sistema_sim_t_2_dbl(double* N, double* L1, double* L2, uint n);

#ifndef COMPILING_ATMATRICES

#ifndef __cplusplus

#ifdef GENERIC_NOT_IMPLEMENTED

//I assume that if float and double are the same size they are represented the same way
#define ATinvsim(N,n)		sizeof(*(N))==sizeof(float) ? ATinvsim_fl((float*)N,n) : ATinvsim_dbl((double*)N,n)
#define ATinvsim_pos(N,n)	sizeof(*(N))==sizeof(float) ? ATinvsim_pos_fl((float*)N,n) : ATinvsim_pos_dbl((double*)N,n)
#define ATinvsim_cho(N,n)	sizeof(*(N))==sizeof(float) ? ATinvsim_cho_fl((float*)N,n) : ATinvsim_cho_dbl((double*)N,n)
#define resuelve_sistema_sim_t(N,L,n)			sizeof(*(N))==sizeof(float) ? resuelve_sistema_sim_t_2_fl((float*)N,(float*)L,n) : resuelve_sistema_sim_t_dbl((double*)N,(double*)L,n)
#define resuelve_sistema_sim_t_2(N,L1,L2,n)	sizeof(*(N))==sizeof(float) ? resuelve_sistema_sim_t_2_fl((float*)N,(float*)L1,(float*)L2,n) : resuelve_sistema_sim_t_2_dbl((double*)N,(double*)L1,(double*)L2,n)

#else

#define ATinvsim(N,n)		_Generic(*(N), float: ATinvsim_fl, double: ATinvsim_dbl)(N,n)
#define ATinvsim_pos(N,n)	_Generic(*(N), float: ATinvsim_pos_fl, double: ATinvsim_pos_dbl)(N,n)
#define ATinvsim_cho(N,n)	_Generic(*(N), float: ATinvsim_cho_fl, double: ATinvsim_cho_dbl)(N,n)
#define resuelve_sistema_sim_t(N,L,n)			_Generic(*(N), float: resuelve_sistema_sim_t_fl, double: resuelve_sistema_sim_t_dbl)(N,L,n)
#define resuelve_sistema_sim_t_2(N,L1,L2,n)	_Generic(*(N), float: resuelve_sistema_sim_t_2_fl, double: resuelve_sistema_sim_t_2_dbl)(N,L1,L2,n)

#endif

#else //__cplusplus

inline int ATinvsim(float* N, uint n){return ATinvsim_fl(N,n);}
inline int ATinvsim_pos(float* N, uint n){return ATinvsim_pos_fl(N,n);}
inline int ATinvsim_cho(float* N, uint n){return ATinvsim_cho_fl(N,n);}
inline int resuelve_sistema_sim_t(float* N,float* L, uint n){return resuelve_sistema_sim_t_fl(N,L,n);}
inline int resuelve_sistema_sim_t_2(float* N,float* L1,float* L2, uint n){return resuelve_sistema_sim_t_fl_2(N,L1,L2,n);}

inline int ATinvsim(double* N, uint n){return ATinvsim_dbl(N,n);}
inline int ATinvsim_pos(double* N, uint n){return ATinvsim_pos_dbl(N,n);}
inline int ATinvsim_cho(double* N, uint n){return ATinvsim_cho_dbl(N,n);}
inline int resuelve_sistema_sim_t(double* N,double* L, uint n){return resuelve_sistema_sim_t_fl(N,L,n);}
inline int resuelve_sistema_sim_t_2(double* N,double* L1,double* L2, uint n){return resuelve_sistema_sim_t_fl_2(N,L1,L2,n);}

#endif //__cplusplus

#endif
