//#includeif mergestring(strconv_,SYSTEM.c)

#ifndef IGNORE_ALL
//...___strto functions don't need to skip initial blanks nor to check for overflows

static const double pot10pos[]={1.0,10.0,100.0,1000.0,10000.0,100000.0,1000000.0,1000000.0};
static const double pot10neg[]={1.0,0.1,.01,.001,.0001,.00001,.000001,.0000001};
//The decimal separator can be eiher '.' or ',', but this latter may be removed
//in the future (if for instance some values in a file could be separated by comas)
//for 64-bit integers, integer parsing of the integer part and decimal part would
//suffice and would probably be faster.
#ifndef FUNCTION_double___str8
double double___str8(iconst char8_t **ps){
	const char8_t *s1=*ps;
	int signo=0;
	double x=0, z;
	int e;
	unsigned int c;
	if(*s1=='-'){signo=1; s1++;}
	else if(*s1=='+') s1++;

//integerpart:
	while((c=*s1-'0')<10){
		x*=10; x+=c;
		s1++;
	}
	c+='0';
	if(c=='.' || c==',') goto decimalpart;
	if(c=='e' || c=='E') goto exponent;
	goto _return;
decimalpart:
	z=0.1;	//The precision of a double is far more than I need
	while((c=*++s1-'0')<10){
		x+=c*z; z*=0.1;	//and, further, dividing does not increase error
	}
	c+='0';
	if(c!='e' && c!='E') goto _return;
exponent:
	if(signo) x=-x;
	if(*++s1=='-'){signo=1; s1++;}
	else{signo=0; if(*s1=='+') s1++;}
	if(*s1=='0') s1++;	//very likely
	e=0;
	if(*s1=='0') s1++;
	while((c=*s1-'0')<10){
		e*=10; e+=c;
		s1++;
	}
	if(signo){
		while(e>7){x*=0.00000001; e-=8;}
		x*=pot10neg[e];
	}else{
		while(e>7){x*=100000000.0; e-=8;}
		x*=pot10pos[e];
	}
	goto _exp_return;

_return:
	if(signo) x=-x;
_exp_return:
	*ps=s1;
	return x;
}
#endif

//Here the separator can only be '.'. vf stands for very fast
#ifndef FUNCTION_vfdouble___str8
double vfdouble___str8(iconst char8_t **ps){
	const char8_t *s1=*ps;
	bint signo=0;
	double x=0, z;
	unsigned int c;
	if(*s1=='-'){signo=1; s1++;}
	else if(*s1=='+') s1++;

//integerpart:
	while((c=*s1-'0')<10){
		x*=10; x+=c;
		s1++;
	}
	if(c+'0'=='.'){	//decimalpart:
		z=0.1;
		while((c=*++s1-'0')<10){
			x+=c*z; z*=0.1;	//and, further, dividing does not increase error
		}
	}

	if(signo) x=-x;
	*ps=s1;
	return x;
}
#endif

#ifndef FUNCTION_ssint___str8
ssint ssint___str8(iconst char8_t** ps){
	const char8_t *s1=*ps;
	bint signo=0;
	unsigned int c, x=0;	//in order to avoid overflow problems
	ssint sx;

	if(*s1=='-'){signo=1; s1++;}
	else if(*s1=='+') s1++;
	while((c=*s1-'0')<10){ s1++;
		x*=10; x+=c;
	}
	ifunlike(x>0x7fffFfff) x=0x7fffFfff;
	sx=(ssint)x;
	if(signo) sx=-sx;

	*ps=s1;
	return sx;
}
#endif

#ifndef FUNCTION_uint_check___str8
uint uint_check___str8(iconst char8_t** ps){
	const char8_t *s1=*ps;
	uint c, x=0;
	const uint M=0xffffFfffU / 10;

	ifunlike(*s1=='+') s1++;
	while(*s1=='0') s1++;
	if((c=*s1-'0')>=10) goto salida;
	x=c; s1++; //Primera cifra
	while((c=*s1-'0')<10){
		ifunlike(x>M) goto salida_mala;
		x*=10; x+=c;
		ifunlike(x<10) goto salida_mala;
		s1++;
	}
	goto salida;

salida_mala:
	x=-1U;
salida:
	*ps=s1;
	return (uint)x;
}
#endif

#ifndef FUNCTION_ssint_check___str8
ssint ssint_check___str8(iconst char8_t** ps){
	const char8_t *s1=*ps;
	bint signo=0;
	uint c, x=0;
	ssint sx;
	const uint M1=0x7fffFfffU / 10;
	const uint M2=0x80000000U;

	if(*s1=='+') s1++;
	else if(*s1=='-'){signo=1; s1++;}
	while((c=*s1-'0')<10){
		ifunlike(x>M1) goto salida_mala;
		x*=10; x+=c;
		ifunlike(x>=M2) goto salida_mala;
		s1++;
	}
	sx=(ssint)x;
	if(signo) sx=-sx;
	goto salida;

salida_mala:
	sx=-0x7fffFfff-1;
salida:
	*ps=s1;
	return sx;
}
#endif

#ifndef FUNCTION_basedinteger___str8
uint basedinteger___str8(iconst char8_t **ps){
	if(**ps=='0'){
		char8_t c;
		(*ps)++;
		c=*(*ps)++;
		switch(c){
			case 'h': case 'x': return hex___str8(ps);
			case 'd': return uint___str8(ps);
			case 'c': return oct___str8(ps);
			case 'b': return bin___str8(ps);
		}
		(*ps)--;
	}
	return 0;
}
#endif

#ifndef FUNCTION_ncifras
static inline uint ncifras(uint x){
	uint y=10, k=1;
	if(x<10) return 1;
	do y*=10, k++; while(y<=x);
	return k;
}
#endif

#ifndef FUNCTION_str8___uint
char8_t* str8___uint(char8_t* ptr, uint x){
	char8_t *fin;
	ptr+=ncifras(x);
	fin=ptr--;
	while(x>=10){
		uint y=x/10;
		*ptr--=(char8_t)(x-10*y+'0');
		x=y;
	}
	*ptr=(char8_t)x+'0';
	return fin;
}
#endif

#ifndef FUNCTION_str8___t_min
char8_t* str8___t_min(char8_t* ptr, uint t_min, umint bl){
	const char8_t * const sm[3]={" m"," min"," minutos"};
	ifunlike(bl>2) bl=2;

	if(t_min>=60){
		uint h=t_min/60;
		ptr=str8___uint(ptr,h); *ptr++=' '; *ptr++='h'; *ptr++=' ';
		t_min-=h*60;
	}
	ptr=str8___uint(ptr,t_min);
	ptr=strpcpy8(ptr,sm[bl]);
	return ptr;
}
#endif

#undef FUNCTION_double___str8
#undef FUNCTION_vfdouble___str8
#undef FUNCTION_uint___str8
#undef FUNCTION_ssint___str8
#undef FUNCTION_hex___str8
#undef FUNCTION_oct___str8
#undef FUNCTION_bin___str8
#undef FUNCTION_basedinteger___str8
#undef FUNCTION_ncifras
#undef FUNCTION_str8___uint
#undef FUNCTION_str8___t_min

#else
#undef IGNORE_ALL
#endif
