#define IGNORE_ALL
#include <io.h>
#include <errno.h>
#include <fcntl.h>
#include <sys\stat.h>

#define BufSize 010000
#define to_EXTRASIZE 0200

static int setupbuf(Buffer_bo *buf, uint size, uint extra_size){
	ifunlike(buf->id==ID_NOFILE && errno!=0){
		buf->base=NULL;
		if(errno==ENOENT) return ATFILEO_OPEN_BADPATH;
		if(errno==EMFILE) return ATFILEO_OPEN_NOMORE;
		if(errno==EACCES) return ATFILEO_OPEN_NOTALLOWED;
		return ATFILEO_OPEN_UNKNOWN;
	}
	buf->base=(uint*)malloc((size+extra_size)*usizeof(uint));
	ifunlike(buf->base==NULL){
		_close((int)buf->id);
		buf->id=ID_NOFILE;
		return AT_NOMEM;
	}
	buf->top=buf->base+size;
	buf->ptr=buf->base;
	buf->error_code=0;
	return 0;
}
int boopen16(Buffer_bo *buf, const char16_t* fichero, u8int endianness){
	buf->id=(uintptr_t)_wopen(fichero,_O_CREAT|_O_TRUNC|_O_WRONLY | _O_BINARY, _S_IREAD | _S_IWRITE );
	buf->endian=endianness;
	return setupbuf(buf,BufSize,0);
}
int boopen8(Buffer_bo *buf, const char8_t* fichero, u8int endianness){
	buf->id=(uintptr_t)_open(fichero,_O_CREAT|_O_TRUNC|_O_WRONLY | _O_BINARY, _S_IREAD | _S_IWRITE );
	buf->endian=endianness;
	return setupbuf(buf,BufSize,0);
}

static int to_setup_buffer(BuffertoGeneric *buf, uint size, u8int SIZE){
	int nret=setupbuf((Buffer_bo*)buf,size,to_EXTRASIZE);
	ifunlike(nret) return nret;

	buf->backPtr=buf->top+(to_EXTRASIZE-1)*usizeof(uint);
	*(uint*)buf->backPtr=0;
	buf->backPtr-=SIZE;
	buf->flushedchars=0;
	buf->flt_flags=0;
	buf->prec.absol=2;
	buf->prec.signi=4;
	return 0;
}
int toopen8(Bufferto8 *buf, const char8_t* fichero){
	if(fichero==NULL){buf->id=ID_NOFILE; errno=0;}
	else buf->id=(uintptr_t)_open(fichero,_O_CREAT|_O_TRUNC|_O_WRONLY | _O_TEXT, _S_IREAD | _S_IWRITE );
	int nret=to_setup_buffer(buf,BufSize,sizeof(char8_t));
	buf->fillchar=' ';
	buf->maschar='\0';
	return nret;
}
int toopen_mixed(Bufferto8 *buf, const char16_t* fichero){
	if(fichero==NULL){buf->id=ID_NOFILE; errno=0;}
	else buf->id=(uintptr_t)_wopen(fichero,_O_CREAT|_O_TRUNC|_O_WRONLY | _O_TEXT, _S_IREAD | _S_IWRITE );
	int nret=to_setup_buffer(buf,BufSize,sizeof(char8_t));
	buf->fillchar=' ';
	buf->maschar='\0';
	return nret;
}
int toopen16(Bufferto16 *buf, const char16_t* fichero){
	if(fichero==NULL){buf->id=ID_NOFILE; errno=0;}
	else buf->id=(uintptr_t)_wopen(fichero,_O_CREAT|_O_TRUNC|_O_WRONLY | _O_U16TEXT, _S_IREAD | _S_IWRITE );
	int nret=to_setup_buffer((BuffertoGeneric*)buf,BufSize,sizeof(char16_t));
	buf->fillchar=u' ';
	buf->maschar=u'\0';
	return nret;
}
int SetupFormatter(ATFormatter *buf){
	buf->id=ID_NOFILE; errno=0;
	int nret=to_setup_buffer(buf,0400,sizeof(char8_t));
	buf->fillchar=u' ';
	buf->maschar=u'\0';
	return nret;
}

void to_immediateclose(BuffertoGeneric *buf){
	if(buf->id!=ID_NOFILE) _close((int)buf->id);
	iflike(buf->base!=NULL){free(buf->base); buf->base=NULL;}
	buf->id=ID_NOFILE;
}
//0: successful; see error codes in ATfileoutput.h
void to_internalflush(BuffertoGeneric *buf){
	int i;
	ifunlike(buf->error_code) return;
	ifunlike(buf->id==ID_NOFILE){buf->error_code=ATFILEO_ERROR_NOSPACE; return;}
	i=_write((int)buf->id,buf->base,(pdif)(buf->ptr-buf->base)*usizeof(char8_t));
	iflike(i>=0) return;
	if(errno==ENOSPC) buf->error_code=ATFILEO_ERROR_NOSPACE;
	buf->error_code=ATFILEO_ERROR_OTHER;
}
void toclose_generic(BuffertoGeneric *buf){
	if(buf->id!=ID_NOFILE) to_internalflush(buf);
	to_immediateclose(buf);
}
