#include "../include/ATmacros.h"
#include <stdio.h>
#include <windows.h>

void makepath_to_exec8(char8_t* path, const char8_t* ruta){
	char *filename;
	if(!SearchPathA(NULL,(char*)ruta,NULL,SHRT_PATH,(char*)path,&filename)){
		//char *pathref, *end;
		//_get_pgmptr(&pathref); No funciona
		char pathref[SHRT_PATH-1], *end;
		GetModuleFileNameA(NULL,pathref,SHRT_PATH-1);
		path_get_filename8(pathref,end); *end='\0';
		makepath8(path,SHRT_PATH,pathref,ruta);
	}
}

void makepath_to_exec16(char16_t* path, const char16_t* ruta){
	char16_t *filename;
	if(!SearchPathW(NULL,ruta,NULL,SHRT_PATH,path,&filename)){
		char16_t pathref[SHRT_PATH-1], *end;
		GetModuleFileNameW(NULL,pathref,SHRT_PATH-1);
		path_get_filename16(pathref,end); *end='\0';
		makepath16(path,SHRT_PATH,pathref,ruta);
	}
}

/* fileclass */

u8int fileclass8(const char8_t *file){
	char8_t filenodir[SHRT_DIR];
	const char8_t *ptr;
	WIN32_FIND_DATAA files_found;

	//Si se pasa una ruta a un directorio con el "/" de cierre, da error
	ptr=file; while(*ptr!='\0') ptr++; ptr--;
	if(ispath_sep(ptr)){
		if((pdif)(ptr-file)>SHRT_DIR) ptr=filenodir; //Y dará error
		else{
			char8_t *p=filenodir;
			while(file!=ptr) *p++=*file++; //Do no copy the closing '\0'
			*p='\0'; //Here was the final '\\\' or '/'.
			ptr=filenodir;
		}
	}else{
		ptr=file;
	}

	HANDLE handle=FindFirstFileA(ptr,&files_found);
	if(handle==INVALID_HANDLE_VALUE){
		if(GetLastError()==ERROR_FILE_NOT_FOUND) return ATFILETYPE_NOFILE;
		return ATFILETYPE_ERROR;
	}
	FindClose(handle);

	int nret=GetFileAttributesA(ptr);
	if(nret==INVALID_FILE_ATTRIBUTES) return ATFILETYPE_NOFILE; //file puede ser un wildcard.
	if(nret&FILE_ATTRIBUTE_DIRECTORY) return ATFILETYPE_DIRECTORY;
	 return ATFILETYPE_FILE;
}

u8int fileclass16(const char16_t *file){
	char16_t filenodir[SHRT_DIR];
	const char16_t *ptr;
	WIN32_FIND_DATAW files_found;

	//Si se pasa una ruta a un directorio con el "/" de cierre, da error
	ptr=file; while(*ptr!='\0') ptr++; ptr--;
	if(ispath_sep(ptr)){
		if((pdif)(ptr-file)>SHRT_DIR) ptr=filenodir; //Y dará error
		else{
			char16_t *p=filenodir;
			while(file!=ptr) *p++=*file++;  //Do no copy the closing '\0'
			*p='\0'; //Here was the final '\\\' or '/'.
			ptr=filenodir;
		}
	}else{
		ptr=file;
	}

	HANDLE handle=FindFirstFileW(ptr,&files_found);
	if(handle==INVALID_HANDLE_VALUE){
		if(GetLastError()==ERROR_FILE_NOT_FOUND) return ATFILETYPE_NOFILE;
		return ATFILETYPE_ERROR;
	}
	FindClose(handle);

	int nret=GetFileAttributesW(ptr);
	if(nret==INVALID_FILE_ATTRIBUTES) return ATFILETYPE_NOFILE; //file puede ser un wildcard.
	if(nret!=INVALID_FILE_ATTRIBUTES && (nret&FILE_ATTRIBUTE_DIRECTORY)) return ATFILETYPE_DIRECTORY;
	 return ATFILETYPE_FILE;
}

/* ATCreateDirectory */

int ATCreateDirectory8(const char8_t* path){
	int nret;
	char SYSCALL[SHRT_DIR+20];

	//mkdir devuelver error si la carpeta ya existe, y no
	//se puede distinguir de un error real. Por ello miramos si el directorio existe:
	nret=GetFileAttributesA(path);
	if(nret!=INVALID_FILE_ATTRIBUTES){
		if(nret&FILE_ATTRIBUTE_DIRECTORY) return 0;
		else return ATFILESYS_ISNOT_DIR;
	}

	char *pc=strpcpy8(SYSCALL,"mkdir \"");
	pc=strpcpy8(pc,path); *pc++='\"'; *pc='\0';
	nret=system(SYSCALL);
	if(nret==0) return 0;
	return ATFILESYS_ERROR;
}

int ATCreateDirectory16(const char16_t* path){
	int nret;
	char16_t SYSCALL[SHRT_DIR+20];

	//mkdir devuelve error si la carpeta ya existe, y no
	//se puede distinguir de un error real. Por ello miramos si el directorio existe:
	nret=GetFileAttributesW(path);
	if(nret!=INVALID_FILE_ATTRIBUTES){
		if(nret&FILE_ATTRIBUTE_DIRECTORY) return 0;
		else return ATFILESYS_ISNOT_DIR;
	}

	char16_t *pc=strpcpy16(SYSCALL,u"mkdir \"");
	pc=strpcpy16(pc,path); *pc++=u'\"'; *pc='\0';
	ifz(_wsystem((wchar_t*)SYSCALL)) return 0;
	return ATFILESYS_ERROR;
}

/* ATDeleteFile */

int ATDeleteFile8(const char8_t* path){
	ifz(remove(path)) return 0;
	if(errno==ENOENT) return 0;
	return ATFILESYS_ERROR;
}

int ATDeleteFile16(const char16_t* path){
	ifz(_wremove(path)) return 0;
	if(errno==ENOENT) return 0;
	return ATFILESYS_ERROR;
}

/*	ATFindFiles_isOK
	findnextfile_start,
	findnextfile_next,
	findnextfile_end
*/

bint ATFindFiles8_isOK(const ATFindFiles8 *find_files){
	return find_files->pattern[0]!='\0';
}
ATFindFiles8* findnextfile_start8(const char8_t* pattern){
	ATFindFiles8 *find;
	char8_t *pw, *pfinal;
	const char8_t *p;
	find=(ATFindFiles8*)malloc(sizeof(ATFindFiles8));
	ifunlike(find==NULL) return NULL;

	pfinal=find->pattern+SHRT_PATH;
	find->handle=NULL;
	for(pw=find->pattern, p=pattern; pw!=pfinal && *p!='\0'; *pw++=*p++);
	if(pw==pfinal) find->pattern[0]='\0';
	else *pw='\0';
	return find;
}
int findnextfile8(ATFindFiles8 *find_files, char8_t buffer[SHRT_PATH]){
	if(find_files->pattern[0]=='\0'){buffer[0]='\0'; return 0;}
	if(find_files->handle==INVALID_HANDLE_VALUE){buffer[0]='\0'; return 1;}

	WIN32_FIND_DATAA Win_filedata;
	if(find_files->handle==NULL){
		find_files->handle=FindFirstFileA(find_files->pattern,&Win_filedata);
		if(find_files->handle==INVALID_HANDLE_VALUE){
			buffer[0]='\0';
			if(GetLastError()==ERROR_FILE_NOT_FOUND) return 0;
			return 1;
		}
	}else{
		BOOL i;
		i=FindNextFileA(find_files->handle,&Win_filedata);
		if(i==0){buffer[0]='\0'; return 0;}
	}
	strcpy8(buffer,Win_filedata.cFileName);
	return 0;
}
int findnextfile_end8(ATFindFiles8 *find_files){
	if(find_files==NULL) return 0;
	if(find_files->handle!=INVALID_HANDLE_VALUE) FindClose(find_files->handle);
	free(find_files);
	return 0;
}
//
bint ATFindFiles16_isOK(const ATFindFiles16 *find_files){
	return find_files->pattern[0]!='\0';
}
ATFindFiles16* findnextfile_start16(const char16_t* pattern){
	ATFindFiles16 *find;
	char16_t *pw, *pfinal;
	const char16_t *p;
	find=(ATFindFiles16*)malloc(sizeof(ATFindFiles16));
	ifunlike(find==NULL) return NULL;

	pfinal=find->pattern+SHRT_PATH;
	find->handle=NULL;
	for(pw=find->pattern, p=pattern; pw!=pfinal && *p!='\0'; *pw++=*p++);
	if(pw==pfinal) find->pattern[0]='\0';
	else *pw='\0';
	return find;
}
int findnextfile16(ATFindFiles16 *find_files, char16_t buffer[SHRT_PATH]){
	if(find_files->pattern[0]=='\0'){buffer[0]='\0'; return 0;}
	if(find_files->handle==INVALID_HANDLE_VALUE){buffer[0]='\0'; return 1;}

	WIN32_FIND_DATAW Win_filedata;
	if(find_files->handle==NULL){
		find_files->handle=FindFirstFileW(find_files->pattern,&Win_filedata);
		if(find_files->handle==INVALID_HANDLE_VALUE){
			buffer[0]='\0';
			if(GetLastError()==ERROR_FILE_NOT_FOUND) return 0;
			return 1;
		}
	}else{
		BOOL i;
		i=FindNextFileW(find_files->handle,&Win_filedata);
		if(i==0){buffer[0]='\0'; return 0;}
	}
	strcpy16(buffer,Win_filedata.cFileName);
	return 0;
}
int findnextfile_end16(ATFindFiles16 *find_files){
	if(find_files==NULL) return 0;
	if(find_files->handle!=INVALID_HANDLE_VALUE) FindClose(find_files->handle);
	free(find_files);
	return 0;
}
