#include "../include/ATmacros.h"
#include "../include/ATfunctions.h" //for _unused
#include <errno.h>
#include <unistd.h>

void makepath_to_exec8(char8_t* _unused(path), const char8_t* _unused(ruta)){
	return;
}

void makepath_to_exec16(char16_t* _unused(path), const char16_t* _unused(ruta)){
	return;
}

u8int fileclass8(const char8_t *file){
	struct stat info;
	int nret=stat(file,&info);
	if(nret==-1) return ATFILETYPE_ERROR;
	if(S_ISDIR(info.st_mode)) return ATFILETYPE_DIRECTORY;
	if(S_ISREG(info.st_mode)) return ATFILETYPE_FILE;
	return ATFILETYPE_NOFILE;
}

u8int fileclass16(const char16_t *file){
	char8_t file8[SHRT_PATH];
	if(stru8___str16(NULL,file)>SHRT_PATH) return ATFILESYS_BADPATH;
	stru8___str16(file8,file);
	return fileclass8(file8);
}

int ATCreateDirectory8(const char8_t* path){
	struct stat info;
	int nret=stat(path,&info);
	if(nret==0 && S_ISDIR(info.st_mode)) return 0;

	ifz(mkdir(path,S_IALL)) return 0;
	return ATFILESYS_ERROR;
}

int ATCreateDirectory16(const char16_t* path){
	char8_t file8[SHRT_DIR];
	if(stru8___str16(NULL,path)>SHRT_DIR) return ATFILESYS_BADPATH;
	stru8___str16(file8,path);
	return ATCreateDirectory8(file8);
}

//The function uses unlink instead of remove because the latter removes
//also directories, if its argument is so.
int ATDeleteFile8(const char8_t* path){
	ifz(unlink(path)) return 0;
	if(errno==ENOENT) return 0;
	if(errno==EACCES) return ATFILESYS_ERROR;
	return ATFILESYS_ISNOT_FILE;

}

int ATDeleteFile16(const char16_t* path){
	char8_t file8[SHRT_DIR];
	if(stru8___str16(NULL,path)>SHRT_DIR) return ATFILESYS_BADPATH;
	stru8___str16(file8,path);
	return ATDeleteFile8(file8);
}

//The following code (the next three functions) has never been tested,
//so it is probably buggy.

bint ATFindFiles8_isOK(const ATFindFiles8 *find){
	return find->dp!=NULL && find->compiled_pattern.buffer!=NULL;
}
ATFindFiles8* findnextfile_start8(const char8_t* pattern){
	ATFindFiles8 *find;
	char8_t *pw;
	const char8_t *p, *pf;
	find=(ATFindFiles8*)malloc(sizeof(ATFindFiles8));
	ifunlike(find==NULL) return NULL;

	find->dp=NULL;
	//Obtener el nombre del directorio y abrirlo
	path_get_filename8(pattern,pf);
	if((pdif)(pf-pattern)>=SHRT_DIR) return find;
	for(pw=find->dirname, p=pattern; p!=pf; *pw++=*p++); *pw='\0';
	find->dp=opendir(find->dirname);
	if(find->dp==NULL) return find;

	//Compilar la plantilla para el nombre del fichero para que esté lista para usar
	//Mantener el valor de re_syntax_options que hubiera
	find->compiled_pattern.translate=NULL;
	find->compiled_pattern.fastmap=0;
	find->compiled_pattern.buffer=NULL;
	re_compile_pattern(pf,strlen8(pf),&find->compiled_pattern);
	return find;
}

int findnextfile8(ATFindFiles8 *find_files, char8_t buffer[SHRT_PATH]){
	struct dirent *ep;
	uint len;

	buffer[0]='\0';
	if(find_files->dp==NULL) return 1;
	do{
		if((ep=readdir(find_files->dp))==NULL) break;
		len=strlen8(ep->d_name);
		if(re_match(&find_files->compiled_pattern,ep->d_name,len,0,NULL)==(int)len) break;
	}while(1);
	if(ep!=NULL){ //If we exited because the pattern was matched
		char8_t *pf=strpcpy8(buffer,find_files->dirname);
		if(len>=(pdif)(buffer+SHRT_PATH-pf)) return 1; //No hay espacio para copiar el nombre del fichero
		strcpy8(pf,ep->d_name);
	}
	return 0;
}
int findnextfile_end8(ATFindFiles8 *find_files){
	if(find_files==NULL) return 0;
	regfree(&find_files->compiled_pattern);
	if(find_files->dp!=NULL) closedir(find_files->dp);
	free(find_files);
	 return 0;
}

bint ATFindFiles16_isOK(const ATFindFiles16 *find){
	return find->dp!=NULL && find->compiled_pattern.buffer!=NULL;
}
ATFindFiles16* findnextfile_start16(const char16_t* _unused(pattern)){
	return NULL;
}
int findnextfile16(ATFindFiles16 *_unused(find_files), char16_t _unused(buffer[SHRT_PATH])){
	return 0;
}
int findnextfile_end16(ATFindFiles16 *find_files){
	if(find_files==NULL) return 0;
	free(find_files);
	return 0;
}
