﻿#include "../include/ATarrays.h"
#include "../include/ATmacros.h"

#ifndef FINDFILES

char8_t **findfiles8(const char8_t* pattern){
	char8_t* *punteros;
	Vector_uint beg; //Punteros a los nombres de los ficheros, que estarán todos en fnames.
	Growing_char8_t fnames; //Espacio para todos los nombres de los ficheros
	ATFindFiles8 *files;

	ifunlike((files=findnextfile_start8(pattern))==NULL) return NULL;
	fnames.ppio=NULL;
	Vsetup(uint,beg,24,return NULL);
	GC8_initialize(fnames,400,goto salida_error);

	ifunlike(!ATFindFiles8_isOK(files)) goto salida_error;
	do{
		Vadd(beg,uint,(pdif)(fnames.next-fnames.ppio),goto salida_error); //Apunta a donde irá la siguiente cadena
		Greserve_n(fnames,char8_t,SHRT_PATH,goto salida_error);
		ifnzunlike(findnextfile8(files,fnames.next)) goto salida_error; //Copia el nombre del fichero en fnames.next
		if(*fnames.next=='\0') break;
		do fnames.next++; while(*fnames.next!='\0');
		fnames.next++; //Aquí empezará la siguiente cadena
	}while(1);
	findnextfile_end8(files);

	beg.ppio[beg.n-1]=Я; //El último puntero ha quedado apuntando al aire
	checked_malloc_n(punteros,char8_t*,beg.n,goto salida_error)
	{uint *pn=beg.ppio; char8_t** pptr=punteros;
	while(*pn!=Я) *pptr++=fnames.ppio+*pn++;
	*pptr=NULL;}

	free(beg.ppio);
	if(punteros[0]==NULL) free(fnames.ppio); //No hay ningún fichero cuyo nombre se ajuste a 'pattern', y por ello punteros[0] no es fnames.ppio, sino NULL.
	return punteros; //habrá que liberar punteros y fnames.ppio (=punteros[0], salvo el caso de la línea anterior)

salida_error:
	freeif(fnames.ppio);
	free(beg.ppio);
	findnextfile_end8(files);
	return NULL;
}

char16_t **findfiles16(const char16_t* pattern){
	char16_t* *punteros;
	Vector_uint beg; //Punteros a los nombres de los ficheros, que estarán todos en fnames.
	Growing_char16_t fnames; //Espacio para todos los nombres de los ficheros
	ATFindFiles16 *files;

	ifunlike((files=findnextfile_start16(pattern))==NULL) return NULL;
	fnames.ppio=NULL;
	Vsetup(uint,beg,24,return NULL);
	GC16_initialize(fnames,400,goto salida_error);

	files=findnextfile_start16(pattern);
	ifunlike(!ATFindFiles16_isOK(files)) goto salida_error;
	do{
		Vadd(beg,uint,(pdif)(fnames.next-fnames.ppio),goto salida_error); //Apunta a donde irá la siguiente cadena
		Greserve_n(fnames,char16_t,SHRT_PATH,goto salida_error);
		ifnzunlike(findnextfile16(files,fnames.next)) goto salida_error; //Copia el nombre del fichero en fnames.next
		if(*fnames.next=='\0') break;
		do fnames.next++; while(*fnames.next!='\0');
		fnames.next++; //Aquí empezará la siguiente cadena
	}while(1);
	findnextfile_end16(files);

	beg.ppio[beg.n-1]=Я; //El último puntero ha quedado apuntando al aire
	checked_malloc_n(punteros,char16_t*,beg.n,goto salida_error)
	{uint *pn=beg.ppio; char16_t** pptr=punteros;
	while(*pn!=Я) *pptr++=fnames.ppio+*pn++;
	*pptr=NULL;}

	free(beg.ppio);
	if(punteros[0]==NULL) free(fnames.ppio); //No hay ningún fichero cuyo nombre se ajuste a 'pattern', y por ello punteros[0] no es fnames.ppio, sino NULL.
	return punteros; //habrá que liberar punteros y fnames.ppio (=punteros[0], salvo el caso de la línea anterior)

salida_error:
	freeif(fnames.ppio);
	free(beg.ppio);
	findnextfile_end16(files);
	return NULL;
}

void free_filelist8(char8_t** filelist){
	if(filelist==NULL) return;
	freeif(*filelist);
	free(filelist);
}
void free_filelist16(char16_t** filelist){
	if(filelist==NULL) return;
	freeif(*filelist);
	free(filelist);
}

#else
	#undef FINDFILES
#endif

#if FILE8BITS_ARE_UTF8

u8int (fileclass_utf8)(const char8_t* path){
	return fileclass8(path);
}
int (ATCreateDirectory_utf8)(const char8_t* path){
	return ATCreateDirectory8(path);
}
int (ATDeleteFile_utf8)(const char8_t* path){
	return ATDeleteFile8(path);
}

#else

u8int fileclass_utf8(const char8_t* path){
	int nret;
	uint k;
	char16_t *fichero16;

	k=strlen8(path)+1;
	fichero16=(char16_t*)malloc(k*usizeof(char16_t));
	ifunlike(fichero16==NULL) return (u8int)AT_NOMEM;
	str16___stru8(fichero16,path);
	nret=fileclass16(fichero16);
	free(fichero16);
	return nret;
}

int ATCreateDirectory_utf8(const char8_t* path){
	int nret;
	uint k;
	char16_t *fichero16;

	k=strlen8(path)+1;
	fichero16=(char16_t*)malloc(k*usizeof(char16_t));
	ifunlike(fichero16==NULL) return AT_NOMEM;
	str16___stru8(fichero16,path);
	nret=ATCreateDirectory16(fichero16);
	free(fichero16);
	return nret;
}

int ATDeleteFile_utf8(const char8_t* path){
	int nret;
	uint k;
	char16_t *fichero16;

	k=strlen8(path)+1;
	fichero16=(char16_t*)malloc(k*usizeof(char16_t));
	ifunlike(fichero16==NULL) return AT_NOMEM;
	str16___stru8(fichero16,path);
	nret=ATDeleteFile16(fichero16);
	free(fichero16);
	return nret;
}
#endif
