#include "../include/ATstrconv.h"
#include <errno.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#define FUNCTION_open_tfile8
//#define FUNCTION_open_tfile16
#define FUNCTION_open_bifile
#define BUF_SIZE 320

int makebuffer_from(Bufferti8 *buf, int i){
	char8_t* pc;
	uint k;

	{struct stat info; fstat(i,&info);
	size_t l=info.st_size;
	ifunlike(l==(size_t)-1){close(i); return ATFILEI_UNKNOWN;}
	ifunlike(l>=ATFILEI_MAXSIZE){close(i); return ATFILEI_LARGEFILE;}
	k=(uint)l;
	}

	k+=5, k|=3, k++;		//k+6, redond. arriba
	buf->vbase=malloc(k);
	ifunlike(buf->vbase==NULL){close(i); return AT_NOMEM;}
	buf->pc=pc=(char8_t*)buf->vbase+4;

	k=read(i,pc,k-5);
	*(pc-1)='\n';
	if(_unlikely(k==0) || pc[k-1]!='\n') pc[k++]='\n';	/*so that strchr(buffer.pc,'\n') and str_stn(buffer.pc) never return NULL*/
	pc[k]='\0';
	close(i);
	buf->next=pc-1;
	return (int)k;
}
int code_from_errno(void){
	if(errno==ENOENT) return ATFILEI_NOFILE;
	if(errno==EMFILE) return ATFILEI_NOMORE;
	if(errno==EACCES) return ATFILEI_NOTALLOWED;
	return ATFILEI_UNKNOWN;
}
int tiopen8(Bufferti8 *buf, const char8_t* fichero){
	int i;
	i=open(fichero,O_RDONLY);
	ifunlike(i==-1){buf->vbase=NULL; return code_from_errno();}
	return makebuffer_from(buf,i);
}
int tiopen_mixed(Bufferti8 *buf, const char16_t* fichero){
	int i;
	buf->vbase=NULL;

	char8_t *filename_c, shrt_name[BUF_SIZE];
	filename_c=stru8___str16n_alloc(shrt_name,fichero,BUF_SIZE);
	ifunlike(filename_c==NULL) return AT_NOMEM;

	i=open(filename_c,O_RDONLY);
	if(filename_c!=shrt_name) free(filename_c);
	ifunlike(i==-1){buf->vbase=NULL; return code_from_errno();}
	return makebuffer_from(buf,i);
}

int read_bifile(uint* *buf, int i){
	size_t l;
	uint k;

	{struct stat info; fstat(i,&info);
	l=info.st_size;}
	ifunlike(l==(size_t)-1){close(i); return ATFILEI_UNKNOWN;}
	ifunlike(l>ATFILEI_MAXSIZE){close(i); return ATFILEI_LARGEFILE;}

	k=((uint)l+usizeof(uint)-1)/usizeof(uint);
	*buf=(uint*)malloc(k*usizeof(uint));
	ifunlike(*buf==NULL){close(i); return AT_NOMEM;}
	(*buf)[k-1]=0;
	l=read(i,*buf,l);
	close(i);
	return (int)k;
}
int biopen8(uint* *buf, const char8_t* fichero){
	int i;
	i=open(fichero,O_RDONLY);
	ifunlike(i==-1) return code_from_errno();
	return read_bifile(buf,i);
}
int biopen16(uint* *buf, const char16_t* fichero){
	int i;

	char8_t *filename_c, shrt_name[BUF_SIZE];
	filename_c=stru8___str16n_alloc(shrt_name,fichero,BUF_SIZE);
	ifunlike(filename_c==NULL) return AT_NOMEM;

	i=open(filename_c,O_RDONLY);
	if(filename_c!=shrt_name) free(filename_c);
	ifunlike(i==-1) return code_from_errno();
	return read_bifile(buf,i);
}
