#include "../include/ATstrconv.h"
#include "../include/ATiflike.h"
#define NOMEM_RETURN_CODE AT_NOMEM

//#includeif mergestring(fileinput_,SYSTEM.c)
#include mergestring(fileinput_,SYSTEM.c)

#ifndef IGNOREALL

#include <string.h>

#if !defined(FUNCTION_open_file) || !defined(FUNCTION_open_bfile)
#include <stdio.h>
#include <ATcrt/ATuints.h>

#ifndef FUNTION_filelength
/*It returns the filelength as determined by ftell and rewinds the file. The maximum
supported length is (uint)ATFILE_MINERRROR-1, which is 2^32-8.
Return:
	>=0: The file length
	ATFILEI_UNKNOWN: Unknown error
	ATFILEI_LARGEFILE: The file is too large, viz. > 2^32-8.

    If the file was opened in binary mode, fseek need not support SEEK_END.
    If the file was opened in text mode, the value returned by ftell need not be valid according to the
standard. I should open the file for binary reading, use fseek / ftell on it to get its size, asuming
fseek with SEEK_END is valid for binary streams, then close it, then open it in text mode, hope
it was not modified in the interim, and read, asuming that reading in text mode may decrease
the number of characters but not increase them.
    So there is no compliant way of determining the file size. So I asume that ftell for text files actually
returns the number of characters either before of after reading, as long as it does not return the former
when it may be less than the latter. I also asume that fseek / ftell on bynary streams returns >= the length
of the file.*/

uint AT_filelength(FILE *f){
	long int kk;

	ifunlike(fseek(f,0,SEEK_END)!=0) return (uint)ATFILEI_UNKNOWN;
	kk=ftell(f); //This need not work for binary files, but I have little choice.
	ifunlike(kk==-1L) return (uint)ATFILEI_UNKNOWN;
	rewind(f);
	ifunlike((unsigned long)kk>=(uint)ATFILE_MINERRROR) return (uint)ATFILEI_LARGEFILE;
	return (uint)kk;
}
#endif
#endif

#ifndef FUNCTION_open_tfile8
int makebuffer_from(Bufferti8 *buf, FILE *f){
	uint k;
	char8_t *pc; //non-const.

	k=AT_filelength(f);
	ifunlike(k>=ATFILEI_MAXSIZE){ //Includes the <0 error codes
		if(ispos(k)) k=ATFILEI_LARGEFILE;
		fclose(f);
		return -(int)(-k);
	}

	k+=5, k|=3, k++;		//k+6, redond. arriba
	buf->vbase=malloc(k);
	ifunlike(buf->vbase==NULL){fclose(f); return AT_NOMEM;}
	buf->pc=pc=(char8_t*)buf->vbase+4;

	rewind(f);
	k=(uint)fread(pc,1,k-6,f); //EOF not copyed
	fclose(f);
	*(pc-1)='\n';
	if(_unlikely(k==0) || pc[k-1]!='\n') pc[k++]='\n';	/*so that strchr(buffer.pc,'\n') and str_stn(buffer.pc) never return NULL*/
	pc[k]='\0';
	buf->next=pc-1;
	return (int)k;
}
int tiopen8(Bufferti8 *buf, const char8_t* fichero){
	FILE *f=fopen(fichero,"r");
	ifunlike(f==NULL){buf->vbase=NULL; return ATFILEI_UNKNOWN;}
	return makebuffer_from(buf,f);
}
int tiopen_mixed(Bufferti8 *buf, const char16_t* fichero){
	FILE *f;
	char8_t* filename_c;
	uint k;

	buf->vbase=NULL;
	k=stru8___str16(NULL,fichero);
	//ifunlike(k==Я) ATFILEO_OPEN_BADPATH;
	filename_c=(char8_t*)malloc(k);
	ifunlike(filename_c==NULL) return AT_NOMEM;
	stru8___str16(filename_c,fichero);

	f=fopen(filename_c,"r");
	free(filename_c);
	ifunlike(f==NULL) return ATFILEI_UNKNOWN;
	return makebuffer_from(buf,f);
}
#endif

#ifndef FUNCTION_open_tfile16
int tiopen16(Bufferti16 *buf, const char16_t* fichero){
	FILE *f;
	char8_t* filename_c;
	uint k;
	char16_t *pc;

	buf->vbase=NULL;
	k=stru8___str16(NULL,fichero);
	//ifunlike(k==EOUIA) ATFILEO_OPEN_BADPATH;
	filename_c=(char8_t*)malloc(k);
	ifunlike(filename_c==NULL) return AT_NOMEM;
	stru8___str16(filename_c,fichero);

	f=fopen(filename_c,"rb");
	free(filename_c);
	ifunlike(f==NULL) return ATFILEI_UNKNOWN;
	k=AT_filelength(f);
	ifunlike(k>=ATFILEI_MAXSIZE){ //Includes the <0 error codes
		if(ispos(k)) k=ATFILEI_LARGEFILE;
		fclose(f);
		return -(int)(-k);
	}

	k+=4 +usizeof(char16_t)+usizeof(char16_t);	//u'\n', u'\0'
	k+=3, k&=~3U;
	buf->vbase=malloc(k);
	ifunlike(buf->vbase==NULL){fclose(f); return AT_NOMEM;}
	buf->pc=pc=(char16_t*)((char8_t*)buf->vbase+4);

	k=(uint)fread(pc,1,k-4-usizeof(char16_t)-usizeof(char16_t),f); //EOF not copyed
	fclose(f);
	k/=usizeof(char16_t);
	pc[k]=u'\0';

	{char16_t *ptr;
	for(ptr=pc;*ptr!=u'\0'; ptr++){
		ifunlike(*ptr==10) *ptr=u'\n';
		else ifunlike(*ptr==13){
			if(*(ptr+1)==10) break;
			*ptr=u'\n';
		}
	}
	if(*ptr!=u'\0'){ //The previous loop has broken at a 13,10 pair.
		char16_t *ptrb=ptr;
		while(*ptr!=u'\0'){
			char16_t c=*ptr++;
			ifunlike(c==10 || c==13){ //unlike, although in the first encounter it will be true
				*ptrb=u'\n';
				if(c==13 && *ptr==10) ptr++;
			}else *ptrb=c;
			ptrb++;
		}
		k=(pdif)(ptrb-pc);
	}}
	*(pc-1)=u'\n';
	if(*pc==0xFFFE || *pc==0xFEFF) *pc=u'\n';

	if(k==0 || pc[k-1]!=u'\n') pc[k++]=u'\n';	/*so that wcschr(buffer.pc,u'\n') and _wstr_stn(buffer.pc) never return NULL*/
	pc[k]=u'\0';
	buf->next=pc-1;
	return (int)k;
}
#endif

int tiopen_mem8(Bufferti8 *buf, const char8_t* contents, uint n){
	uint k;

	ifunlike(n>=ATFILEI_MAXSIZE) return ATFILEI_LARGEFILE;
	k=n;
	k+=5, k|=3, k++;		//k+6, redond. arriba
	buf->vbase=malloc(k);
	ifunlike(buf->vbase==NULL) return AT_NOMEM;
	buf->pc=(char8_t*)buf->vbase+4;
	buf->pc[-1]='\n';
	memcpy(buf->pc,contents,n);

	k=n;
	if(_unlikely(k==0) || buf->pc[k-1]!='\n') buf->pc[k++]='\n';
	buf->pc[k]='\0';
	buf->next=buf->pc-1;
	return (int)k;
}

int tiopen_mem16(Bufferti16 *buf, const char16_t* contents, uint n){
	uint k;

	ifunlike(n>=ATFILEI_MAXSIZE/usizeof(char16_t)) return ATFILEI_LARGEFILE;
	k=usizeof(char16_t)*n;
	k+=4 +usizeof(char16_t)+usizeof(char16_t);	//u'\n', u'\0'
	k+=3, k&=~3U;
	buf->vbase=malloc(k);
	ifunlike(buf->vbase==NULL) return AT_NOMEM;
	buf->pc=(char16_t*)((char8_t*)buf->vbase+4);
	buf->pc[-1]=u'\n';
	memcpy(buf->pc,contents,n);

	k=n;
	if(_unlikely(k==0) || buf->pc[k-1]!=u'\n') buf->pc[k++]=u'\n';
	buf->pc[k]=u'\0';
	buf->next=buf->pc-1;
	return (int)k;
}

#ifndef FUNCTION_open_bifile
int read_bifile(uint* *buf, FILE *f){
	uint k;

	k=AT_filelength(f);
	ifunlike(k>ATFILEI_MAXSIZE){ //Includes the <0 error codes
		if(ispos(k)) k=ATFILEI_LARGEFILE;
		fclose(f);
		return -(int)(-k);
	}
	k=(k+usizeof(uint)-1)/usizeof(uint);

	*buf=(uint*)malloc(k*usizeof(uint));
	ifunlike(*buf==NULL){fclose(f); return AT_NOMEM;}
	/*The input happens as if by calls to fgetc, which means that if atomic data units of greater size than char,
	such us is usually uint, are to be read, its first bytes in the file will be mapped to the first bytes in memory.
	If the file's endianess is different from the in-memory one, the bytes will have to be swapped accordingly.*/
	k=(uint)fread(*buf,usizeof(uint),k,f);
	fclose(f);
	return (int)k;
}
int biopen8(uint* *buf, const char8_t* fichero){
	FILE *f=fopen(fichero,"rb");
	ifunlike(f==NULL) return ATFILEI_UNKNOWN;
	return read_bifile(buf,f);
}
int biopen16(uint* *buf, const char16_t* fichero){
	FILE *f;
	char8_t* filename_c;
	uint k;

	k=stru8___str16(NULL,fichero);
	//ifunlike(k==Я) ATFILEO_OPEN_BADPATH;
	filename_c=(char8_t*)malloc(k);
	ifunlike(filename_c==NULL) return ATFILEI_NOMEM;
	stru8___str16(filename_c,fichero);

	f=fopen(filename_c,"rb");
	free(filename_c);
	ifunlike(f==NULL) return ATFILEI_UNKNOWN;
	return read_bifile(buf,f);
}
#endif

#undef FUNCTION_open_tfile8
#undef FUNCTION_open_tfile16
#undef FUNCTION_open_bfile

#else
#undef IGNORE_ALL
#endif

#if FILE8BITS_ARE_UTF8
int (biopen_utf8)(uint* *buf, const char8_t* fichero){
	return biopen8(buf,fichero);
}
#else
int biopen_utf8(uint* *buf, const char8_t* fichero){
	int nret;
	uint k;
	char16_t *fichero16;

	k=strlen8(fichero)+1;
	fichero16=(char16_t*)malloc(k*usizeof(char16_t));
	ifunlike(fichero16==NULL) return AT_NOMEM;
	str16___stru8(fichero16,fichero);
	nret=biopen16(buf,fichero16);
	free(fichero16);
	return nret;
}
#endif

#if FILE8BITS_ARE_UTF8
int (tiopen_utf8)(Bufferti8 *buf, const char8_t* fichero){
	return tiopen8(buf,fichero);
}
#else
int tiopen_utf8(Bufferti8 *buf, const char8_t* fichero){
	int nret;
	uint k;
	char16_t *fichero16;

	k=strlen8(fichero)+1;
	fichero16=(char16_t*)malloc(k*usizeof(char16_t));
	ifunlike(fichero16==NULL) return AT_NOMEM;
	str16___stru8(fichero16,fichero);
	nret=tiopen_mixed(buf,fichero16);
	free(fichero16);
	return nret;
}
#endif
