//#includeif mergestring(_wstring_,SYSTEM.c)
#ifndef IGNORE_ALL

#ifndef FUNCTION_bowrite_umints
//array should be uint-aligned
void bowrite_umints(Buffer_bo *buf, umint* array, uint n){
  if(sizeof(uint)==4){ //Compile time resolved
	umint *resto;
	u8int endian;

	endian=buf->endian;
	buf->endian=ATFILE_ENDIAN_UNSET; //Individual bytes must not be swaped
	bowrite_uints(buf,(uint*)(array),n>>2);
	resto=(array)+(n&~3U);
	switch(n&3U){
		case 0: break;
		case 1: boput_1688(buf,0,0,*resto); break;
		case 2: boput_1688(buf,0,*(resto+1),*resto); break;
		case 3: boput_8888(buf,0,*(resto+2),*(resto+1),*resto);
	}
	buf->endian=endian;
  }else{
	uint n4=n>>2;
	uint k;
	uint buf_size=(pdif)(buf->top-buf->ptr);

	if(n4<buf_size) k=n4; else k=buf_size;
	dontimes(k,array+=4){do_boput_8888(buf,array[3],array[2],array[1],array[0]);}
	n4-=k;

	if(n4){
		buf_size=(pdif)(buf->top-buf->base);
		while(n4>buf_size){
			n4-=buf_size;
			boflush(buf);
			dontimes(buf_size,array+=4){do_boput_8888(buf,array[3],array[2],array[1],array[0]);}
		}
		boflush(buf);
		while(n4--){do_boput_8888(buf,array[3],array[2],array[1],array[0]);}
	}

	if(n&3U){
		bo_checkflush(buf);
		switch(n&3U){
			case 1: do_boput_8888(buf,0,0,0,array[0]); break;
			case 2: do_boput_8888(buf,0,0,array[1],array[0]); break;
			case 3: do_boput_8888(buf,0,array[2],array[1],array[0]);
		}
	}
  }
}
#endif

#ifndef FUNCTION_bowrite_uints
void bowrite_uints(Buffer_bo *buf,uint* array,uint n){
	uint test;

	if(buf->endian==ATFILE_ENDIAN_UNSET) test=1;
	else if(buf->endian==ATBYTES_LITTLE_ENDIAN) test=littleend_u4___u4(1);
	else test=bigend_u4___u4(1);

	if(test==1){ //the file's endianness is the same as in-memory
		uint k;
		uint buf_size=(pdif)(buf->top-buf->ptr);

		if(n<buf_size) k=n; else k=buf_size;
		memcpy_uint(buf->ptr,array,k); buf->ptr+=k;
		ifz(n-=k) return;

		array+=k;
		buf_size=(pdif)(buf->top-buf->base);
		while(n>buf_size){
			n-=buf_size;
			bo_internalflush(buf);
			memcpy_uint(buf->base,array,buf_size);
			array+=buf_size;
		}
		bo_internalflush(buf);
		memcpy_uint(buf->base,array,n);
		buf->ptr=buf->base+n;
	}else{
		uint k;
		uint buf_size=(pdif)(buf->top-buf->ptr);

		if(n<buf_size) k=n; else k=buf_size;
		dontimes(k,array++){*buf->ptr++=endianswap_u4(*array);}
		ifz(n-=k) return;

		buf_size=(pdif)(buf->top-buf->base);
		while(n>buf_size){
			n-=buf_size;
			boflush(buf);
			dontimes(buf_size,array++){*buf->ptr++=endianswap_u4(*array);}
		}
		boflush(buf);
		while(n--){*buf->ptr++=endianswap_u4(*array); array++;}
	}
}
#endif

#ifndef TWO_COMP
#ifndef FUNCTION_bowrite_ssints
void bowrite_ssints(Buffer_bo *buf,ssint* array,uint n){
	uint k;
	uint buf_size=(pdif)(buf->top-buf->ptr);

	if(n<buf_size) k=n; else k=buf_size;
	dontimes(k,array++){do_boput_32(buf,(uint)*array);} //cast to uint forces 2's complement representation
	ifz(n-=k) return;

	buf_size=buf->top-buf->base;
	while(n>buf_size){
		n-=buf_size;
		boflush(buf);
		dontimes(buf_size,array++){do_boput_32(buf,(uint)*array);}
	}
	boflush(buf);
	while(n--){do_boput_32(buf,(uint)*array); array++;}
}
#endif
#endif

#ifndef FUNCTION_bowrite_strings
void bowrite_strings(Buffer_bo *buf,char8_t** cs,uint n){
	uint c4=0;
	uint i32=0;

	while(n--){
		char8_t* nom=*cs++;
		do{
			uint test;
			c4|=(*nom)<<i32;
			test=i32-24;
			i32+=8;
			if(!test){boput_32(buf,c4); c4=0, i32=0;}
		}while(*nom++);
	}
	boput_32(buf,c4);
	return;
}
#endif

#undef FUNCTION_bowrite_umints
#undef FUNCTION_bowrite_uints
#undef FUNCTION_bowrite_ssints
#undef FUNCTION_bowrite_strings

#else
#undef IGNORE_ALL
#endif
