#pragma once
#include "ATuint.h"

/******---------        I/O TYPES        ---------******/

/*Machine independent I/O is to be performed by placing the data in 4-byte chunks, which are assumed
by this library to always be accessible by a data type (to be more precise, an unsigned data type having
32 value bits), namely uint.*/

/* For packing characters */
typedef uint IO4char8, IO2char16;

/*Fixed size 1-uint, 1-uint and 2-uint size types used for storing IEEE half, float and double respectively
with sizes of 1-uint, 1-uint and 2-uint (respec.) and alignment requirements of only uint. Intended for
data to be written or consumed to/from IO, for interoperability. Therefore they are defined in terms of
uint, to enforce their use only to I/O. */
typedef uint IO_HALF2;
typedef uint IO_SINGLE;
typedef uint IO_DOUBLE[2];
