#pragma once

/*Visibility of identifiers:

A file scope identifier may have translation-unit visibility or program-wide visibility,
meaning that the same identifier refers to the same object in all translation units. The C
standard makes no mention at all of the "outside world", which is how libraries work.
The objects desingated by identifiers may be accessed from other programs, by means of
that same identifier or in some other way. This accessibility, or exposure, may be achieved
by providing the required information for other programs in the header of the library, in
in some other file, etc. And to the C code itself by standard declarations in a regular header
file, although direct runtime querying to the library to get an object/function pointer
may also be possible.
    The concept of "visible to other programs" is by no means implementation or system
dependent. It may be the way it is achieved, or some systems may not provide one or other
possibility, but the concept itself is clear.*/

#ifndef mergestring
	#define _makestring(s) #s
	#define _merge(a,b) a##b
	#define _mergestring(a,b) _makestring(a##b)
	#define merge(a,b) _merge(a,b)
	#define mergestring(a,b) _mergestring(a,b)
#endif

#ifndef COMPILER
#include "COMPILER_resolve.h"
#endif

#if COMPILER_ID!=0
#include mergestring(ATvisibility_,COMPILER.h)
#endif

#ifndef set_visibility
#define set_visibility(v) visibility_##v
#endif

//The identifier has translation unit scope. This corresponds to the standard internal linkage.
//This is provided mostly for completeness, since it cannot be anything other than static.
#ifndef visibility_trans
#define visibility_trans static
#endif

/*The folowing three have external linkage. The intended meaning is as follows:
set_visibility(module) is to mean that the object is not exposed to the environment and
    may even disapear, if for example it is a funtion which is never called or always inlined
    or an object for which the compiler determines that it is not worth to actually store
    memory.
set_visibility(module_ex) means that the object is not exposed, but may be accessed if
    the caller can get its address via a call to a function from the module which is exposed.
    Other means, such as retriving the address and parameters/memory layout from the
    library itself at runtime is not included here since this is understood as the object
    being exposed.
        If the compiler can determine that the object address is never taken and passed
    by some means to an external caller it can make the object unaccessable as if its
    declared visibility had been "module". So, in practice there will be little difference
    between the two.
set_visibility(exposed) means that the object is exposed to be accessed from outside the
    program.
*/
#ifndef visibility_module
#define visibility_module extern
#endif
#ifndef visibility_module_ex
#define visibility_module_ex extern
#endif
//For when the modifier is being placed in a class's function declaration
#ifndef visibility_exposed_class
	#ifdef visibility_exposed
	#define visibility_exposed_class visibility_exposed
	#else
	#define visibility_exposed_class
	#endif
#endif

#ifndef visibility_exposed
#define visibility_exposed extern
#endif

/*This is intended to tell the compiler that the object refered to by the idendifier lies
outside the program
*/
//For when the modifier is being placed in a class's function declaration
#ifndef visibility_imported_class
	#ifdef visibility_imported
	#define visibility_imported_class visibility_imported
	#else
	#define visibility_imported_class
	#endif
#endif

#ifndef visibility_imported
#define visibility_imported extern
#endif

//A certain visibility specification is often desired for many consecutive declarations.
#ifndef VISIBILITY_BLOCK
#define VISIBILITY_BLOCK(v) VISIBILITY_BLOCK_##v
#endif
#ifndef VISIBILITY_BLOCK_END
#define VISIBILITY_BLOCK_END
#endif
//
#ifndef VISIBILITY_BLOCK_trans
#define VISIBILITY_BLOCK_trans
#endif
#ifndef VISIBILITY_BLOCK_module
#define VISIBILITY_BLOCK_module
#endif
#ifndef VISIBILITY_BLOCK_module_ex
#define VISIBILITY_BLOCK_module_ex
#endif
#ifndef VISIBILITY_BLOCK_exposed
#define VISIBILITY_BLOCK_exposed
#endif
#ifndef VISIBILITY_BLOCK_imported
#define VISIBILITY_BLOCK_imported
#endif
