/*
The ATcrt library and, at some points, the ATsystem.h file itself (or the ones included from it), assume some
specific behaviour at points where the C standard leaves the choice to the implementation. These are:
-- There is a 32-bit width integer type, henceforth called uint.
-- If two struct types begin with the same elements the memory layout of those elements in objects of either
type are identical.
-- Structures have or can be made to have uint or greater alignment. This is so that the uint variants of the
memcpy and memset functions, as well as uintsizeof(), can be safely used with structures. (Assumed in ATarrays).
-- Pointers may be added or substracted with integers and the result be one element less than the beginning
of the memory block. That is, code like while(s--!=buffer){...}  is valid.
-- Of the constants ' ', '\t and '\n', ' ' is the greatest.

The input and output to files as programmed in ATfileinput and ATfileoutput in machines where the byte
order is not little endian has not been tested for want of systems in where to test it, though the input
and output of binary files in encoded in both big and little endian has.
    And it has not even been programmed for systems where char is greater than 8 bits, even though this
library is intended to allow it.
*/

/*		The definition of COMPILER and SYSTEM.

There is code which is either compiler, operating system or chip processor specific. The branching
(inclusion of one or other .h or .c file according to the OS, etc. present at compile time) within
the code files may be done by chip processor, operating system or compiler. It seems best not to
branch by processor since processor specific code is itself compiler specific.
	Within the library ATcrt branching is done by compiler or by system depending on what I consi-
dered best. If branching by compiler, the different _COMPILER.h/c files may share some OS-dependent
solutions. This can be done by including the appropriate _SYSTEM.h/c files, written for the purpose.
It should be kept in mind that duplicating small bits of code in different _COMPILER files is harmless
while adding _SYSTEM files side by side with the former may add confusion, specially for newcomers.
The reverse should not be done. That is, a _SYSTEM file should be the end of branching.

	Neither an actual COMPILER, (viz. different from the "C" default one) nor a SYSTEM are required.
A warning will be issued if a SYSTEM / COMPILER dependent file is not included when it is considered
it should be. Default code is provided when possible. If the type, function or definition is intrinsically
system dependent (e.g., what characters are valid within a file name) an example is provided enclosed
between #if COMPILER_ID==0 and #endif.

In order that the default definitions for functions or macros can be used or overriden at the will of the
compiler specific file (which is included before the appearance of those default definitions), the default
macro defititions are enclosed in #ifndef #endif and the default function definitions as exemplified here
with the function foo:

#ifndef FUNCTION_foo
int foo(int* a,int b){
...
}
#endif

So if you write a diffenrent body for the function in your _COMPILER/_SYSTEM file you must define
FUNCTION_foo. This library's files will undefine those macros at the end. If you want the whole of
a default file to be omitted you have to define IGNORE_ALL in the _COMPILER/_SYSTEM file.
*/

#include "COMPILER_resolve.h"

#if COMPILER_ID!=0
#include mergestring(system_,COMPILER.h)
#endif

#include "sys_inttypes.h"
#include "sys_floattypes.h"
#include "sys_endianness.h"
#include "sys_IOtypes.h"
/*In code using this header only int, char, float and double would ideally appear as such in the code, as well
as 64-bit or wider integers and long long double, for which this header makes no provision, all the other
types being either defines or typedefs. Furthermore, the use of int is intended only for the returned values
of functions (error codes) and for functions taking a variable number of arguments (integer arguments
being promoted to int).*/

#if !defined(ATCRT_TYPES_ONLY) && !defined(ATCRT_SYSTEMH_INCLUDED)

#define ATCRT_SYSTEMH_INCLUDED

/* Pragmas */

//After decades with an #error directive the commettee does not yet consider useful a #warning directive
#ifndef Diagnostic_Message
#define Diagnostic_Message(msg)
#endif

#endif

/******---------        NOTE        ---------******/

/*The C language does not include the possibility for testing whether a particular type
exists or not (i.e., has been defined as a typedef, struct, union or enum). Over the years,
programmers have been defining macros of the kind MY_TYPE_DEFINED to test for
it, which is a burden for it requieres the knowlege of the macro name to test for each
type. (The macro may be file-wide, section-wide or type-specific). This possibility
would simplify the writing of the system_<COMPILER>.h files. There would be no
requierement placed on the programmer as to the definition of certain types or the
corresponding macros that test for the existence of the definition. For example, the
requirement to define the types u8int... or the macro NO_AUTO_FAST would disappear:

#ifndef u8int
_If(_Ident_type(u8int)==_IDENTIFIER_TYPEDEF)
_Else typedef uint u8int;
#endif

The same applies to the definition of functions (there are many in ATmemstr):

#ifndef memcpy_uint
_If(_Ident_type(memcmp_uint)==_IDENTIFIER_FUNCTION)
_Else{
...
}
#endif

_If and _Else themselves would not be necessary if it be stablished that constant con-
ditional expressions be treated as e.g. _Generic, ignoring the unchosen branches (prov-
ided there are not jumps into it from elsewere in the function).
*/
