#pragma once
#include "AT_strutils.h"

/*Las macros con alguna mayúscula en su nombre, por ejemplo if_Moreinl_pc frente a if_moreinl_pc tienen
en cuenta que existe un caracter, COMMENT_CHAR, que introduce un comentario que dura hasta
el final de línea. Se pueden usar estas macros aunque no haya comentarios sin más que definir
COMMENT_CHAR como '\n'. If this is so these macros behave as if there were no comment char.
Las macros sin mayúscula podrían por tanto omitirse por completo. Se pueden emplear si sabemos
que no existe carácter de comentario para optimizar la lectura del fichero o para que se manifestar
que no existe un COMMENT_CHAR. */

#ifndef COMMENT_CHAR
#define COMMENT_CHAR '\n'
#endif

/******---------        Macros that do not get the name of a function to be called        ---------******/

//Avanzar hasta la palabra siguiente y/0 el final de línea, o quedarse (stay)
#define advance_pc(pc) str_no_stn(pc)
#define advanceinline_pc(pc) str_no_st(pc)
#define stay_pc(pc)

#define finishline_pc(pc) if(*(pc)!='\0'){while(*(pc)!='\n') (pc)++; (pc)++;}	/*while(*(pc)++); may be better for other processors*/
#define finishline_stay_pc(pc) finishline_pc(pc)
#define finishline_advance_pc(pc) finishline_pc(pc); advance_pc(pc)
#define finishline_advanceinline_pc(pc) finishline_pc(pc); advanceinline_pc(pc)

#define if_moreinl_pc(pc) if(*(pc)!='\n')
#define if_nomore_pc(pc) if(*(pc)=='\n')
#define iflike_moreinl_pc(pc) iflike(*(pc)!='\n')
#define ifunlike_nomore_pc(pc) ifunlike(*(pc)=='\n')

//Lo mismo, para cuando existe un COMMENT_CHAR
#define Advance_pc(pc) advance_pc(pc); while(*(buffer).pc==COMMENT_CHAR){finishline_advance_pc(pc);}
#define Advanceinline_pc advanceinline_pc
#define finishline_Advance_pc(pc) finishline_pc(pc); Advance_pc(pc)

#define MORE_INL_pc(pc) (*(pc)!='\n' && *(pc)!=COMMENT_CHAR)
#define NOMORE_INL_pc(pc) (*(pc)=='\n' || *(pc)==COMMENT_CHAR)
#define if_Moreinl_pc(pc) if(MORE_INL_pc(pc))
#define if_Nomore_pc(pc) if(NOMORE_INL_pc(pc))
#define iflike_Moreinl_pc(pc) iflike(MORE_INL_pc(pc))
#define ifunlike_Nomore_pc(pc) ifunlike(NOMORE_INL_pc(pc))

//Pass over a word y avanzar tras ella. Sin comment-char
#define ignore_pc(pc) if(*(pc)!='\0'){str_stn(pc);}
#define ignore_stay_pc(pc) ignore_pc(pc)
#define ignore_advance_pc(pc) if(*(pc)!='\0'){str_stn(pc); advance_pc(pc);}
#define ignore_advanceinline_pc(pc) if(*(pc)!='\0'){str_stn(pc); advanceinline_pc(pc);}

//Si el carácter de comentario en medio de la palabra se considera parte de la palabra
#define ignore_Stay_pc(pc) ignore_pc(pc)
#define ignore_Advance_pc(pc) ignore_pc(pc); Advance_pc(pc)
#define ignore_Advanceinline_pc(pc) ignore_pc(pc); Advanceinline_pc(pc)

//El caracter de comentario termina la palabra
#define Ignore_pc(pc) if(*(pc)!='\0'){str_stnC(pc);}
#define Ignore_Stay_pc(pc) Ignore(pc)
#define Ignore_Advance_pc(pc) if(*(pc)!='\0'){str_stnC(pc); Advance_pc(pc);}
#define Ignore_Advanceinline_pc(pc) if(*(pc)!='\0'){str_stnC(pc); Advanceinline_pc(pc);}


/******---------        Macros that call a function to process an input word        ---------******/

/* The functions 'func' passed to this macros should have this prototype:

	<type> func(const <Type_pc> *, const <Type_pc> **)

where <Type_pc> is the type of the pointer pc, e.g., char8_t, since they will be called like this:

									x=func(pc,&(pc));

You may also omit the const qualifiers, but remember that the macros that "_advance" after the
call to the function suppose that there is some non ' ','\t','\n' - character at some position from
the value stored in pc (via the second argument passed to the function) onward and the ones that
"_Advance"... look at the definition of Advance_pc.*/

/*Ugly macro, to workaround a deficency of the C language. See system_C.h*/
#define ATparse_POOR_C_MACRO_LANGUAGE 6532984 //The typical expansion for econst is const (but the C standard guarantees
#define ATparse_POOR_C_MACRO_LANGUAGEconst 0   //that an undefined identifier will not cause an error: it is replaced by 0).
#define aux_merge_econst2(x) ATparse_POOR_C_MACRO_LANGUAGE ## x
#define aux_merge_econst(x) aux_merge_econst2(x)
#define aux_stringized_econst aux_merge_econst(econst)
//let's hope econst, if not empty, is defined to a single token
#if !defined(econst) || (aux_stringized_econst==6532984) //aux_...[1]=='\0' does not work
	#define cast_pc_addr(pc) &(pc)
#else
	#ifndef GENERIC_NOT_IMPLEMENTED
	#define cast_pc_addr(pc) _Generic(*(pc), char16_t: (econst char16_t**)&(pc), char8_t: (econst char8_t**)&(pc))
	#else
	//#define cast_pc_addr(pc) sizeof(*(pc))==sizeof(char16_t)? (econst char16_t**)&(pc) : (econst char8_t**)&(pc)
	#define cast_pc_addr(pc) &(pc)
	#endif
#endif
/*End of that*/

/* Macros that parse the word(s) and proceed */

//In case of syntantic failure while parsing, i.e., if after the call !is_stn(*pc), the action advance_pc
//or advanceinline_pc will do nothing. Similarly for Advance_pc and Advanceinline_pc, with a
//COMMENT_CHAR acting as another '\n'-char.

#define getfast_pc(pc,x,func) x=func(cast_pc_addr(pc))
#define getfast_advance_pc(pc,x,func) getfast_pc(pc,x,func); advance_pc(pc)
#define getfast_advanceinline_pc(pc,x,func) getfast_pc(pc,x,func); advanceinline_pc(pc)
#define getfast_Advance_pc(pc,x,func) getfast_pc(buffer,x,func); Advance_pc(pc)
#define getfast_Advanceinline_pc(pc,x,func) getfast_pc(buffer,x,func); Advanceinline_pc(pc)

//Aliases of the latter
#define nocheck_get_stay_pc(pc, x, func) getfast_pc(pc,x,func)
#define nocheck_get_advance_pc(pc, x, func) getfast_advance_pc(pc,x,func)
#define nocheck_get_advanceinline_pc(pc, x, func) getfast_advanceinline_pc(pc,x,func)
#define nocheck_get_Advance_pc(pc, x, func) getfast_Advance_pc(pc,x,func)
#define nocheck_get_Advanceinline_pc(pc, x, func) getfast_Advanceinline_pc(pc,x,func)

/* internal */
#define parse_succeeded(pc) is_stn(*(pc))
#define Parse_succeeded(pc) is_stnC(*(pc))
#define _nocheck_get_pc(action,pc,x,func) x=func(cast_pc_addr(pc)); action(pc);

/* Macros that check for succees / failure after the function call */
#define ifnot_get_stay_pc(pc, x, func)					x=func(cast_pc_addr(pc)); if(!parse_succeeded(pc))
#define ifnot_get_advance_pc(pc, x, func)			_nocheck_get_pc(advance_pc,pc,x,func) if(!parse_succeeded(pc))
#define ifnot_get_advanceinline_pc(pc, x, func)	_nocheck_get_pc(advanceinline_pc,pc,x,func) if(!parse_succeeded(pc))
#define ifnot_get_Stay_pc(pc, x, func)				x=func(cast_pc_addr(pc)); if(!Parse_succeeded(pc))
#define ifnot_get_Advance_pc(pc, x, func)			_nocheck_get_pc(Advance_pc,pc,x,func) if(!Parse_succeeded(pc))
#define ifnot_get_Advanceinline_pc(pc, x, func)	_nocheck_get_pc(Advanceinline_pc,pc,x,func) if(!Parse_succeeded(pc))

#define if_get_stay_pc(pc, x, func)					x=func(cast_pc_addr(pc)); if(parse_succeeded(pc))
#define if_get_advance_pc(pc, x, func)			_nocheck_get_pc(advance_pc,pc,x,func) if(parse_succeeded(pc))
#define if_get_advanceinline_pc(pc, x, func)	_nocheck_get_pc(advanceinline_pc,pc,x,func) if(parse_succeeded(pc))
#define if_get_Stay_pc(pc, x, func)					x=func(cast_pc_addr(pc)); if(Parse_succeeded(pc))
#define if_get_Advance_pc(pc, x, func)			_nocheck_get_pc(Advance_pc,pc,x,func) if(Parse_succeeded(pc))
#define if_get_Advanceinline_pc(pc, x, func)	_nocheck_get_pc(Advanceinline_pc,pc,x,func) if(Parse_succeeded(pc))
