#ifndef ATMEM_INCLUDED
#define ATMEM_INCLUDED

#if 0

//A plist is typically used thus

int func(int a){
	PLIST pl=get_new_plist();
	if(pl==PLIST_OUT_OF_MEM){ /* handle error */ }

	//x and y are pointers to allocated memory.
	addto_delete(pl,x);
	addto_delete_ind(pl,&y);
	//...

	free_plist(pl);
}

/* Pointers may be added to a plist either 'immediate' or 'indirect'. The former adds the
pointer to be deleted. The latter adds it address, so that the pointer itself may be
re-allocated; when the the plist is freed, free(*p) will be executed, instead of free(p).
In the previous example 'x' was added immediate while 'y' was added indirect.
    The debug variants add in addition the pointer's name, i. e., the preprocessing-time
name of the argument passed to the function. This is useful for debugging overrun
errors which are only manifiest when the plist's pointers are freed.
*/

/* A list cannot have the same pointer added more than once. The programmer is trusted
to add each pointer only once. If they are always added when memory is allocated for them
this is very easy to accomplish. In case the programmer cannot be sure that the pointer has
not been added previously he should call the _checked variants, that check for it. */

#endif


typedef unsigned int PLIST;
#define PLIST_NULL ((PLIST)-1)
#define PLIST_OUT_OF_MEM ((PLIST)-2)

#ifdef __cplusplus
extern "C"{
#endif

/* Gets a free plist. If the function cannot return a plist because of lack of memory it will
return PLIST_OUT_OF_MEM */
PLIST get_new_plist(void);
/* If k is not an active plist it does nothing. In particular, if k is PLIST_NULL.
For each pointer 'p' in the plist which is an immedate it will free(p). For each pointer 'p'
which is an indirect it will first check that p!=NULL, then it will free(*p). Finally, it
releases the plist itself, which cannot subsequently be used. */
void free_plist(PLIST k);
/* Releases the plist without freeing its pointers. The plist disappears; you must thence
take care of freeing the pointers it stored by yourself. */
void release_plist(PLIST k);
/* The pointers in the plist which are indirects are converted to immediate. I. e.: for each
'p' which is an indirect the function replaces 'p' by '*p' in the plist. */
void plist_to_immediate(PLIST k);

#ifdef _DEBUG
	void addto_delete(PLIST k,void* p, const char* var_name);
	void addto_delete_ind(PLIST k,void** p, const char* var_name);
	void addto_delete_checked(PLIST k, void* p, const char* var_name);
	void addto_delete_checked_ind(PLIST k, void** p, const char* var_name);
	#define addto_delete(k,p) addto_delete(k,p,#p)
	#define addto_delete_ind(k,p) addto_delete_ind(k,p,#p)
	#define addto_delete_checked(k,p) addto_delete_checked(k,p,#p)
	#define addto_delete_checked_ind(k,p) addto_delete_checked_ind(k,p,#p)
#else
/* Adds the pointer 'p' to the plist 'k', provided 'p' is !=NULL. Upon a call to free_plist(k)
the program will free(p). */
void addto_delete(PLIST k,void* p);
/* Adds the pointer 'p' to the plist 'k', provided 'p' is !=NULL. 'p' is the address of the pointer
which will eventually need to be freed, so that upon a call to free_plist(k) the program will
free *p. */
void addto_delete_ind(PLIST k,void** p);
/* Adds the pointer 'p' to the plist 'k', provided 'p' is !=NULL, 'p' is not already in the plist
and for any 'q' in the plist which is an indirect *q is not 'p'. Upon a call to free_plist(k)
the program will free(p). */
void addto_delete_checked(PLIST k,void* p);
/* Adds the pointer 'p' to the plist 'k', provided 'p' is !=NULL, 'p' is not already in the plist
and for any 'q' in the plist which is an immediate *p is not 'q'. The pointer 'p' is the address
of the pointer which will eventually need to be freed. I. e., upon a call to free_plist(k), the
program will free *p. */
void addto_delete_checked_ind(PLIST k,void** p); //is not already in the plist
#endif

/* Removes from the plist the pointer 'p' or '*p' (provided the latter is not NULL),
whichever is found first. When it finds a match the function removes it and return. */
void remove_from_delete(PLIST k,void** p);
/* Removes from the plist all pointers added to it from 'p' onwards. The function starts
removing the plist's pointers from the last one added backwards, and stops when it
finds one which equals either 'p' or '*p' (provided the latter is not NULL), which is
itself removed. If such a pointer is not found it will remove all pointers from the plist.
'p' must not be NULL.
The function free_down_to in addition frees the pointers before removing them. */
void free_down_to(PLIST k,void** p);
void remove_down_to(PLIST k,void** p);

#ifdef __cplusplus
}
#endif

#endif
