#pragma once

/*Utilites for function prototypes, calling and others.*/

#include "COMPILER_resolve.h"
#if COMPILER_ID!=0
#include mergestring(ATfunctions_,COMPILER.h)
#endif

/*A variable declared as const within the scope of a function is ususally intended to mean that
the object is not modified within the function, but we ususally do not care whether it be or
not modifiable without the function. However, the C language does not allow that:
"If an attempt is made to modify an object defined with a const-qualified type through use
of an lvalue with non-const-qualified type, the behavior is undefined" and compilers issue
warnings or errors accordingly. Two situations arise typically:

void seek_eol(const char **pc){while(**pc!='\n') (*pc)++;}
char* s; [...] seek_eol(&s);

char* seek_eol(const char *pc){while(*pc!='\n') pc++; return pc;}

In the first case the address of s is passed to a function which could store there a pointer
to a const object, which could subsequently be modified by s from outside the function.
In the second, pc is returned as (non-const) char*, but it may be pointing to a const object.
    Actually, these are not errors by themselves since so far no atempt has been made "to modify
an object defined with a const-qualified type [...]". The standard should provide an internal const
qualifier, or some other solution. E.g.:

void seek_eol(internal const char **pc){while(**pc!='\n') (*pc)++;}
char* seek_eol(internal const char *pc){while(*pc!='\n') pc++; return pc;}

    Dropping the const from the function prototype is not a solution since i) The information
that the function does not modify the object is lost, ii) The function code is not protected
against unintended accidental modification of the object via the pointer by the programmer,
and iii) The pointer passed to the function may be to a const object, thereby the problem is just
transferred to a different point of the code, and worsened.
    For these reasons this library provides the faked qualifiers ΙCONST, iconst and econst, which,
while do not solve the problem, help to signal out and track the casts written to fix these situations.
    Virtually all appearances of const at function declarations are internal const, however only
those for which one of the above two situations arise need to be thus declared.
*/
#ifndef ICONST
#define ICONST //For casting function's iconst pointers at a function's return
#endif
#ifndef iconst
#define iconst const //For the declaration of pointers at function prototypes and bodies
#endif
#ifndef econst
#define econst const //To cast to-non-const double pointers when passed to functions recieving
#endif					//double pointers to const-qulified objects
/*
These would be used as follows:

void seek_eol(iconst char **pc){while(**pc!='\n') (*pc)++;}
char* s; [...] seek_eol((econst char**)&s);

char* seek_eol(iconst char *pc){while(*pc!='\n') pc++; return (ICONST char*)pc;}
*/

//For parameters in a function parameter list not used in the body of the function
#ifndef _unused
	#if __STDC_VERSION__>=202200L
		#if __has_c_attribute(maybe_unused)==201904L
		#define _unused(x) [[maybe_unused]] x
		#else
		#define _unused(x) x
		#endif
	#else
	#define _unused(x) x
	#endif
#endif

//_Generic is an awfull workaround for want of a proper typeof operator in combination with compile-time
//querying to the translator: _If(typeof(T)==typeof(char8_t)), for example.
//Define if C11 _Generic is not implemented
//#define GENERIC_NOT_IMPLEMENTED

/*Storage class for large objects within functions.
It may be preferible that these variables are static instead of auto, in order
not to overflow the stack or just to avoid stack checking code.*/
#ifndef LARGE_STACK
#define LARGE_STACK
#endif
