#pragma once
#include <math.h>
/**  Floating-point number utils  **/
#include "COMPILER_resolve.h"
#if COMPILER_ID!=0
//#include mergestring(ATfputils_,COMPILER.h)
#endif

//Assigning a !finite() value to a variable
#ifdef NAN
	#define NOTFINITE_F NAN
	#define NOTFINITE_D (double)NAN
	#define NOTFINITE_f(x) x=NAN //NAN is float according to the standard
	#define NOTFINITE_d(x) x=(double)NAN
#else
	#define NOTFINITE_F INFINITY
	#define NOTFINITE_D (double)INFINITY
	#define NOTFINITE_f(x) x=INFINITY //INFINITY is float according to the standard
	#define NOTFINITE_d(x) x=(double)INFINITY
#endif

/*Comparación del signo floating point values. Tiene que evaluarse a 0 si lo signos son iguales
y a !=0 si son distintos. */
#ifndef cmpsign
#define cmpsign(a,b) ((_Bool)signbit(a)!=(_Bool)signbit(b))
#endif

//A macro for signalling a bad value.
#define ATCRT_BAD_FVALUE 1.0E+37F

//Note on NOTFINITE_f/d and ATCRT_BAD_FVALUE

/*The test !isfinite(x) is usually performed to check some special condition, such as empty value
or the end of an array. But neither NaN nor INFINITY are guaranteed to exist, niether does
one imply the existence of the other. For this purpose the macros NOTFINITE_f/d are provided.
    If neither NaNs nor infitities are available the macro NOTFINITE_f will generate a translation
time float overflow, as the standard requieres for INFINITY when it is not supported.
    If ever it were necessary to distinguish between empty and bad values, the value
ATCRT_BAD_FVALUE is provided. A distinction between infinity and NaN, that could serve
this purpose, is not exploited because either of them (or both) may not be available and because
the setting of the value may take place in a different environment than the testing and such a
distinction would be prone to errors, if only to remember at each end which of NaN or infinity
represents the empty value and which one the wrong value. This way NaN or infinity indifferently
represent empty value or some other special circumstance  and ATCRT_BAD_FVALUE a bad value.
A programmer using a language other than C can thus easily generate NaN-or-Infinity and
Bad-values, the latter just by assigning the value 1e+37*/
