#pragma once
#include "ATsystem.h"
#include <uchar.h>
/* String related utilities */

#ifndef COMMENT_CHAR
#define COMMENT_CHAR '\n'
#endif

#define whilenz(a) while((a)!=0)

#define is_st(c) (c==' ' || c=='\t')
#define is_stn(c) (c<=' ' && (c==' ' || c=='\t' || c=='\n'))
#define isnot_st(c) (c!=' '&& c!='\t')
#define isnot_stn(c) (c>' ' || (c!=' '&& c!='\t' && c!='\n'))
#define is_stn0(c) (c<=' ' && (c=='\0' || c==' ' || c=='\t' || c=='\n'))
#define isnot_stn0(c) (c>' ' || (c!=' ' && c!='\t' && c!='\n' && c!='\0'))
#define is_stnC(c) (c==' ' || c=='\t' || c=='\n' || c==COMMENT_CHAR)
#define is_nC(c) (c=='\n' || c==COMMENT_CHAR)
#define isnot_stnC(c) (c!=COMMENT_CHAR && isnot_stn(c))
#define isnot_nC(c) (c!='\n' && c!=COMMENT_CHAR)

//Advance s1 till the condition is satisfied
#define str_no_st(s1)		while(is_st(*(s1))) (s1)++
#define str_no_stn(s1)	while(is_stn(*(s1))) (s1)++
#define str_st(s1)			while(isnot_st(*(s1))) (s1)++
#define str_stn(s1)			while(isnot_stn(*(s1))) (s1)++
#define str_stnC(s1)		while(isnot_stnC(*(s1))) (s1)++
#define str_nC(s1)			while(isnot_nC(*(s1))) (s1)++

/*
strcpy8			strcpy16
strncpy8			strncpy16    If the string to copy has more than n characters the copied string will not be '\0'-terminated
strn0cpy8		strn0cpy16    The copied string is allways '\0'-terminated
strpcpy8			strpcpy16    Returns the pointer at the end of the copyed string
strlen8			strlen16
strcmp8			strcmp16
strbeginsby8	strbeginsby16    Devuelve 0 en caso de comparaci'on id'entica, para que sea lo mismo que strcmp
strseek8			strseek16

Those with the name as above are null-terminated. Others may accept one argument which may be terminated
by any character from a choice. The different possibilities, exemplified with strcpy8, are

strcpy8		'\0'
strcpy8_0	'\0'
strcpy8_s		' '
strcpy8_st	' ', '\t'
strcpy8_n	'\n'
strcpy8_b	' ', '\t', '\n'
strcpy8_b0	' ', '\t', '\n', '\0'
strcpy8_bC		' ', '\t', '\n', COMMENT_CHAR
strcpy8_nC		'\n', COMMENT_CHAR
//strcpy8_bC0		' ', '\t', '\n', COMMENT_CHAR, '\0'

For functions/macros that take two arguments, the argument to which this applies is the first in strcmp and the second
in the other functions/macros. For strcpy, the first argument is always null-closed. E.g.,
	strcmp8_b(p,"tree"); //Seeks whtether p points to a string beginning by "tree ", "tree\t" or "tree\n".
	strcpy_n(p,s); //Copies s into p, where s is ended by a new-line char. In p the '\n' char is not copied;
					   //instead, a '\0' is placed at the end (where the '\n' would be).
	strbeginsby8(p,"tree"); //It is irrelevant how the string 'p' is ended, for it is only checked whether its
								  //first four characters are 't', r', 'e' and 'e'.
	strbeginsby8_b0(p,s);   //Again, it s irrelevant how 'p' is terminated. s will be terminated by the first
								  //instance of either ' ', '\t', '\n' or '\0'.

COMMENT_CHAR must be a macro that expands to a character, which is typically a comment char beyond which the
line should not be read. If defined to '\n' the functions behave as if it didn't exist.
The definition at force here is irrelevant. The one which matters is that which is present at the time the macro (e.g., strcpy8_nC)
is called. This file only defines function-like macros using COMMENT_CHAR, not any actual function.

A typeof keyword would greatly simplify the definition and use of these macros.
*/

//s1 is left null-terminated. pc is advanced.
#define copyp_0(s1,pc) do{char8_t* _x=s1;	whilenz(*_x++=*(pc)++); (pc)--;}while(0)
#define copyp_s(s1,pc) do{char8_t* _x=s1;	while(*(pc)!=' ') *_x++=*(pc)++; *_x='\0';}while(0)
#define copyp_st(s1,pc) do{char8_t* _x=s1;	while(isnot_st(*(pc))) *_x++=*(pc)++; *_x='\0';}while(0)
#define copyp_n(s1,pc) do{char8_t* _x=s1;	while(*(pc)!='\n') *_x++=*(pc)++; *_x='\0';}while(0)
#define copyp_b(s1,pc) do{char8_t* _x=s1;	while(isnot_stn(*(pc))) *_x++=*(pc)++; *_x='\0';}while(0)
#define copyp_b0(s1,pc) do{char8_t* _x=s1;	while(isnot_stn0(*(pc))) *_x++=*(pc)++; *_x='\0';}while(0)
#define copyp_bC(s1,pc) do{char8_t* _x=s1;	while(isnot_stnC(*(pc))) *_x++=*(pc)++; *_x='\0';}while(0)
#define copyp_nC(s1,pc) do{char8_t* _x=s1;	while(isnot_nC(*(pc))) *_x++=*(pc)++; *_x='\0';}while(0)


#ifndef strcpy8
#define strcpy8(x,y) do{char8_t* _x=x; const char8_t *_y=y;						do *_x++=*_y; while(*_y++);}while(0)
#define strcpy8_0 strcpy8
#define strcpy8_s(x,y) do{char8_t* _x=x; const char8_t *_y=y;					while(*_y!=' ') *_x++=*_y++; *_x='\0';}while(0)
#define strcpy8_st(x,y) do{char8_t* _x=x; const char8_t *_y=y;					while(isnot_st(*_y)) *_x++=*_y++; *_x='\0';}while(0)
#define strcpy8_n(x,y) do{char8_t* _x=x; const char8_t *_y=y;					while(*_y!='\n') *_x++=*_y++; *_x='\0';}while(0)
#define strcpy8_b(x,y) do{char8_t* _x=x; const char8_t *_y=y; char8_t _c;		while(_c=*_y++, isnot_stn(_c)) *_x++=_c; *_x='\0';}while(0)
#define strcpy8_b0(x,y) do{char8_t* _x=x; const char8_t *_y=y; char8_t _c;	while(_c=*_y++, isnot_stn0(_c)) *_x++=_c; *_x='\0';}while(0)
#endif
#ifndef strncpy8
#define strncpy8(x,y,n) iflike(n){cint _i=n; char8_t *_x=x; const char8_t *_y=y-1;		do --_i, *_x++=*++_y; while(_i && *_y);}
#define strncpy8_0 strncpy8
#define strncpy8_s(x,y,n) iflike(n){cint _i=n; char8_t *_x=x; const char8_t *_y=y;		while(_i && *_y!=' ') --_i, *_x++=*_y++; if(_i) *_x='\0';}
#define strncpy8_st(x,y,n) iflike(n){cint _i=n; char8_t *_x=x; const char8_t *_y=y;		while(_i && isnot_st(*_y)) --_i, *_x++=*_y++; if(_i) *_x='\0';}
#define strncpy8_n(x,y,n) iflike(n){cint _i=n; char8_t *_x=x; const char8_t *_y=y;		while(_i && *_y!='\n') --_i, *_x++=*_y++; if(_i) *_x='\0';}
#define strncpy8_b(x,y,n) iflike(n){cint _i=n; char8_t *_x=x; const char8_t *_y=y; char8_t _c;	while(_i && (_c=*_y++, isnot_stn(_c))) --_i, *_x++=_c; if(_i) *_x='\0';}
#define strncpy8_b0(x,y,n) iflike(n){cint _i=n; char8_t *_x=x; const char8_t *_y=y; char8_t _c;	while(_i && (_c=*_y++, isnot_stn0(_c))) --_i, *_x++=_c; if(_i) *_x='\0';}
#endif
#ifndef strn0cpy8
#define strn0cpy8(x,y,n) iflike(n){cint _i=n-1; char8_t *_x=x; const char8_t *_y=y;			while(_i && *_y) --_i, *_x++=*_y++; *_x='\0';}
#define strn0cpy8_0 strn0cpy8
#define strn0cpy8_s(x,y,n) iflike(n){cint _i=n-1; char8_t *_x=x; const char8_t *_y=y;		while(_i && *_y!=' ') --_i, *_x++=*_y++; *_x='\0';}
#define strn0cpy8_st(x,y,n) iflike(n){cint _i=n-1; char8_t *_x=x; const char8_t *_y=y;		while(_i && isnot_st(*_y)) --_i, *_x++=*_y++; *_x='\0';}
#define strn0cpy8_n(x,y,n) iflike(n){cint _i=n-1; char8_t *_x=x; const char8_t *_y=y;		while(_i && *_y!='\n') --_i, *_x++=*_y++; *_x='\0';}
#define strn0cpy8_b(x,y,n) iflike(n){cint _i=n-1; char8_t *_x=x; const char8_t *_y=y; char8_t _c;	while(_i && (_c=*_y++, isnot_stn(_c))) --_i, *_x++=_c; *_x='\0';}
#define strn0cpy8_b0(x,y,n) iflike(n){cint _i=n-1; char8_t *_x=x; const char8_t *_y=y; char8_t _c;	while(_i && (_c=*_y++, isnot_stn0(_c))) --_i, *_x++=_c; *_x='\0';}
#endif

static inline pdif strlen8(const char8_t* s){const char8_t* c=s; while(*c) c++; return (pdif)(c-s);}
#define strlen8_0 strlen8
static inline pdif strlen8_s(const char8_t* s){const char8_t* c=s; while(*c!=' ') c++; return (pdif)(c-s);}
static inline pdif strlen8_st(const char8_t* s){const char8_t* c=s; while(isnot_st(*c)) c++; return (pdif)(c-s);}
static inline pdif strlen8_n(const char8_t* s){const char8_t* c=s; while(*c!='\n') c++; return (pdif)(c-s);}
static inline pdif strlen8_b(const char8_t* s){const char8_t* c=s; while(isnot_stn(*c)) c++; return (pdif)(c-s);}
static inline pdif strlen8_b0(const char8_t* s){const char8_t* c=s; while(isnot_stn0(*c)) c++; return (pdif)(c-s);}

static inline char8_t* strseek8(const char8_t* s, char8_t c){while(*s && *s!=c) s++; return (char8_t*)s;}
#define strseek8_0 strseek8
static inline char8_t* strseek8_s(const char8_t* s, char8_t c){while(*s!=' ' && *s!=c) s++; return (char8_t*)s;}
static inline char8_t* strseek8_st(const char8_t* s, char8_t c){while(isnot_st(*s) && *s!=c) s++; return (char8_t*)s;}
static inline char8_t* strseek8_n(const char8_t* s, char8_t c){while(*s!='\n' && *s!=c) s++; return (char8_t*)s;}
static inline char8_t* strseek8_b(const char8_t* s, char8_t c){while(isnot_stn(*s) && *s!=c) s++; return (char8_t*)s;}
static inline char8_t* strseek8_b0(const char8_t* s, char8_t c){while(isnot_stn0(*s) && *s!=c) s++; return (char8_t*)s;}

static inline int strcmp8(const char8_t* s1, const char8_t* s2){while(*s1 && *s1==*s2) s1++,s2++; return *s1-*s2;}
#define strcmp8_0 strcmp8
static inline int strcmp8_s(const char8_t* sb1, const char8_t* s2){while(*sb1 && *sb1==*s2) sb1++,s2++; return (*sb1-' ')-*s2;}
static inline int strcmp8_st(const char8_t* sb1, const char8_t* s2){
	while(*sb1 && *sb1==*s2) sb1++,s2++;
	if(!*s2 && is_st(*sb1)) return 0;
	return *sb1-*s2;
}
static inline int strcmp8_n(const char8_t* sb1, const char8_t* s2){while(*sb1 && *sb1==*s2) sb1++,s2++; return (*sb1-'\n')-*s2;}
static inline int strcmp8_b(const char8_t* sb1, const char8_t* s2){
	while(*s2 && *s2==*sb1) sb1++,s2++;
	if(!*s2 && is_stn(*sb1)) return 0;
	return *sb1-*s2;
}
static inline int strcmp8_b0(const char8_t* sb1, const char8_t* s2){
	while(*s2 && *s2==*sb1) sb1++,s2++;
	if(!*s2 && is_stn0(*sb1)) return 0;
	return *sb1-*s2;
}

//Return a pointer to the end of s2
static inline char8_t* strpcpy8(char8_t* s1, const char8_t* s2){whilenz(*s1++=*s2++); return s1-1;}
#define strpcpy8_0 strpcpy8
static inline char8_t* strpcpy8_s(char8_t* s1, const char8_t* s2){while(*s2!=' ') *s1++=*s2++; *s1='\0'; return s1;}
static inline char8_t* strpcpy8_st(char8_t* s1, const char8_t* s2){while(isnot_st(*s2)) *s1++=*s2++; *s1='\0'; return s1;}
static inline char8_t* strpcpy8_n(char8_t* s1, const char8_t* s2){while(*s2!='\n') *s1++=*s2++; *s1='\0'; return s1;}
static inline char8_t* strpcpy8_b(char8_t* s1, const char8_t* s2){char8_t c; while(c=*s2++, isnot_stn(c)) *s1++=c; *s1='\0'; return s1;}
static inline char8_t* strpcpy8_b0(char8_t* s1, const char8_t* s2){char8_t c; while(c=*s2++, isnot_stn0(c)) *s1++=c; *s1='\0'; return s1;}

static inline int strbeginsby8(const char8_t* s1, const char8_t* s2){while(*s2 && *s1==*s2) s1++,s2++; return *s2!='\0';}
#define strbeginsby8_0 strbeginsby8
static inline int strbeginsby8_s(const char8_t* s1, const char8_t* s2){while(*s2!=' ' && *s1==*s2) s1++,s2++; return *s2!=' ';}
static inline int strbeginsby8_st(const char8_t* s1, const char8_t* s2){while(isnot_st(*s2) && *s1==*s2) s1++,s2++; return isnot_st(*s2);}
static inline int strbeginsby8_n(const char8_t* s1, const char8_t* s2){while(*s2!='\n' && *s1==*s2) s1++,s2++; return *s2!='\n';}
static inline int strbeginsby8_b(const char8_t* s1, const char8_t* s2){char8_t c; while((c=*s2++, isnot_stn(c)) && *s1==c) s1++; return isnot_stn(c);}
static inline int strbeginsby8_b0(const char8_t* s1, const char8_t* s2){char8_t c; while((c=*s2++) && isnot_stn(c) && *s1==c) s1++; return isnot_stn0(c);}


#ifndef strcpy16
#define strcpy16(x,y) do{char16_t* _x=x; const char16_t *_y=y;						do *_x++=*_y; while(*_y++);}while(0)
#define strcpy16_0 strcpy16
#define strcpy16_s(x,y) do{char16_t* _x=x; const char16_t *_y=y;						while(*_y!=' ') *_x++=*_y++; *_x='\0';}while(0)
#define strcpy16_st(x,y) do{char16_t* _x=x; const char16_t *_y=y;					while(isnot_st(*_y)) *_x++=*_y++; *_x='\0';}while(0)
#define strcpy16_n(x,y) do{char16_t* _x=x; const char16_t *_y=y;						while(*_y!='\n') *_x++=*_y++; *_x='\0';}while(0)
#define strcpy16_b(x,y) do{char16_t* _x=x; const char16_t *_y=y; char16_t _c;		while(_c=*_y++, isnot_stn(_c)) *_x++=_c; *_x='\0';}while(0)
#define strcpy16_b0(x,y) do{char16_t* _x=x; const char16_t *_y=y; char16_t _c;	while(_c=*_y++, isnot_stn0(_c)) *_x++=_c; *_x='\0';}while(0)
#endif
#ifndef strncpy16
#define strncpy16(x,y,n) iflike(n){cint __i=n; char16_t *_x=x; const char16_t *_y=y-1;		do --__i, *_x++=*++_y; while(__i && *_y);}
#define strncpy16_0 strncpy16
#define strncpy16_s(x,y,n) iflike(n){cint _i=n; char16_t *_x=x; const char16_t *_y=y;		while(_i && *_y!=' ') do --_i, *_x++=*_y++; if(_i) *_x='\0';}
#define strncpy16_st(x,y,n) iflike(n){cint _i=n; char16_t *_x=x; const char16_t *_y=y;		while(_i && isnot_st(*_y)) --_i, *_x++=*_y++; if(_i) *_x='\0';}
#define strncpy16_n(x,y,n) iflike(n){cint _i=n; char16_t *_x=x; const char16_t *_y=y;		while(_i && *_y!='\n') do --_i, *_x++=*_y++; if(_i) *_x='\0';}
#define strncpy16_b(x,y,n) iflike(n){cint _i=n; char16_t *_x=x; const char16_t *_y=y; char16_t _c;	while(_i && (_c=*_y++, isnot_stn(_c))) --_i, *_x++=_c; if(_i) *_x='\0';}
#define strncpy16_b0(x,y,n) iflike(n){cint _i=n; char16_t *_x=x; const char16_t *_y=y; char16_t _c;	while(_i && (_c=*_y++, isnot_stn0(_c))) --_i, *_x++=_c; if(_i) *_x='\0';}
#endif
#ifndef strn0cpy16
#define strn0cpy16(x,y,n) iflike(n){cint _i=n-1; char16_t *_x=x; const char16_t *_y=y;		while(_i && *_y) do --_i, *_x++=*_y++; *_x='\0';}
#define strn0cpy16_0 strn0cpy16
#define strn0cpy16_s(x,y,n) iflike(n){cint _i=n-1; char16_t *_x=x; const char16_t *_y=y;	while(_i && *_y!=' ') do --_i, *_x++=*_y++; *_x='\0';}
#define strn0cpy16_st(x,y,n) iflike(n){cint _i=n-1; char6_t *_x=x; const char16_t *_y=y;	while(_i && isnot_st(*_y)) --_i, *_x++=*_y++; *_x='\0';}
#define strn0cpy16_n(x,y,n) iflike(n){cint _i=n-1; char16_t *_x=x; const char16_t *_y=y;	while(_i && *_y!='\n') do --_i, *_x++=*_y++; *_x='\0';}
#define strn0cpy16_b(x,y,n) iflike(n){cint _i=n-1; char16_t *_x=x; const char16_t *_y=y; char16_t _c;	while(_i && (_c=*_y++, isnot_stn(_c))) --_i, *_x++=_c; *_x='\0';}
#define strn0cpy16_b0(x,y,n) iflike(n){cint _i=n-1; char16_t *_x=x; const char16_t *_y=y; char16_t _c;	while(_i && (_c=*_y++, isnot_stn0(_c))) --_i, *_x++=_c; *_x='\0';}
#endif

static inline pdif strlen16(const char16_t *s){const char16_t* c=s; while(*c) c++; return (pdif)(c-s);}
#define strlen16_0 strlen16
static inline pdif strlen16_s(const char16_t* s){const char16_t* c=s; while(*c!=' ') c++; return (pdif)(c-s);}
static inline pdif strlen16_st(const char16_t* s){const char16_t* c=s; while(isnot_st(*c)) c++; return (pdif)(c-s);}
static inline pdif strlen16_n(const char16_t* s){const char16_t* c=s; while(*c!='\n') c++; return (pdif)(c-s);}
static inline pdif strlen16_b(const char16_t* s){const char16_t* c=s; while(isnot_stn(*c)) c++; return (pdif)(c-s);}
static inline pdif strlen16_b0(const char16_t* s){const char16_t* c=s; while(isnot_stn0(*c)) c++; return (pdif)(c-s);}

static inline char16_t* strseek16(const char16_t* s, char16_t c){while(*s && *s!=c) s++; return (char16_t*)s;}
#define strseek16_0 strseek16
static inline char16_t* strseek16_s(const char16_t* s, char16_t c){while(*s!=' ' && *s!=c) s++; return (char16_t*)s;}
static inline char16_t* strseek16_st(const char16_t* s, char16_t c){while(isnot_st(*s) && *s!=c) s++; return (char16_t*)s;}
static inline char16_t* strseek16_n(const char16_t* s, char16_t c){while(*s!='\n' && *s!=c) s++; return (char16_t*)s;}
static inline char16_t* strseek16_b(const char16_t* s, char16_t c){while(isnot_stn(*s) && *s!=c) s++; return (char16_t*)s;}
static inline char16_t* strseek16_b0(const char16_t* s, char16_t c){while(isnot_stn0(*s) && *s!=c) s++; return (char16_t*)s;}

static inline int strcmp16(const char16_t* s1, const char16_t* s2){while(*s1 && *s1==*s2) s1++,s2++; return *s1-*s2;}
#define strcmp16_0 strcmp16
static inline int strcmp16_s(const char16_t* sb1, const char16_t* s2){while(*sb1 && *sb1==*s2) sb1++,s2++; return (*sb1-' ')-*s2;}
static inline int strcmp16_st(const char16_t* sb1, const char16_t* s2){
	while(*sb1 && *sb1==*s2) sb1++,s2++;
	if(!*s2 && is_st(*sb1)) return 0;
	return *sb1-*s2;
}
static inline int strcmp16_n(const char16_t* sb1, const char16_t* s2){while(*sb1 && *sb1==*s2) sb1++,s2++; return (*sb1-'\n')-*s2;}
static inline int strcmp16_b(const char16_t* sb1, const char16_t* s2){
	while(*s2 && *s2==*sb1) sb1++,s2++;
	if(!*s2 && is_stn(*sb1)) return 0;
	return *sb1-*s2;
}
static inline int strcmp16_b0(const char16_t* sb1, const char16_t* s2){
	while(*s2 && *s2==*sb1) sb1++,s2++;
	if(!*s2 && is_stn0(*sb1)) return 0;
	return *sb1-*s2;
}

//Return a pointer to the end of s2
static inline char16_t* strpcpy16(char16_t* s1, const char16_t* s2){whilenz(*s1++=*s2++); return s1-1;}
#define strpcpy16_0 strpcpy16
static inline char16_t* strpcpy16_s(char16_t* s1, const char16_t* s2){while(*s2!=' ') *s1++=*s2++; *s1='\0'; return s1;}
static inline char16_t* strpcpy16_st(char16_t* s1, const char16_t* s2){while(isnot_st(*s2)) *s1++=*s2++; *s1='\0'; return s1;}
static inline char16_t* strpcpy16_n(char16_t* s1, const char16_t* s2){while(*s2!='\n') *s1++=*s2++; *s1='\0'; return s1;}
static inline char16_t* strpcpy16_b(char16_t* s1, const char16_t* s2){char16_t c; while(c=*s2++, isnot_stn(c)) *s1++=c; *s1='\0'; return s1;}
static inline char16_t* strpcpy16_b0(char16_t* s1, const char16_t* s2){char16_t c; while(c=*s2++, isnot_stn0(c)) *s1++=c; *s1='\0'; return s1;}

static inline int strbeginsby16(const char16_t* s1, const char16_t* s2){while(*s2 && *s1==*s2) s1++,s2++; return *s2!='\0';}
#define strbeginsby16_0 strbeginsby16
static inline int strbeginsby16_s(const char16_t* s1, const char16_t* s2){while(*s2!=' ' && *s1==*s2) s1++,s2++; return *s2!=' ';}
static inline int strbeginsby16_st(const char16_t* s1, const char16_t* s2){while(isnot_st(*s2) && *s1==*s2) s1++,s2++; return isnot_st(*s2);}
static inline int strbeginsby16_n(const char16_t* s1, const char16_t* s2){while(*s2!='\n' && *s1==*s2) s1++,s2++; return *s2!='\n';}
static inline int strbeginsby16_b(const char16_t* s1, const char16_t* s2){char16_t c; while((c=*s2++, isnot_stn(c)) && *s1==c) s1++; return isnot_stn(c);}
static inline int strbeginsby16_b0(const char16_t* s1, const char16_t* s2){char16_t c; while((c=*s2++) && isnot_stn(c) && *s1==c) s1++; return isnot_stn0(c);}

#if defined(_MSC_VER) && !defined(_WIN64)
#define strpcpy8 strpcpy8_asm
char8_t* strpcpy8(char8_t* s1, const char8_t* s2);
#endif
