Hel2D(Typ) Addsufijo(Hel2D___Hel2Dg,Typ)(Hel2Dg(Typ)* tr1){
	Hel2D(Typ) T;
	TypeR cosk, sink;
	T.esc=tr1->esc;
	T.cosg=tr1->cosg;
	T.sing=tr1->sing;
	cosk=tr1->cosg/tr1->esc;
	sink=tr1->sing/tr1->esc;
	T.Tx=tr1->cg1.x -cosk*tr1->cg2.x -sink*tr1->cg2.y;
	T.Ty=tr1->cg1.y +sink*tr1->cg2.x -cosk*tr1->cg2.y;

	return T;
}

Hel2Dg(Typ) Addsufijo(Hel2Dg___pp,Typ)(const Puntoxy(TypeR)* comun1, const Puntoxy(TypeR)* comun2, uint n){
	Hel2Dg(Typ) T;
	const Puntoxy(TypeR) *ptr1, *ptr2;
	TypeR rr1,rr2, c,s;

	T.cg1.y=T.cg1.x=0;
	T.cg2.y=T.cg2.x=0;
	ptr1=comun1;
	ptr2=comun2;
	dontimes(n,){
		T.cg1.x+=ptr1->x;	T.cg1.y+=ptr1->y;	ptr1++;
		T.cg2.x+=ptr2->x;	T.cg2.y+=ptr2->y;	ptr2++;
	}
	{TypeR aux=ONE/n;
	T.cg1.x*=aux;	T.cg1.y*=aux;
	T.cg2.x*=aux;	T.cg2.y*=aux;}

	rr2=rr1=0;
	s=c=0;
	ptr1=comun1;
	ptr2=comun2;
	dontimes(n,){
		TypeR x1,y1,x2,y2;
		x1=ptr1->x-T.cg1.x;	y1=ptr1->y-T.cg1.y;	ptr1++;
		x2=ptr2->x-T.cg2.x;	y2=ptr2->y-T.cg2.y;	ptr2++;
		rr1+=x1*x1+y1*y1;
		rr2+=x2*x2+y2*y2;
		c+=x1*x2+y1*y2;
		s+=x1*y2-y1*x2;
	}
	T.esc=sqrt(rr2/rr1);
	{TypeR r=1/sqrt(c*c+s*s);
	T.cosg=c*r;
	T.sing=s*r;}
	return T;
}

//Los puntos se van alternando dentro del array: P11,P12,P21,P22,P31,P32... Pn1,Pn2.
Hel2Dg(Typ) Addsufijo(Hel2Dg___p,Typ)(const Puntoxy(TypeR)* puntos, uint n){
	Hel2Dg(Typ) T;
	const Puntoxy(TypeR) *ptr;
	TypeR rr1,rr2, c,s;

	T.cg1.y=T.cg1.x=0;
	T.cg2.y=T.cg2.x=0;
	ptr=puntos;
	dontimes(n,){
		T.cg1.x+=ptr->x;	T.cg1.y+=ptr->y;	ptr++;
		T.cg2.x+=ptr->x;	T.cg2.y+=ptr->y;	ptr++;
	}
	{TypeR aux=ONE/n;
	T.cg1.x*=aux;	T.cg1.y*=aux;
	T.cg2.x*=aux;	T.cg2.y*=aux;}

	rr2=rr1=0;
	s=c=0;
	ptr=puntos;
	dontimes(n,){
		TypeR x1,y1,x2,y2;
		x1=ptr->x-T.cg1.x;		y1=ptr->y-T.cg1.y;	ptr++;
		x2=ptr->x-T.cg2.x;		y2=ptr->y-T.cg2.y;	ptr++;
		rr1+=x1*x1+y1*y1;
		rr2+=x2*x2+y2*y2;
		c+=x1*x2+y1*y2;
		s+=x1*y2-y1*x2;
	}
	T.esc=sqrt(rr2/rr1);
	{TypeR r=1/sqrt(c*c+s*s);
	T.cosg=c*r;
	T.sing=s*r;}
	return T;
}

Hel2Dg(Typ) Addsufijo(Hel2Dg___gg,Typ)(const Puntoxy(TypeR)* comun1, const Puntoxy(TypeR)* comun2, size_t size, uint n){
	Hel2Dg(Typ) T;
	const Puntoxy(TypeR) *ptr1, *ptr2;
	TypeR rr1,rr2, c,s;

	T.cg1.y=T.cg1.x=0;
	T.cg2.y=T.cg2.x=0;
	ptr1=comun1;
	ptr2=comun2;
	dontimes(n, (ptr1=(const Puntoxy(TypeR)*)((char*)ptr1+size),
					  ptr2=(const Puntoxy(TypeR)*)((char*)ptr2+size))){
		T.cg1.x+=ptr1->x;	T.cg1.y+=ptr1->y;
		T.cg2.x+=ptr2->y;	T.cg2.y+=ptr2->y;
	}
	{TypeR aux=ONE/n;
	T.cg1.x*=aux;	T.cg1.y*=aux;
	T.cg2.x*=aux;	T.cg2.y*=aux;}

	rr2=rr1=0;
	s=c=0;
	ptr1=comun1;
	ptr2=comun2;
	dontimes(n, (ptr1=(const Puntoxy(TypeR)*)((char*)ptr1+size),
					  ptr2=(const Puntoxy(TypeR)*)((char*)ptr2+size))){
		TypeR x1,y1,x2,y2;
		x1=ptr1->x-T.cg1.x;	y1=ptr1->y-T.cg1.y;
		x2=ptr2->x-T.cg2.x;	y2=ptr2->y-T.cg2.y;
		rr1+=x1*x1+y1*y1;
		rr2+=x2*x2+y2*y2;
		c+=x1*x2+y1*y2;
		s+=x1*y2-y1*x2;
	}
	T.esc=sqrt(rr2/rr1);
	{TypeR r=1/sqrt(c*c+s*s);
	T.cosg=c*r;
	T.sing=s*r;}
	return T;
}

Hel2Dg(Typ) Addsufijo(Hel2Dg___g,Typ)(const Puntoxy(TypeR)* puntos, size_t size, uint n){
	Hel2Dg(Typ) T;
	const Puntoxy(TypeR) *ptr;
	TypeR rr1,rr2, c,s;

	T.cg1.y=T.cg1.x=0;
	T.cg2.y=T.cg2.x=0;
	ptr=puntos;
	dontimes(n,){
		T.cg1.x+=ptr->x;	T.cg1.y+=ptr->y;	ptr=(const Puntoxy(TypeR)*)((char*)ptr+size);
		T.cg2.x+=ptr->x;	T.cg2.y+=ptr->y;	ptr=(const Puntoxy(TypeR)*)((char*)ptr+size);
	}
	{TypeR aux=ONE/n;
	T.cg1.x*=aux;	T.cg1.y*=aux;
	T.cg2.x*=aux;	T.cg2.y*=aux;}

	rr2=rr1=0;
	s=c=0;
	ptr=puntos;
	dontimes(n,){
		TypeR x1,y1,x2,y2;
		x1=ptr->x-T.cg1.x;		y1=ptr->y-T.cg1.y;		ptr=(const Puntoxy(TypeR)*)((char*)ptr+size);
		x2=ptr->x-T.cg2.x;	y2=ptr->y-T.cg2.y;	ptr=(const Puntoxy(TypeR)*)((char*)ptr+size);
		rr1+=x1*x1+y1*y1;
		rr2+=x2*x2+y2*y2;
		c+=x1*x2+y1*y2;
		s+=x1*y2-y1*x2;
	}
	T.esc=sqrt(rr2/rr1);
	{TypeR r=1/sqrt(c*c+s*s);
	T.cosg=c*r;
	T.sing=s*r;}
	return T;
}

Hel2Dg(Typ) Addsufijo(Hel2Dg___mixed,Typ)(const Puntoxy(TypeR)* comun1, size_t size1, const Puntoxy(TypeR)* comun2, size_t size2, uint n){
	Hel2Dg(Typ) T;
	const Puntoxy(TypeR) *ptr1, *ptr2;
	TypeR rr1,rr2, c,s;

	T.cg1.y=T.cg1.x=0;
	T.cg2.y=T.cg2.x=0;
	ptr1=comun1;
	ptr2=comun2;
	dontimes(n, (ptr1=(const Puntoxy(TypeR)*)((char*)ptr1+size1),
					  ptr2=(const Puntoxy(TypeR)*)((char*)ptr2+size2))){
		T.cg1.x+=ptr1->x;	T.cg1.y+=ptr1->y;
		T.cg2.x+=ptr2->x;	T.cg2.y+=ptr2->y;
	}
	{TypeR aux=ONE/n;
	T.cg1.x*=aux;	T.cg1.y*=aux;
	T.cg2.x*=aux;	T.cg2.y*=aux;}

	rr2=rr1=0;
	s=c=0;
	ptr1=comun1;
	ptr2=comun2;
	dontimes(n, (ptr1=(const Puntoxy(TypeR)*)((char*)ptr1+size1),
					  ptr2=(const Puntoxy(TypeR)*)((char*)ptr2+size2))){
		TypeR x1,y1,x2,y2;
		x1=ptr1->x-T.cg1.x;	y1=ptr1->y-T.cg1.y;
		x2=ptr2->x-T.cg2.x;	y2=ptr2->y-T.cg2.y;
		rr1+=x1*x1+y1*y1;
		rr2+=x2*x2+y2*y2;
		c+=x1*x2+y1*y2;
		s+=x1*y2-y1*x2;
	}
	T.esc=sqrt(rr2/rr1);
	{TypeR r=1/sqrt(c*c+s*s);
	T.cosg=c*r;
	T.sing=s*r;}
	return T;
}

Hel2Dg(Typ) Addsufijo(Hel2Dg___ptr,Typ)(const Puntoxy(TypeR)* const * puntos, uint n){
	Hel2Dg(Typ) T;
	const Puntoxy(TypeR)* const *ptr;
	TypeR rr1,rr2, c,s;

	T.cg1.y=T.cg1.x=0;
	T.cg2.y=T.cg2.x=0;
	ptr=puntos;
	dontimes(n,){
		T.cg1.x+=(*ptr)->x;		T.cg1.y+=(*ptr)->y;		ptr++;
		T.cg2.x+=(*ptr)->x;	T.cg2.y+=(*ptr)->y;	ptr++;
	}
	{TypeR aux=ONE/n;
	T.cg1.x*=aux;	T.cg1.y*=aux;
	T.cg2.x*=aux;	T.cg2.y*=aux;}

	rr2=rr1=0;
	s=c=0;
	ptr=puntos;
	dontimes(n,){
		TypeR x1,y1,x2,y2;
		x1=(*ptr)->x-T.cg1.x;		y1=(*ptr)->y-T.cg1.y;		ptr++;
		x2=(*ptr)->x-T.cg2.x;	y2=(*ptr)->y-T.cg2.y;	ptr++;
		rr1+=x1*x1+y1*y1;
		rr2+=x2*x2+y2*y2;
		c+=x1*x2+y1*y2;
		s+=x1*y2-y1*x2;
	}
	T.esc=sqrt(rr2/rr1);
	{TypeR r=1/sqrt(c*c+s*s);
	T.cosg=c*r;
	T.sing=s*r;}
	return T;
}
