﻿void MatrizRotGT_ωφκ(Giro3DTrig_dbl GT,double M[][3]){	//ω, φ, κ, +
	double aux;
	M[0][0]=GT.cosk*GT.cosfi;
	M[1][0]=GT.sink*GT.cosfi;
	M[2][0]=-GT.sinfi;
	aux=GT.sinfi*GT.sinw;
	M[0][1]=GT.cosk*aux-GT.sink*GT.cosw;
	M[1][1]=GT.sink*aux+GT.cosk*GT.cosw;
	M[2][1]=GT.cosfi*GT.sinw;
	aux=GT.sinfi*GT.cosw;
	M[0][2]=GT.cosk*aux+GT.sink*GT.sinw;
	M[1][2]=GT.sink*aux-GT.cosk*GT.sinw;
	M[2][2]=GT.cosfi*GT.cosw;
}

void MatrizRotGT_κωφ(Giro3DTrig_dbl GT,double M[][3]){	//κ, ω, φ, +
	double aux;
	aux=GT.sinw; GT.sinw=GT.sink; GT.sink=GT.sinfi; GT.sinfi=aux;
	aux=GT.cosw; GT.cosw=GT.cosk; GT.cosk=GT.cosfi; GT.cosfi=aux;
	MatrizRotGT_ωφκ(GT,M);
	aux=M[0][0]; M[0][0]=M[1][1]; M[1][1]=M[2][2]; M[2][2]=aux;
	aux=M[0][1]; M[0][1]=M[1][2]; M[1][2]=M[2][0]; M[2][0]=aux;
	aux=M[0][2]; M[0][2]=M[1][0]; M[1][0]=M[2][1]; M[2][1]=aux;
}

//Para esta función GT.cosw, sinw son del primer giro κ; cosfi, sinfi son
//del giro ω , y cosk sink del segundo giro κ.
void MatrizRotGT_κwκ(Giro3DTrig_dbl GT,double M[][3]){	//κ, ω, κ, +
	double aux;
	M[0][2]=GT.sink*GT.sinfi;
	M[1][2]=-GT.cosk*GT.sinfi;
	M[2][0]=GT.sinw*GT.sinfi;
	M[2][1]=GT.cosw*GT.sinfi;
	M[2][2]=GT.cosfi;
	aux=GT.sinw*GT.cosfi;
	M[0][0]=GT.cosk*GT.cosw-GT.sink*aux;
	M[1][0]=GT.sink*GT.cosw+GT.cosk*aux;
	aux=GT.cosw*GT.cosfi;
	M[0][1]=-GT.cosk*GT.sinw-GT.sink*aux;
	M[1][1]=-GT.sink*GT.sinw+GT.cosk*aux;
}

void MatrizRot_κωφ(Giro3D_double G, double M[][3]){	//κ, ω, φ, +
	double aux;
	aux=G.ω; G.ω=G.κ; G.κ=G.φ; G.φ=aux;
	MatrizRot_ωφκ(G,M);
	aux=M[0][0]; M[0][0]=M[1][1]; M[1][1]=M[2][2]; M[2][2]=aux;
	aux=M[0][1]; M[0][1]=M[1][2]; M[1][2]=M[2][0]; M[2][0]=aux;
	aux=M[0][2]; M[0][2]=M[1][0]; M[1][0]=M[2][1]; M[2][1]=aux;
}

void MatrizRot_24(Giro3D_double G, double M[][3]){ //ω, φ, κ (5), +
	double x,y,z;
	double q;

	x=G.ω*G.ω;
	y=G.φ*G.φ;
	z=G.κ*G.κ;
	M[0][0]=1-.5*(y+z);
	M[1][1]=1-.5*(z+x);
	M[2][2]=1-.5*(x+y);
	M[1][0]=M[0][1]=.5*G.ω*G.φ;
	M[2][0]=M[0][2]=.5*G.κ*G.ω;
	M[2][1]=M[1][2]=.5*G.φ*G.κ;
	q=x+y+z;	q=sqrt(1-q/4);
	G_mul(G,q);
	M[0][1]-=G.κ;	M[1][0]+=G.κ;
	M[0][2]+=G.φ;	M[2][0]-=G.φ;
	M[1][2]-=G.ω;	M[2][1]+=G.ω;
}

/* Esta es MatrizDelta, cuidado con cambiarla */
void MatrizRot_26(Giro3D_double G, double M[][3]){ //ω, φ, κ (6), +
	double x,y,z;
	double p;

	x=G.ω*G.ω;
	y=G.φ*G.φ;
	z=G.κ*G.κ;
	p=2+.5*(x+y+z);
	p=1/p;
	M[0][0]=1-p*(y+z);
	M[1][1]=1-p*(z+x);
	M[2][2]=1-p*(x+y);
	G.ω*=p;
	M[1][0]=M[0][1]=G.ω*G.φ;
	M[2][0]=M[0][2]=G.κ*G.ω;
	G.φ*=p;
	M[2][1]=M[1][2]=G.φ*G.κ;
	G.κ*=p;
	G_mul(G,2);
	M[0][1]-=G.κ;	M[1][0]+=G.κ;
	M[0][2]+=G.φ;	M[2][0]-=G.φ;
	M[1][2]-=G.ω;	M[2][1]+=G.ω;
}

float MatrizDeltafl_dbl(Giro3D_float G, double M[][3]){
	float x,y,z;
	float p,f;

	x=G.ω*G.ω;
	y=G.φ*G.φ;
	z=G.κ*G.κ;
	f=x+y+z;
	p=2.0F+.5F*f;
	p=1/p;
	M[0][0]=1.0-p*(y+z);
	M[1][1]=1.0-p*(z+x);
	M[2][2]=1.0-p*(x+y);
	G.ω*=p;
	M[1][0]=M[0][1]=G.ω*G.φ;
	M[2][0]=M[0][2]=G.κ*G.ω;
	G.φ*=p;
	M[2][1]=M[1][2]=G.φ*G.κ;
	G.κ*=p;
	G_mul(G,2.0F);
	M[0][1]-=G.κ;	M[1][0]+=G.κ;
	M[0][2]+=G.φ;	M[2][0]-=G.φ;
	M[1][2]-=G.ω;	M[2][1]+=G.ω;

	return f;
}

float MatrizDeltafl_fl(Giro3D_float G, float M[][3]){
	float x,y,z;
	float p,f;

	x=G.ω*G.ω;
	y=G.φ*G.φ;
	z=G.κ*G.κ;
	f=x+y+z;
	p=2.0F+.5F*f;
	p=1/p;
	M[0][0]=1.0F-p*(y+z);
	M[1][1]=1.0F-p*(z+x);
	M[2][2]=1.0F-p*(x+y);
	G.ω*=p;
	M[1][0]=M[0][1]=G.ω*G.φ;
	M[2][0]=M[0][2]=G.κ*G.ω;
	G.φ*=p;
	M[2][1]=M[1][2]=G.φ*G.κ;
	G.κ*=p;
	G_mul(G,2.0F);
	M[0][1]-=G.κ;	M[1][0]+=G.κ;
	M[0][2]+=G.φ;	M[2][0]-=G.φ;
	M[1][2]-=G.ω;	M[2][1]+=G.ω;

	return f;
}

void MatrizRot_28(Giro3D_double G, double M[][3]){ //ω, φ, κ (7), +
	Giro3DTrig_dbl GT;
	double q;

	GT.cosw=cos(G.ω);		GT.sinw=sin(0.5*G.ω);
	GT.cosfi=cos(G.φ);		GT.sinfi=sin(0.5*G.φ);
	GT.cosk=cos(G.κ);		GT.sink=sin(0.5*G.κ);
	M[0][0]=GT.cosfi+GT.cosk-1;
	M[1][1]=GT.cosk+GT.cosw-1;
	M[2][2]=GT.cosw+GT.cosfi-1;
	q=GT.cosw+GT.cosfi+GT.cosk-1;
	q=sqrt(2*q);
	M[1][0]=M[0][1]=2*GT.sinw*GT.sinfi;
	M[2][0]=M[0][2]=2*GT.sinfi*GT.sink;
	M[2][1]=M[1][2]=2*GT.sink*GT.sinw;
	GT.sinw*=q;	GT.sinfi*=q;	GT.sink*=q;
	M[0][1]-=GT.sink;	M[1][0]+=GT.sink;
	M[0][2]+=GT.sinfi;	M[2][0]-=GT.sinfi;
	M[1][2]-=GT.sinw;	M[2][1]+=GT.sinw;
}

void MatrizRot_20(Giro3D_double G, double M[][3]){ //a, b, c, +
	double x,y,z;
	double s,t;

	x=G.ω*G.ω;
	y=G.φ*G.φ;
	z=G.κ*G.κ;
	t=sqrt(x+y+z);
	s=sin(t)/t;
	t=(1-cos(t))/(x+y+z);
	M[0][0]=1-t*(y+z);
	M[1][1]=1-t*(z+x);
	M[2][2]=1-t*(x+y);
	M[1][0]=M[0][1]=t*G.ω*G.φ;
	M[2][0]=M[0][2]=t*G.κ*G.ω;
	M[2][1]=M[1][2]=t*G.φ*G.κ;
	G_mul(G,s);
	M[0][1]-=G.κ;	M[1][0]+=G.κ;
	M[0][2]+=G.φ;	M[2][0]-=G.φ;
	M[1][2]-=G.ω;	M[2][1]+=G.ω;
}
/*** Fin Matrices ***/

Giro3D_double Gmatriz_ωφκ_seg(const double M[][3]){
	Giro3D_double G;
	double sinfi;

	sinfi=-M[2][0];
	iflike(fabs(sinfi)<0.9){
		G.φ=asin(sinfi);
		G.κ=atan2(M[1][0],M[0][0]);
		G.ω=atan2(M[2][1],M[2][2]);
	}else{
		double aux;
		double sinkw,coskw;
		double kw;
		aux=M[0][0]*M[0][0];
		aux+=M[1][0]*M[1][0];
		aux=sqrt(aux);
		G.φ=acos(aux);
		if(sinfi>0){
			sinkw=-M[0][1]+M[1][2];
			coskw=M[0][2]+M[1][1];
		}else{
			G.φ=-G.φ;
			sinkw=-M[0][1]-M[1][2];
			coskw=-M[0][2]+M[1][1];
		}
		kw=atan2(sinkw,coskw);
		ifunlike((M[0][0]==0 && M[1][0]==0) || (M[2][1]==0 && M[2][2]==0)){
			G.κ=kw;
			G.ω=0;
		}else{
			G.κ=atan2(M[1][0],M[0][0]);
			G.ω=atan2(M[2][1],M[2][2]);
			if(sinfi>0) aux=G.κ-G.ω;
			else aux=G.κ+G.ω;
			aux-=kw;
			modPI2(aux);
			aux/=2;
			G.κ-=aux;
			if(sinfi>0) G.ω+=aux;
			else G.ω-=aux;
			modPI2(G.κ);
			modPI2(G.ω);
		}
	}
	return G;
}

Giro3D_double Gmatriz_24_seg(const double M[][3]){
	Giro3D_double G;
	double q;
	q=M[0][0]+M[1][1]+M[2][2];
	iflike(q>-0.8){
		q=sqrt(1+q);
		G.ω=(M[2][1]-M[1][2])/q;
		G.φ=(M[0][2]-M[2][0])/q;
		G.κ=(M[1][0]-M[0][1])/q;
	}else{
		q=1-q;
		G.ω=2*M[0][0]+q;	if(G.ω<0) G.ω=0;	//¿Cómo hará el compilador la multiplicación por 2.0?
		else{											//Si lo hace bien es más rápido así que sumar.
			G.ω=sqrt(G.ω);	if(M[2][1]<M[1][2]) G.ω=-G.ω;
		}
		G.φ=2*M[1][1]+q;	if(G.φ<0) G.φ=0;
		else{
			G.φ=sqrt(G.φ);	if(M[0][2]<M[2][0]) G.φ=-G.φ;
		}
		G.κ=2*M[2][2]+q;	if(G.κ<0) G.κ=0;
		else{
			G.κ=sqrt(G.κ);	if(M[1][0]<M[0][1]) G.κ=-G.κ;
		}
	}
	return G;
}

//Descompone la matriz en 1º (por la derecha): Un giro κ de un múltiplo de 90º
// y 2º: una descomponsición según func en la que el ángulo κ es pequeño.
//En c se devuelve el número de múltiplos de 90º.
Giro3D_double Getoffset_matriz(const double M[][3], Giro3D_double (*func)(const double M[][3]), u8int *c){
	const double (*iM)[3];
	double Mb[3][3];
	Giro3D_double G;
	iM=M;
	if(iM[0][0]*iM[1][1]+iM[0][1]*iM[1][0]>=0){
		*c=0;
	}else{
		//Quitar 90º de M.
		Mb[0][0]=-iM[0][1];	Mb[0][1]=iM[0][0];	Mb[0][2]=iM[0][2];
		Mb[1][0]=-iM[1][1];	Mb[1][1]=iM[1][0];	Mb[1][2]=iM[1][2];
		Mb[2][0]=-iM[2][1];	Mb[2][1]=iM[2][0];	Mb[2][2]=iM[2][2];
		iM=Mb;
		*c=1;
	}
	if(func==Gmatriz_ωφκ_seg){
		G=Gmatriz_ωφκ_seg(iM);
		if(fabs(G.κ)>PI_2){
			*c+=2;
			if(G.κ>=0) G.κ-=PI;
			else G.κ+=PI;
			G.ω=-G.ω; G.φ=-G.φ;
		}
		return G;
	}
	if(iM[0][0]<0){
		*c+=2;
		if(iM!=Mb) memcpy_double(Mb[0],iM[0],9);
		Mb[0][0]=-Mb[0][0];	Mb[0][1]=-Mb[0][1];
		Mb[1][0]=-Mb[1][0];	Mb[1][1]=-Mb[1][1];
	}
	G=func(Mb);
	return G;
}

Giro3D_double Gmedio(const Giro3D_double* giros, uint n){
	uint nx,ny,nz, mx,my,mz;
	uint i;
	Giro3D_double Gmas, Gmenos, Gmedia;

	Gmas.ω=Gmas.φ=Gmas.κ=0;
	Gmenos=Gmas;
	nx=ny=nz=0;
	mx=my=mz=0;
	for(i=0;i<n;i++,giros++){
		if(giros->ω>0){Gmas.ω+=giros->ω; nx++;}
		else{	Gmenos.ω+=giros->ω; mx++;}
		if(giros->φ>0){Gmas.φ+=giros->φ; ny++;}
		else{	Gmenos.φ+=giros->φ; my++;}
		if(giros->κ>0){Gmas.κ+=giros->κ; nz++;}
		else{	Gmenos.κ+=giros->κ; mz++;}
	}
	if(mx==0) Gmedia.ω=Gmas.ω/n;
	else if(nx==0) Gmedia.ω=Gmenos.ω/n;
	else{
		Gmenos.ω/=mx;
		if(Gmas.ω/nx-Gmenos.ω>PI) Gmenos.ω+=PI2;
		Gmedia.ω=Gmas.ω+Gmenos.ω*mx;
		Gmedia.ω/=n;
		if(Gmedia.ω>PI) Gmedia.ω-=PI2;
	}
	if(my==0) Gmedia.φ=Gmas.φ/n;
	else if(ny==0) Gmedia.φ=Gmenos.φ/n;
	else{
		Gmenos.φ/=my;
		if(Gmas.φ/ny-Gmenos.φ>PI) Gmenos.φ+=PI2;
		Gmedia.φ=Gmas.φ+Gmenos.φ*my;
		Gmedia.φ/=n;
		if(Gmedia.φ>PI) Gmedia.φ-=PI2;
	}
	if(mz==0) Gmedia.κ=Gmas.κ/n;
	else if(nz==0) Gmedia.κ=Gmenos.κ/n;
	else{
		Gmenos.κ/=mz;
		if(Gmas.κ/nz-Gmenos.κ>PI) Gmenos.κ+=PI2;
		Gmedia.κ=Gmas.κ+Gmenos.κ*mz;
		Gmedia.κ/=n;
		if(Gmedia.κ>PI) Gmedia.κ-=PI2;
	}
	return Gmedia;
}
Giro3D_double Gmedio_pesos(const Giro3D_double* giros, uint n, const Giro3D_float* P){
	float nx,ny,nz, mx,my,mz;
	uint i;
	Giro3D_double Gmas, Gmenos, Gmedia;
	double aux;

	Gmas.ω=Gmas.φ=Gmas.κ=0;
	Gmenos=Gmas;
	nx=ny=nz=0;
	mx=my=mz=0;
	for(i=0;i<n;i++,giros++,P++){
		aux=giros->ω*P->ω;
		if(giros->ω>0){Gmas.ω+=aux; nx+=P->ω;}
		else{	Gmenos.ω+=aux; mx+=P->ω;}
		aux=giros->φ*P->φ;
		if(giros->φ>0){Gmas.φ+=aux; ny+=P->φ;}
		else{	Gmenos.φ+=aux; my+=P->φ;}
		aux=giros->κ*P->κ;
		if(giros->κ>0){Gmas.κ+=aux; nz+=P->κ;}
		else{	Gmenos.κ+=aux; mz+=P->κ;}
	}
	if(mx==0) Gmedia.ω=Gmas.ω/nx;
	else if(nx==0) Gmedia.ω=Gmenos.ω/mx;
	else{
		Gmenos.ω/=mx;
		if(Gmas.ω/nx-Gmenos.ω>PI) Gmenos.ω+=PI2;
		Gmedia.ω=Gmas.ω+Gmenos.ω*mx;
		Gmedia.ω/=(nx+mx);
		if(Gmedia.ω>PI) Gmedia.ω-=PI2;
	}
	if(my==0) Gmedia.φ=Gmas.φ/ny;
	else if(ny==0) Gmedia.φ=Gmenos.φ/my;
	else{
		Gmenos.φ/=my;
		if(Gmas.φ/ny-Gmenos.φ>PI) Gmenos.φ+=PI2;
		Gmedia.φ=Gmas.φ+Gmenos.φ*my;
		Gmedia.φ/=(ny+my);
		if(Gmedia.φ>PI) Gmedia.φ-=PI2;
	}
	if(mz==0) Gmedia.κ=Gmas.κ/nz;
	else if(nz==0) Gmedia.κ=Gmenos.κ/mz;
	else{
		Gmenos.κ/=mz;
		if(Gmas.κ/nz-Gmenos.κ>PI) Gmenos.κ+=PI2;
		Gmedia.κ=Gmas.κ+Gmenos.κ*mz;
		Gmedia.κ/=(nz+mz);
		if(Gmedia.κ>PI) Gmedia.κ-=PI2;
	}
	return Gmedia;
}
