﻿#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h>
#define uchar unsigned char
#define uint unsigned int
#define ullong unsigned long long
#ifndef _likely
#define _likely(x) (x)
#define _unlikely(x) (x)
#endif
#ifndef iflike
#define iflike(x) if(_likely(x))
#endif
#ifndef ifunlike
#define ifunlike(x) if(_unlikely(x))
#endif

//const long double pi6= 0.60792710185402662866327678;
const long double _pi6= 0.39207289814597337133672322;
#define MULT_TOPE 5004000000
 //The only possbile residue classes of Q-numbers.
const ullong mod900[]={-1, 28, 29, 32, 33, 56, 64, 65, 68, 81, 84, 92, 100, 101, 104, 105, 128, 136, 137, 140, 153, 176, 177, 180, 181, 189, 192, 200, 208, 209, 212, 213, 216, 217, 225, 228, 236, 244, 280, 281, 284, 285, 288, 289, 297,
								300, 308, 316, 352, 353, 356, 357, 380, 388, 389, 392, 393, 396, 425, 428, 429, 432, 433, 441, 444, 452, 460, 461, 464, 477, 480, 488, 496, 497, 500, 501, 532, 533, 536, 552, 560, 568, 576, 577, 585, 588, 596,
								604, 605, 608, 609, 632, 640, 641, 644, 657, 660, 668, 676, 677, 680, 681, 684, 685, 693, 696, 704, 712, 713, 716, 729, 752, 753, 776, 784, 785, 788, 789, 792, 793, 801, 804, 812, 825, 856, 857, 860, 876, 884, 892, 893, 896, 897, -1};
const uint nmod900=sizeof(mod900)/sizeof(mod900[0])-2;

const uint PrimesM[]={2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97,101,103,107,109,113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,197,199,211,223,227,229,233,239,241,251,257,263,269,271,277,281,283,293,307,311,313,317,331,337,347,349,353,359,367,373,379,383,389,397,401,409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,499,503,509,521,523,541,547,557,563,569,571,577,587,593,599,601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,691,701,709,719,727,733,739,743,751,757,761,769,773,787,797,809,811,821,823,827,829,839,853,857,859,863,877,881,883,887,907,911,919,929,937,941,947,953,967,971,977,983,991,997,
						1009,1013,1019,1021,1031,1033,1039,1049,1051,1061,1063,1069,1087,1091,1093,1097,1103,1109,1117,1123,1129,1151,1153,1163,1171,1181,1187,1193,1201,1213,1217,1223,1229,1231,1237,1249,1259,1277,1279,1283,1289,1291,1297,1301,1303,1307,1319,1321,1327,1361,1367,1373,1381,1399,1409,1423,1427,1429,1433,1439,1447,1451,1453,1459,1471,1481,1483,1487,1489,1493,1499,1511,1523,1531,1543,1549,1553,1559,1567,1571,1579,1583,1597,1601,1607,1609,1613,1619,1621,1627,1637,1657,1663,1667,1669,1693,1697,1699,1709,1721,1723,1733,1741,1747,1753,1759,1777,1783,1787,1789,1801,1811,1823,1831,1847,1861,1867,1871,1873,1877,1879,1889,1901,1907,1913,1931,1933,1949,1951,1973,1979,1987,1993,1997,1999,
						2003,2011,2017,2027,2029,2039,2053,2063,2069,2081,2083,2087,2089,2099,2111,2113,2129,2131,2137,2141,2143,2153,2161,2179,2203,2207,2213,2221,2237,2239,2243,2251,2267,2269,2273,2281,2287,2293,2297,2309,2311,2333,2339,2341,2347,2351,2357,2371,2377,2381,2383,2389,2393,2399,2411,2417,2423,2437,2441,2447,2459,2467,2473,2477,2503,2521,2531,2539,2543,2549,2551,2557,2579,2591,2593,2609,2617,2621,2633,2647,2657,2659,2663,2671,2677,2683,2687,2689,2693,2699,2707,2711,2713,2719,2729,2731,2741,2749,2753,2767,2777,2789,2791,2797,2801,2803,2819,2833,2837,2843,2851,2857,2861,2879,2887,2897,2903,2909,2917,2927,2939,2953,2957,2963,2969,2971,2999,
						3001,3011,3019,3023,3037,3041,3049,3061,3067,3079,3083,3089,3109,3119,3121,3137,3163,3167,3169,3181,3187,3191,3203,3209,3217,3221,3229,3251,3253,3257,3259,3271,3299,3301,3307,3313,3319,3323,3329,3331,3343,3347,3359,3361,3371,3373,3389,3391,3407,3413,3433,3449,3457,3461,3463,3467,3469,3491,3499,3511,3517,3527,3529,3533,3539,3541,3547,3557,3559,3571,3581,3583,3593,3607,3613,3617,3623,3631,3637,3643,3659,3671,3673,3677,3691,3697,3701,3709,3719,3727,3733,3739,3761,3767,3769,3779,3793,3797,3803,3821,3823,3833,3847,3851,3853,3863,3877,3881,3889,3907,3911,3917,3919,3923,3929,3931,3943,3947,3967,3989,
						4001,4003,4007,4013,4019,4021,4027,4049,4051,4057,4073,4079,4091,4093,4099,4111,4127,4129,4133,4139,4153,4157,4159,4177,4201,4211,4217,4219,4229,4231,4241,4243,4253,4259,4261,4271,4273,4283,4289,4297,4327,4337,4339,4349,4357,4363,4373,4391,4397,4409,4421,4423,4441,4447,4451,4457,4463,4481,4483,4493,4507,4513,4517,4519,4523,4547,4549,4561,4567,4583,4591,4597,4603,4621,4637,4639,4643,4649,4651,4657,4663,4673,4679,4691,4703,4721,4723,4729,4733,4751,4759,4783,4787,4789,4793,4799,4801,4813,4817,4831,4861,4871,4877,4889,4903,4909,4919,4931,4933,4937,4943,4951,4957,4967,4969,4973,4987,4993,4999,
						5003,5009,5011,5021,5023,5039,5051,5059,5077,5081,5087,5099,5101,5107,5113,5119,5147,5153,5167,5171,5179,5189,5197,5209,5227,5231,5233,5237,5261,5273,5279,5281,5297,5303,5309,5323,5333,5347,5351,5381,5387,5393,5399,5407,5413,5417,5419,5431,5437,5441,5443,5449,5471,5477,5479,5483,5501,5503,5507,5519,5521,5527,5531,5557,5563,5569,5573,5581,5591,5623,5639,5641,5647,5651,5653,5657,5659,5669,5683,5689,5693,5701,5711,5717,5737,5741,5743,5749,5779,5783,5791,5801,5807,5813,5821,5827,5839,5843,5849,5851,5857,5861,5867,5869,5879,5881,5897,5903,5923,5927,5939,5953,5981,5987,
						6007,6011,6029,6037,6043,6047,6053,6067,6073,6079,6089,6091,6101,6113,6121,6131,6133,6143,6151,6163,6173,6197,6199,6203,6211,6217,6221,6229,6247,6257,6263,6269,6271,6277,6287,6299,6301,6311,6317,6323,6329,6337,6343,6353,6359,6361,6367,6373,6379,6389,6397,6421,6427,6449,6451,6469,6473,6481,6491,6521,6529,6547,6551,6553,6563,6569,6571,6577,6581,6599,6607,6619,6637,6653,6659,6661,6673,6679,6689,6691,6701,6703,6709,6719,6733,6737,6761,6763,6779,6781,6791,6793,6803,6823,6827,6829,6833,6841,6857,6863,6869,6871,6883,6899,6907,6911,6917,6947,6949,6959,6961,6967,6971,6977,6983,6991,6997,
						0};
#define PRIMEM 7000
uint NextPrime[sizeof(PrimesM)/sizeof(PrimesM[0])];

#define CHUNK_SIZE 18000000 //Multiple of 900

int main(int argc, char** argv){
	int nret=0; //return value
	int bm=0;

	if(argc>=3){
		bm=(argv[1][0]=='-' && (argv[1][1]=='m' || argv[1][1]=='M') && argv[1][2]=='\0');
		if(bm && argv[1][1]=='M') bm=2;
	}
	if(argc<2 || argc>3 || (argc==3 && !bm)){
		puts("Program usage: q-numbers [-m/-M] N\n\n"
			"For each n from 1 to N the program computes how many non-squarefree\n"
			"numbers are in [1, n]. If the option -M is *not* passed it will display a line for\n"
			"every value of n like\n"
			"\n"
			"    n  n-non-qf\n"
			"\n"
			"where n-non-qf is the number or non-qf numbers in [1, n].\n"
			"    If either option -m or -M is passed it will in addition write a second\n"
			"block of information with lines of the form\n"
			"\n"
			"    n  n-non-qf  ratio\n"
			"\n"
			"where ratio is the value of n-non-qf/n. These lines will be written whenever\n"
			"the ratio is >= the corresponding ratio for all higher values of n. If equality holds\n"
			"it will write '=' after the value of m.\n"
			"    The maximum allowed value of N is near 5*10^13. If -M is not passed, N is not\n"
			"allowed to be greater than 10^8.\n");
		return 0;
	}

	#define PrimeTop ((ullong)(PRIMEM*PRIMEM))
	typedef struct{
		ullong n, Q;
		long double redQ; //reduced Q. Only neede for very large values of n.
	} nQpair;

	char filename[40];
	ullong *Squares=NULL;
	ullong *Nextsq=NULL;
	ullong N;
	FILE *fQacum;
	nQpair *pairs=NULL;
	uchar *chunk=NULL;
	const uint chunk_usize=(CHUNK_SIZE*sizeof(chunk[0]))/sizeof(uint);
	uint npairs;

	N=atoll(argv[1+(bm!=0)]);
	if(N<1){puts("Error: value of N too small"); return 1;}
	if(N>PrimeTop*PrimeTop){puts("Error: value of N too large"); return 1;}
	if(bm<2 && N>100000000){puts("Error: value of N too large. For a value of N this large the option -M is mandatory"); return 1;}

	sprintf(filename,"Qacum-%llu.txt",N);
	fQacum=fopen(filename,"w");
	if(fQacum==NULL){printf("The file %s could not be created for writing. Aborting program.","Qacum.txt"); return 1;}


	/* Setup the constant arrays Squares, initialize Nextsq and reserve memory for the pairs*/

	//First, find the primes up to PrimeTop. They will be stored in the array 'Squares'.

	Squares=(ullong*)malloc(500000*sizeof(Squares[0]));	ifunlike(Squares==NULL) goto salida_nomem;
	Nextsq=(ullong*)malloc(500000*sizeof(Nextsq[0]));		ifunlike(Nextsq==NULL) goto salida_nomem;

	//Copy the primes allready known: those of PrimesM.
	{ullong *pS=Squares;
	{const uint *p=PrimesM; while(*p!=0) *pS++=*p++;}
	*pS=pS[-1]+2; //Next prime candidate

	//While finding the primes, pfin points one past the last prime that needs to be checked: <= sqrt(c)
	uint *pfin;

	//Setup the "next prime-multiple" array.
	{const uint c=(uint)*pS;
	const uint *p=PrimesM;
	uint *pn=NextPrime;
	while(*p**p<=c){
		*pn=c-1+*p-(c-1)%*p; //After this, *pn lies in [c,c+*p-1].
		if(!(*pn&1)) *pn+=*p; //*pn has to be the next odd multiple (p=2 will not be used)
		pn++, p++;
	}
	pfin=pn;
	//The primes at or above pfin need to be copied unaltered
	while(*p!=0) *pn++=*p++;
	*pn=0;
	}

	//Find the primes up to ptope. This has to be >= sqrt(N)
	uint ptope=1; for(ullong l=N;l!=0;l>>=2) ptope<<=1;
	//While finding the primes, PP stores the square of *pfin. When this value is reached by c the prime
	//at pfin needs to be added to the ones to be checked.
	{uint PP=*pfin**pfin;
	for(uint c=(uint)*pS; c<ptope; c+=2){
		unsigned char b=0;
		ifunlike(c==PP){ //One more prime square has been reached. (And therefore this number is not multiple of any other prime).
			*pfin=PP+(*pfin<<1); //*pfin must be set to the next multiple of the prime number to be checked. The prime number was in *pfin, still unaltered.
			pfin++;
			b=1;
			PP=*pfin**pfin;
		}else{
			for(uint *pn=&NextPrime[1];pn<pfin;pn++){
				if(*pn!=c) continue;
				b=1;
				*pn+=(PrimesM[pn-NextPrime]<<1); //Step to the next odd multiple
			}
		}
		if(!b) *pS++=c; //c is prime
	}}
	*pS=0;

	//Square the primes so that they become squares and copy the values in the next-square array
	{ullong *pN=Nextsq;
	for(pS=Squares; *pS!=0; pS++) *pS*=*pS, *pN++=*pS;
	*pN=0;}

	//Reserve memory for the pairs
	npairs=ptope+100; if(npairs>100000) npairs=100000;
	pairs=(nQpair*)malloc(npairs*sizeof(pairs[0]));
	ifunlike(pairs==NULL) goto salida_nomem;
	}

	//The arrays PrimesM and NextPrime will not be needed anymore

	/* End */

	//Reserve memory for the chunk
	chunk=(uchar*)malloc(CHUNK_SIZE*sizeof(chunk[0]));

	//Place a barreer at the top of the pairs stack: a faked maximum
	pairs[0].n=1; pairs[0].Q=1;
	//Pointer to within the array nextsq signalling the end of the squares to be checked
	ullong *pfin=Nextsq;
	nQpair *sp=pairs+1; //Always points to the first free position.
	ullong Q; //number of q-numbers found so far.

	ullong n, ntope=N; if(ntope>MULT_TOPE) ntope=MULT_TOPE;
	ullong chbot; //Bottom of chunk to be processed. The first value of the chunk is chbot+1
	ullong r900;
	const ullong *m900;

	Q=0;
	for(chbot=0; chbot<ntope; chbot+=CHUNK_SIZE){
		//Init. the chunk to zero
		{uint *p=(uint*)&chunk[0]; p[chunk_usize-1]=3; //mark the end
		do *p++=0; while(*p!=3); *p=0;}

		const ullong chtop=chbot+CHUNK_SIZE; //Highest value of the chunk to be processed now
		//From time to time, print the progress
		if(chbot!=0){
			ullong bl=chbot, tl=chtop;
			while(bl!=0) bl>>=1, tl>>=1;
			if(tl!=0) printf("%llu\n",chbot);
		}

		//Go through the primes whose squares enter in this chunk, one at a time.
		for(ullong *ps=Squares, *pt=Nextsq; *ps<=chtop; ps++, pt++){
			*pt-=chbot+1;
			while(*pt<CHUNK_SIZE){chunk[*pt]=1; *pt+=*ps;}
			*pt+=chbot+1;
		}

		//Sum up the total number of q-numbers
		uchar *pq=chunk;
		if(bm<2){
			for(ullong n=chbot+1; n<=chtop; n++){
				Q+=*pq++;
				fprintf(fQacum,"%llu %llu\n",n,Q);
			}
		}else{
			for(uint c=CHUNK_SIZE; c>=1;){c--; Q+=*pq++;}
		}

		//Find the maxima. They will be placed at the end of the memory reserved for pairs
		nQpair *pnew=pairs+npairs-1;
		pnew->n=1; pnew->Q=0; //So that the first pair to be checked compairs to true against this

		m900=mod900+nmod900; //Points to the next residue that needs checking
		r900=900; //The highest number of the chunk equals 0 mod 900.

		pq--; //Now pq points to chunk[CHUNK_SIZE-1].
		ullong n, nq;
		for(n=chtop, nq=Q; n>chbot; n--, r900--, nq-=*pq--){ //Skip the last pairs if the ratio is less than _pi6
			if(r900!=*m900) continue;
			if(nq>_pi6*n) break;
			ifunlike(*--m900==-1) m900=mod900+nmod900, r900+=900;
		}
		for(;n>chbot; n--, r900--, nq-=*pq--){
			if(r900!=*m900) continue;
			ifunlike(*--m900==-1) m900=mod900+nmod900, r900+=900;
			if(nq*pnew->n>=pnew->Q*n) *(--pnew)=(nQpair){n,nq};
		}

		//Move the maxima found to the bottom of the stack of maxima
		//Go up the stack of prevoious maxima
		 do sp--; while(pnew->Q*sp->n > sp->Q*pnew->n);
		++sp; //The pairs are to be placed from here
		while(pnew->Q!=0) *sp++=*pnew++;
	}

	//Multiplying n*Q as llongs is no longer possible.
	//Use long doubles from this point onwards and first reduce Q to redQ to gain precision.
	const long double lbound=411118/(long double)1048576; //The denominator is a power of two, viz. 2^20.
	for(nQpair *p=pairs; p<sp; p++) p->redQ=p->Q-lbound*p->n;
	//
	for(;chbot<N; chbot+=CHUNK_SIZE){
		//Init. the chunk to zero
		{uint *p=(uint*)&chunk[0]; p[chunk_usize-1]=3; //mark the end
		do *p++=0; while(*p!=3); *p=0;}

		const ullong chtop=chbot+CHUNK_SIZE; //Highest value of the chunk to be processed now
		//From time to time, print the progress
		{ullong bl=chbot, tl=chtop;
		while(bl!=0) bl>>=1, tl>>=1;
		if(tl!=0) printf("%llu\n",chbot);}

		//Go through the primes whose squares enter in this chunk, one at a time.
		for(ullong *ps=Squares, *pt=Nextsq; *ps<=chtop; ps++, pt++){
			*pt-=chbot+1;
			while(*pt<CHUNK_SIZE){chunk[*pt]=1; *pt+=*ps;}
			*pt+=chbot+1;
		}

		//Sum up the total number of q-numbers
		uchar *pq=chunk;
		for(uint c=CHUNK_SIZE; c>=1;){c--; Q+=*pq++;}

		//Find the maxima. They will be placed at the end of the memory reserved for pairs
		nQpair *pnew=pairs+npairs-1;
		pnew->n=1; pnew->Q=0; //So that the first pair to be checked compairs to true against this

		m900=mod900+nmod900; //Points to the next residue that needs checking
		r900=900; //The highest number of the chunk equals 0 mod 900.

		pq--; //Now pq points to chunk[CHUNK_SIZE-1].
		ullong n, nq;
		for(n=chtop, nq=Q; n>chbot; n--, r900--, nq-=*pq--){ //Skip the last pairs if the ratio is less than _pi6
			if(r900!=*m900) continue;
			if(nq>_pi6*n) break;
			ifunlike(*--m900==-1) m900=mod900+nmod900, r900+=900;
		}
		for(;n>chbot; n--, r900--, nq-=*pq--){
			if(r900!=*m900) continue;
			ifunlike(*--m900==-1) m900=mod900+nmod900, r900+=900;

			long double redQ=nq-n*lbound;
			if(redQ*pnew->n>=pnew->redQ*n) *(--pnew)=(nQpair){n,nq,redQ};
		}

		//Move the maxima found to the bottom of the stack of maxima
		//Go up the stack of prevoious maxima
		 do sp--; while(pnew->redQ*sp->n > sp->redQ*pnew->n);
		++sp; //The pairs are to be placed from here
		while(pnew->Q!=0) *sp++=*pnew++;
	}
	*sp=(nQpair){1,0}; //Marks the end

	//Print the maxima
	if(!bm) goto salida;

	if(bm<2) putc('\n',fQacum);
	for(nQpair *ptr=pairs+1; ptr->Q!=0 && ptr->n<=N; ptr++){
		fprintf(fQacum,"%llu %llu %.12f",ptr->n,ptr->Q,(double)ptr->Q/(double)ptr->n);
		int b;
		if(N<=MULT_TOPE) b=(ptr->Q*ptr[1].n==ptr[1].Q*ptr->n);
		else b=(ptr->redQ*ptr[1].n==ptr[1].redQ*ptr->n);
		ifunlike(b){putc(' ',fQacum); putc('=',fQacum);}
		putc('\n',fQacum);
	}

	goto salida;


salida_nomem: nret=-2;
	puts("Error: out of memory");
	goto salida;

salida:
	fclose(fQacum);
#define freeif(p) if(p!=NULL) free(p)
	freeif(chunk);
	freeif(pairs);
	freeif(Squares);
	freeif(Nextsq);
	return nret;
}
